/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.sar.business.opservice.debt;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.sar.common.enums.UpStatusEnum;

public class DebtDetailBillUpdataService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("fundorg");
        selector.add("upstatus");
        selector.add("updatator");
        selector.add("updatatime");
        selector.add("returndata");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<DynamicObject> details = new ArrayList<DynamicObject>(dataEntities.length);
        ArrayList<DynamicObject> funOrges = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            dataEntity.set("upstatus", (Object)UpStatusEnum.UPSUCESS.getValue());
            dataEntity.set("updatator", (Object)RequestContext.get().getCurrUserId());
            dataEntity.set("updatatime", (Object)DateUtils.getCurrentTime());
            dataEntity.set("returndata", (Object)"");
            details.add(dataEntity);
            funOrges.add(dataEntity.getDynamicObject("fundorg"));
        }
        if (EmptyUtil.isNoEmpty(details)) {
            TmcDataServiceHelper.save((DynamicObject[])details.toArray(new DynamicObject[0]));
        }
        this.updateFundOrg(funOrges);
    }

    private void updateFundOrg(List<DynamicObject> funOrges) {
        Object[] fundOrges;
        if (EmptyUtil.isEmpty(funOrges)) {
            return;
        }
        for (Object fundOrg : fundOrges = TmcDataServiceHelper.load((String)"mon_reportfundorg", (String)String.join((CharSequence)",", "debtlasteduptime", "debtlastedstatus"), (QFilter[])new QFilter[]{new QFilter("id", "in", funOrges.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()))})) {
            fundOrg.set("debtlasteduptime", (Object)DateUtils.getCurrentTime());
            fundOrg.set("debtlastedstatus", (Object)UpStatusEnum.UPSUCESS.getValue());
        }
        if (EmptyUtil.isNoEmpty((Object[])fundOrges)) {
            TmcDataServiceHelper.save((DynamicObject[])fundOrges);
        }
    }
}

