/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.sar.business.opservice.debt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.sar.business.opservice.debt.DebtDetailBillBean;
import kd.tmc.sar.business.service.debt.IDebtBillService;
import kd.tmc.sar.common.enums.BillSourceEnum;
import kd.tmc.sar.common.enums.TradeDateEnum;
import kd.tmc.sar.common.enums.UpStatusEnum;
import kd.tmc.sar.common.helper.LargeFundHelper;
import kd.tmc.sar.common.helper.LargeFundQueryHelper;
import kd.tmc.sar.servicehelper.ServiceFactory;

public class ReportFundOrgDebtQueryDataService
extends AbstractTmcBizOppService {
    private static final Log LOGGER = LogFactory.getLog(ReportFundOrgDebtQueryDataService.class);
    private boolean offInternalLoan;
    private Set<String> unitTextSet = new HashSet<String>(16);
    private Map<String, Date> dateMap = new HashMap<String, Date>(3);
    private int successCount = 0;

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("org");
        selector.add("insystem");
        selector.add("reportcontent");
        selector.add("applyall");
        selector.add("source");
        selector.add("accountentity");
        selector.add("accountentity.a_account");
        selector.add("accountentity.a_source");
        selector.add("collect");
        selector.add("collectionorgentity");
        selector.add("collectionorgentity.seq");
        selector.add("collectionorgentity.c_org");
        selector.add("debtreportcontent");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        String billStatusParam;
        String queryDateParam;
        Date queryDate = DateUtils.getCurrentDate();
        Map opVariMap = this.getOperationVariable();
        String queryDateSetStr = (String)opVariMap.get("tradeDate");
        if (EmptyUtil.isNoEmpty((String)queryDateSetStr)) {
            queryDate = DateUtils.stringToDate((String)queryDateSetStr, (String)"yyyy-MM-dd");
        }
        if (EmptyUtil.isNoEmpty((String)(queryDateParam = (String)opVariMap.get("querydate_param"))) && TradeDateEnum.YESTERDAY.getValue().equals(queryDateParam)) {
            queryDate = DateUtils.getLastDay((Date)DateUtils.getCurrentDate(), (int)1);
        }
        if (EmptyUtil.isEmpty((String)(billStatusParam = (String)opVariMap.get("billstatus_param")))) {
            billStatusParam = BillStatusEnum.AUDIT.getValue();
        }
        DynamicObject largeParamSet = LargeFundQueryHelper.getLargeParamSet();
        this.offInternalLoan = largeParamSet.getBoolean("offinternalloan");
        DynamicObjectCollection otherUnitSetEntities = largeParamSet.getDynamicObjectCollection("otherunitsetentity");
        this.unitTextSet = otherUnitSetEntities.stream().map(d -> d.getString("unittext")).collect(Collectors.toSet());
        LOGGER.info("DebtDetail.unitTextSet: {}", this.unitTextSet);
        Set<String> statusTs = this.getStatusTs(queryDate);
        LOGGER.info("DebtDetail.statusTs: {}", statusTs);
        this.dateMap = LargeFundHelper.calPeriod((Date)queryDate, (DynamicObject)largeParamSet);
        LOGGER.info("DebtDetail.dateMap: {}", this.dateMap);
        ArrayList<DebtDetailBillBean> debtDetailBillBeanList = new ArrayList<DebtDetailBillBean>(16);
        for (DynamicObject reportOrgSet : dataEntities) {
            DynamicObject headOrg = reportOrgSet.getDynamicObject("org");
            List<IDebtBillService> debtReportContent = this.getDebtReportContent(reportOrgSet);
            if (!reportOrgSet.getBoolean("insystem") || headOrg == null || EmptyUtil.isEmpty(debtReportContent)) continue;
            this.deleteSaveBill(reportOrgSet, queryDate);
            debtDetailBillBeanList.addAll(this.queryBizData(reportOrgSet, debtReportContent, statusTs));
        }
        this.successCount = this.genDebtDetailBill(debtDetailBillBeanList, billStatusParam);
    }

    public void onReturnOperation(IOperationResult e) throws KDException {
        super.onReturnOperation(e);
        if (this.getOperationResult().isSuccess() && EmptyUtil.isNoEmpty((Integer)this.successCount)) {
            e.setMessage(this.successCount + "");
            this.successCount = 0;
        }
    }

    private void deleteSaveBill(DynamicObject reportOrgSet, Date queryDate) {
        QFilter deleteFilter = new QFilter("bizdate", "=", (Object)queryDate);
        deleteFilter.and("fundorg", "=", reportOrgSet.getPkValue());
        deleteFilter.and("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue());
        DeleteServiceHelper.delete((String)"sar_debtdetail", (QFilter[])deleteFilter.toArray());
    }

    private Set<String> getStatusTs(Date queryDate) {
        QFilter billStatusFilter = new QFilter("bizdate", "=", (Object)queryDate);
        billStatusFilter.and(new QFilter("billstatus", "in", Arrays.asList(BillStatusEnum.SUBMIT.getValue(), BillStatusEnum.AUDIT.getValue())));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"sar_debtdetail", (String)"src_entryentity.src_billno", (QFilter[])billStatusFilter.toArray());
        return query.stream().filter(o -> EmptyUtil.isNoEmpty((String)o.getString("src_entryentity.src_billno"))).map(d -> d.getString("src_entryentity.src_billno")).collect(Collectors.toSet());
    }

    private List<IDebtBillService> getDebtReportContent(DynamicObject reportOrgSet) {
        ArrayList<IDebtBillService> billTypes = new ArrayList<IDebtBillService>(4);
        String content = reportOrgSet.getString("debtreportcontent");
        if (EmptyUtil.isNoEmpty((String)content)) {
            String[] splits;
            for (String split : splits = content.split(",")) {
                if (!EmptyUtil.isNoEmpty((String)split)) continue;
                billTypes.add((IDebtBillService)ServiceFactory.getService((String)split));
            }
        }
        return billTypes;
    }

    private List<DebtDetailBillBean> queryBizData(DynamicObject reportOrgSet, List<IDebtBillService> debtReportContent, Set<String> statusTs) {
        Set<Long> orgSet = this.collectOrg(reportOrgSet);
        Map amtByOrg = LargeFundQueryHelper.getDebtAmtByOrg((DynamicObject)reportOrgSet);
        ArrayList<DebtDetailBillBean> debtDetailBillBeanList = new ArrayList<DebtDetailBillBean>(16);
        for (IDebtBillService service : debtReportContent) {
            if (service == null) continue;
            debtDetailBillBeanList.addAll(service.queryBizData(reportOrgSet, statusTs, orgSet, amtByOrg, this.offInternalLoan, this.unitTextSet, this.dateMap));
        }
        return debtDetailBillBeanList;
    }

    private Set<Long> collectOrg(DynamicObject reportOrgSet) {
        DynamicObject org = reportOrgSet.getDynamicObject("org");
        HashSet<Long> orgSet = new HashSet<Long>(16);
        orgSet.add(org.getLong("id"));
        if (reportOrgSet.getBoolean("collect")) {
            DynamicObjectCollection cOrgEntities = reportOrgSet.getDynamicObjectCollection("collectionorgentity");
            for (DynamicObject cOrg : cOrgEntities) {
                orgSet.add(cOrg.getDynamicObject("c_org").getLong("id"));
            }
        }
        return orgSet;
    }

    private int genDebtDetailBill(List<DebtDetailBillBean> debtDetailBillBeanList, String billStatusParam) {
        if (EmptyUtil.isEmpty(debtDetailBillBeanList)) {
            return 0;
        }
        List<DynamicObject> saveDebtDetailBillList = debtDetailBillBeanList.stream().map(bean -> {
            DynamicObject newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sar_debtdetail");
            newDynamicObject.set("billno", (Object)CodeRuleHelper.generateNumber((String)"sar_debtdetail", (DynamicObject)newDynamicObject, (String)"", (String)""));
            newDynamicObject.set("billstatus", (Object)(BillStatusEnum.SAVE.getValue().equals(billStatusParam) ? billStatusParam : BillStatusEnum.SUBMIT.getValue()));
            newDynamicObject.set("fundorg", (Object)bean.getFundOrg());
            newDynamicObject.set("bizdate", (Object)bean.getBizDate());
            newDynamicObject.set("reportperiod_startdate", (Object)bean.getStartDate());
            newDynamicObject.set("reportperiod_enddate", (Object)bean.getEndDate());
            newDynamicObject.set("upstatus", (Object)UpStatusEnum.WAITUP.getValue());
            newDynamicObject.set("billtype", (Object)bean.getBillType());
            newDynamicObject.set("debtbillno", (Object)bean.getDebtBillNo());
            newDynamicObject.set("debttype", (Object)bean.getDebtType());
            newDynamicObject.set("debtorg", (Object)bean.getDebtOrg());
            newDynamicObject.set("upcurrency", (Object)bean.getUpCurrency());
            newDynamicObject.set("debtcapitalamt", (Object)bean.getDebtCapitalAmt());
            newDynamicObject.set("creditortext", (Object)bean.getCreditorText());
            newDynamicObject.set("debtinterestrate", (Object)bean.getDebtInterestRate());
            newDynamicObject.set("debtbizdata", (Object)bean.getDebtBizData());
            newDynamicObject.set("expiredate", (Object)bean.getExpireDate());
            newDynamicObject.set("currentexpireamt", (Object)bean.getCurrentExpireAmt());
            newDynamicObject.set("currentexpiredate", (Object)bean.getCurrentExpireDate());
            newDynamicObject.set("isrepay", (Object)"1");
            newDynamicObject.set("source", (Object)BillSourceEnum.SYSTEM.getValue());
            DynamicObjectCollection srcEntryEntity = newDynamicObject.getDynamicObjectCollection("src_entryentity");
            List<DebtDetailBillBean.EntryEntity> beanSrcEntryEntity = bean.getSrcEntryEntity();
            for (DebtDetailBillBean.EntryEntity beanSrcEntity : beanSrcEntryEntity) {
                DynamicObject newSrcDynamicObject = srcEntryEntity.addNew();
                newSrcDynamicObject.set("src_billtype", (Object)beanSrcEntity.getSrcBillType());
                newSrcDynamicObject.set("src_billno", (Object)beanSrcEntity.getSrcBillNo());
                newSrcDynamicObject.set("src_debtor", (Object)beanSrcEntity.getSrcDebtor());
                newSrcDynamicObject.set("src_currency", (Object)beanSrcEntity.getSrcCurrency());
                newSrcDynamicObject.set("src_amount", (Object)beanSrcEntity.getSrcAmount());
                newSrcDynamicObject.set("src_creditor", (Object)beanSrcEntity.getSrcCreditor());
                newSrcDynamicObject.set("src_startdate", (Object)beanSrcEntity.getSrcStartDate());
                newSrcDynamicObject.set("src_enddate", (Object)beanSrcEntity.getSrcEndDate());
            }
            return newDynamicObject;
        }).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(saveDebtDetailBillList)) {
            TmcDataServiceHelper.save((DynamicObject[])saveDebtDetailBillList.toArray(new DynamicObject[0]));
            Object[] ids = saveDebtDetailBillList.stream().map(DataEntityBase::getPkValue).toArray();
            if (BillStatusEnum.AUDIT.getValue().equals(billStatusParam)) {
                TmcOperateServiceHelper.execOperate((String)"audit", (String)"sar_debtdetail", (Object[])ids, (OperateOption)OperateOption.create());
            }
        }
        return saveDebtDetailBillList.size();
    }
}

