/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.sar.business.opservice.largefunddetail;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.sar.business.opservice.largefunddetail.LargeFundDealBean;
import kd.tmc.sar.common.builder.LargeFundQueryFieldBuilder;
import kd.tmc.sar.common.enums.LargeDirectionEnum;
import kd.tmc.sar.common.enums.TradeDateEnum;
import kd.tmc.sar.common.helper.LargeFundQueryHelper;
import kd.tmc.sar.common.helper.LargeFundUseMatchHelper;
import org.apache.commons.lang3.tuple.Pair;

public class ReportFundOrgDetailQueryDataService
extends AbstractTmcBizOppService {
    private static final Log LOGGER = LogFactory.getLog(ReportFundOrgDetailQueryDataService.class);
    private boolean merge;
    private boolean offInternal;
    private Set<String> unitTextSet = new HashSet<String>(16);
    private int successCount = 0;

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("org");
        selector.add("insystem");
        selector.add("reportcontent");
        selector.add("applyall");
        selector.add("source");
        selector.add("accountentity");
        selector.add("accountentity.a_account");
        selector.add("accountentity.a_source");
        selector.add("collect");
        selector.add("collectionorgentity");
        selector.add("collectionorgentity.seq");
        selector.add("collectionorgentity.c_org");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        String billStatusParam;
        String queryDateParam;
        Date queryDate = DateUtils.getCurrentDate();
        Map opVariMap = this.getOperationVariable();
        String queryDateSetStr = (String)opVariMap.get("tradeDate");
        if (EmptyUtil.isNoEmpty((String)queryDateSetStr)) {
            queryDate = DateUtils.stringToDate((String)queryDateSetStr, (String)"yyyy-MM-dd");
        }
        if (EmptyUtil.isNoEmpty((String)(queryDateParam = (String)opVariMap.get("querydate_param"))) && TradeDateEnum.YESTERDAY.getValue().equals(queryDateParam)) {
            queryDate = DateUtils.getLastDay((Date)DateUtils.getCurrentDate(), (int)1);
        }
        if (EmptyUtil.isEmpty((String)(billStatusParam = (String)opVariMap.get("billstatus_param")))) {
            billStatusParam = BillStatusEnum.AUDIT.getValue();
        }
        DynamicObject largeParamSet = LargeFundQueryHelper.getLargeParamSet();
        this.offInternal = largeParamSet.getBoolean("offinternal");
        this.merge = largeParamSet.getBoolean("merge");
        DynamicObjectCollection otherUnitSetEntities = largeParamSet.getDynamicObjectCollection("otherunitsetentity");
        this.unitTextSet = otherUnitSetEntities.stream().map(d -> d.getString("unittext")).collect(Collectors.toSet());
        Set<String> statusTs = this.getStatusTs(queryDate);
        ArrayList<LargeFundDealBean> largeFundDealBeanList = new ArrayList<LargeFundDealBean>(dataEntities.length);
        for (DynamicObject reportOrgSet : dataEntities) {
            if (reportOrgSet.getDynamicObject("org") == null) continue;
            QFilter deleteFilter = new QFilter("bizdate", "=", (Object)queryDate);
            deleteFilter.and("fundorg", "=", reportOrgSet.getPkValue());
            deleteFilter.and("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue());
            DeleteServiceHelper.delete((String)"mon_largefunddetail", (QFilter[])deleteFilter.toArray());
            ArrayList<DynamicObject> orgs = new ArrayList<DynamicObject>(16);
            orgs.add(reportOrgSet.getDynamicObject("org"));
            if (reportOrgSet.getBoolean("collect")) {
                DynamicObjectCollection cOrgEntities = reportOrgSet.getDynamicObjectCollection("collectionorgentity");
                orgs.addAll(cOrgEntities.stream().map(c -> c.getDynamicObject("c_org")).collect(Collectors.toList()));
            }
            String reportContent = reportOrgSet.getString("reportcontent");
            Map amtByOrg = LargeFundQueryHelper.getFundThresholdAmtByOrg((DynamicObject)reportOrgSet);
            if (reportOrgSet.getBoolean("applyall")) {
                String queryResource = reportOrgSet.getString("source");
                Map<String, String> resouceListBySet = this.getResouceAmtPropBySet(reportContent, queryResource);
                for (Map.Entry<String, String> entry : resouceListBySet.entrySet()) {
                    String resource = entry.getKey();
                    String amtFields = entry.getValue();
                    largeFundDealBeanList.addAll(this.queryBizData(reportOrgSet, orgs, queryDate, resource, amtFields, amtByOrg, statusTs, 0L));
                }
                continue;
            }
            DynamicObjectCollection entrys = reportOrgSet.getDynamicObjectCollection("accountentity");
            for (DynamicObject entry : entrys) {
                String queryResource = entry.getString("a_source");
                DynamicObject aAccount = entry.getDynamicObject("a_account");
                Map<String, String> resouceListBySet = this.getResouceAmtPropBySet(reportContent, queryResource);
                for (Map.Entry<String, String> sourceEntry : resouceListBySet.entrySet()) {
                    String resource = sourceEntry.getKey();
                    String amtFields = sourceEntry.getValue();
                    largeFundDealBeanList.addAll(this.queryBizData(reportOrgSet, orgs, queryDate, resource, amtFields, amtByOrg, statusTs, aAccount.getLong("id")));
                }
            }
        }
        this.successCount = this.genFundDetailBill(largeFundDealBeanList, billStatusParam);
    }

    public void onReturnOperation(IOperationResult e) throws KDException {
        super.onReturnOperation(e);
        if (this.getOperationResult().isSuccess() && EmptyUtil.isNoEmpty((Integer)this.successCount)) {
            e.setMessage(this.successCount + "");
            this.successCount = 0;
        }
    }

    private List<LargeFundDealBean> queryBizData(DynamicObject reportOrgSet, List<DynamicObject> orgs, Date queryDate, String resource, String amtFields, Map<Long, Pair<Long, BigDecimal>> amtByOrg, Set<String> statusTs, Long acctBankId) {
        String amtFieldsDirect;
        String entityName;
        LargeFundQueryFieldBuilder fundQureyFieldObj = LargeFundQueryFieldBuilder.getFundQureyFieldObj((String)resource);
        List orgIds = orgs.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        QFilter filter = new QFilter(fundQureyFieldObj.getOrg(), "in", orgIds).and(fundQureyFieldObj.getTradeDate(), ">=", (Object)DateUtils.getDataFormat((Date)queryDate, (boolean)true)).and(fundQureyFieldObj.getTradeDate(), "<=", (Object)DateUtils.getDataFormat((Date)queryDate, (boolean)false)).and(new QFilter(fundQureyFieldObj.getSrcbillno(), "!=", (Object)" ").and(fundQureyFieldObj.getSrcbillno(), "!=", (Object)""));
        if (EmptyUtil.isNoEmpty((Long)acctBankId)) {
            filter.and(new QFilter(fundQureyFieldObj.getAcctBank(), "=", (Object)acctBankId));
        }
        if ("cas_recbill".equals(entityName = fundQureyFieldObj.getEntityName()) || "cas_paybill".equals(entityName)) {
            filter.and("billstatus", "=", (Object)BillStatusEnum.PAYED.getValue());
        }
        QFilter inCurrencyFilter = "pay".equals(amtFieldsDirect = this.getDirect(amtFields, fundQureyFieldObj)) ? new QFilter(fundQureyFieldObj.getPayAmt(), ">", (Object)0) : ("rec".equals(amtFieldsDirect) ? new QFilter(fundQureyFieldObj.getRecAmt(), ">", (Object)0) : new QFilter(fundQureyFieldObj.getRecAmt(), ">", (Object)0).or(fundQureyFieldObj.getPayAmt(), ">", (Object)0));
        filter.and(inCurrencyFilter);
        if (this.offInternal) {
            this.unitTextSet.addAll(LargeFundQueryHelper.getBankRoll());
            filter.and(new QFilter(fundQureyFieldObj.getOppUnit(), "not in", this.unitTextSet));
        }
        LOGGER.info("FundDetail: statusTs:{}", statusTs);
        if (EmptyUtil.isNoEmpty(statusTs) && statusTs.size() > 0) {
            filter.and(new QFilter(fundQureyFieldObj.getSrcbillno(), "not in", statusTs));
        }
        LOGGER.info("FundDetail: bizDataFilter:{}", (Object)filter.toString());
        DynamicObjectCollection resultDatas = QueryServiceHelper.query((String)entityName, (String)LargeFundQueryFieldBuilder.getbizBillQueryFileds((LargeFundQueryFieldBuilder)fundQureyFieldObj, (String)amtFields), (QFilter[])filter.toArray());
        if (resultDatas.size() == 0) {
            return new ArrayList<LargeFundDealBean>(10);
        }
        LOGGER.info("FundDetail: resultDatas:" + resultDatas.size());
        return this.initLargeFundDealBean(fundQureyFieldObj, resultDatas, amtFieldsDirect, resource, reportOrgSet, amtByOrg, queryDate, filter);
    }

    private List<LargeFundDealBean> initLargeFundDealBean(LargeFundQueryFieldBuilder fundQureyFieldObj, DynamicObjectCollection resultDatas, String amtFieldsDirect, String resource, DynamicObject reportOrgSet, Map<Long, Pair<Long, BigDecimal>> amtByOrg, Date queryDate, QFilter filter) {
        long funduse = 0L;
        ArrayList<LargeFundDealBean> largeFundDealBeanList = new ArrayList<LargeFundDealBean>(resultDatas.size());
        Pair<Long, BigDecimal> pair = amtByOrg.get(999L);
        long upCurrency = (Long)pair.getKey();
        BigDecimal threshold = ((BigDecimal)pair.getValue()).multiply(Constants.TEN_THOUSAND);
        String entityName = fundQureyFieldObj.getEntityName();
        String bizBillSelectFields = LargeFundQueryFieldBuilder.getBizBillSelectFields((String)entityName);
        LOGGER.info("bizBillSelectFields:{}", (Object)bizBillSelectFields);
        DynamicObjectCollection matchData = QueryServiceHelper.query((String)entityName, (String)bizBillSelectFields, (QFilter[])filter.toArray());
        Map matchResult = LargeFundUseMatchHelper.getMatchResult((String)entityName, (DynamicObjectCollection)matchData);
        for (DynamicObject resultData : resultDatas) {
            long id = resultData.getLong("id");
            DynamicObject billResult = (DynamicObject)matchResult.get(id);
            if (billResult != null) {
                Pair<Long, BigDecimal> decimalPair = amtByOrg.get(billResult.getLong("id"));
                funduse = billResult.getLong("id");
                if (decimalPair != null) {
                    LOGGER.info("FundDetail: decimalPair:{}", (Object)decimalPair.toString());
                    upCurrency = (Long)decimalPair.getKey();
                    threshold = ((BigDecimal)decimalPair.getValue()).multiply(Constants.TEN_THOUSAND);
                }
            }
            long currency = resultData.getLong(fundQureyFieldObj.getCurrency());
            String direct = this.getBillRealDirect(resultData, fundQureyFieldObj, amtFieldsDirect);
            BigDecimal billBalance = LargeDirectionEnum.ALL.getValue().equals(amtFieldsDirect) ? (EmptyUtil.isNoEmpty((BigDecimal)resultData.getBigDecimal(fundQureyFieldObj.getPayAmt())) ? resultData.getBigDecimal(fundQureyFieldObj.getPayAmt()) : resultData.getBigDecimal(fundQureyFieldObj.getRecAmt())) : (LargeDirectionEnum.PAY.getValue().equals(amtFieldsDirect) ? resultData.getBigDecimal(fundQureyFieldObj.getPayAmt()) : resultData.getBigDecimal(fundQureyFieldObj.getRecAmt()));
            BigDecimal rate = LargeFundQueryHelper.getRate((Long)currency, (Long)upCurrency, (Long)resultData.getLong(fundQureyFieldObj.getOrg()));
            BigDecimal billAmt = billBalance.multiply(rate).setScale(20, 4);
            if (!this.merge && billAmt.compareTo(threshold) < 0) continue;
            LargeFundDealBean fundDealBean = new LargeFundDealBean();
            fundDealBean.setFundOrg(reportOrgSet.getLong("id"));
            fundDealBean.setOrg(resultData.getLong(fundQureyFieldObj.getOrg()));
            fundDealBean.setTradeDate(queryDate);
            fundDealBean.setUpCurrency(upCurrency);
            fundDealBean.setCombineGen(this.merge);
            fundDealBean.setThresholdamt(threshold);
            fundDealBean.setDirection(direct);
            fundDealBean.setOppunitType("fbd_other");
            fundDealBean.setOppunitText(resultData.getString(fundQureyFieldObj.getOppUnit()));
            fundDealBean.setFunuse(funduse);
            fundDealBean.seteCurrency(currency);
            fundDealBean.seteDetailamt(billBalance);
            if (currency == upCurrency) {
                fundDealBean.seteRate(BigDecimal.ONE);
                fundDealBean.seteAgreedquotation("0");
                fundDealBean.seteDiscountamt(billBalance);
            } else {
                fundDealBean.seteRate(rate);
                fundDealBean.seteAgreedquotation("0");
                fundDealBean.seteDiscountamt(billAmt);
            }
            fundDealBean.seteSource(resource);
            fundDealBean.seteScrbillno(resultData.getString(fundQureyFieldObj.getSrcbillno()));
            fundDealBean.seteDesc(resultData.getString(fundQureyFieldObj.getRemark()));
            largeFundDealBeanList.add(fundDealBean);
        }
        return largeFundDealBeanList;
    }

    private String getBillRealDirect(DynamicObject resultData, LargeFundQueryFieldBuilder fundQureyFieldObj, String amtFieldsDirect) {
        String entityName;
        switch (entityName = fundQureyFieldObj.getEntityName()) {
            case "cas_recbill": {
                return "rec";
            }
            case "bei_transdetail": 
            case "cas_bankjournal": {
                if ("all".equals(amtFieldsDirect)) {
                    if (EmptyUtil.isNoEmpty((BigDecimal)resultData.getBigDecimal(fundQureyFieldObj.getRecAmt()))) {
                        return "rec";
                    }
                    return "pay";
                }
                return amtFieldsDirect;
            }
        }
        return "pay";
    }

    private String getDirect(String direction, LargeFundQueryFieldBuilder fundQureyFieldObj) {
        String entityName = fundQureyFieldObj.getEntityName();
        switch (direction) {
            case "debitamount": {
                if ("cas_bankjournal".equals(entityName)) {
                    return "rec";
                }
                return "pay";
            }
            case "actpayamt": {
                return "pay";
            }
            case "creditamount": {
                if ("cas_bankjournal".equals(entityName)) {
                    return "pay";
                }
                return "rec";
            }
            case "actrecamt": {
                return "rec";
            }
        }
        return "all";
    }

    private Map<String, String> getResouceAmtPropBySet(String reportContent, String queryResource) {
        HashMap<String, String> result = new HashMap<String, String>();
        block5 : switch (reportContent) {
            case "pay": {
                switch (queryResource) {
                    case "online": {
                        result.put("transdetail", "debitamount");
                        break block5;
                    }
                    case "bankjournal": {
                        result.put("bankjournal", "creditamount");
                        break block5;
                    }
                    case "rpbill": {
                        result.put("paybill", "actpayamt");
                        break block5;
                    }
                }
                break;
            }
            case "rec": {
                switch (queryResource) {
                    case "online": {
                        result.put("transdetail", "creditamount");
                        break block5;
                    }
                    case "bankjournal": {
                        result.put("bankjournal", "debitamount");
                        break block5;
                    }
                    case "rpbill": {
                        result.put("recbill", "actrecamt");
                        break block5;
                    }
                }
                break;
            }
            case "all": {
                switch (queryResource) {
                    case "online": {
                        result.put("transdetail", "debitamount,creditamount");
                        break block5;
                    }
                    case "bankjournal": {
                        result.put("bankjournal", "debitamount,creditamount");
                        break block5;
                    }
                    case "rpbill": {
                        result.put("paybill", "actpayamt");
                        result.put("recbill", "actrecamt");
                        break block5;
                    }
                }
                break;
            }
        }
        return result;
    }

    private int genFundDetailBill(List<LargeFundDealBean> largeFundDealBeans, String billStatusParam) {
        Map<String, List<LargeFundDealBean>> collect;
        if (largeFundDealBeans.size() == 0) {
            return 0;
        }
        ArrayList<DynamicObject> saveFundDeal = new ArrayList<DynamicObject>(largeFundDealBeans.size());
        if (this.merge) {
            for (LargeFundDealBean bean : largeFundDealBeans) {
                bean.setConbimeVal(String.valueOf(bean.getOrg()) + bean.getTradeDate() + bean.getDirection() + bean.getOppunitText() + bean.getFunuse());
            }
            collect = largeFundDealBeans.stream().collect(Collectors.groupingBy(LargeFundDealBean::getConbimeVal));
            ArrayList<Long> org = new ArrayList<Long>(16);
            ArrayList<Date> tradeDate = new ArrayList<Date>(16);
            ArrayList<String> direction = new ArrayList<String>(16);
            ArrayList<String> oppUnit = new ArrayList<String>(16);
            ArrayList<Long> funduse = new ArrayList<Long>(16);
            HashSet<String> removeKey = new HashSet<String>(16);
            for (Map.Entry<String, List<LargeFundDealBean>> entry : collect.entrySet()) {
                List<LargeFundDealBean> value = entry.getValue();
                if (value.size() == 0) continue;
                BigDecimal sumAmt = BigDecimal.ZERO;
                for (LargeFundDealBean largeFundDealBean : value) {
                    sumAmt = sumAmt.add(largeFundDealBean.geteDiscountamt());
                }
                if (sumAmt.compareTo(value.get(0).getThresholdamt()) < 0) {
                    removeKey.add(entry.getKey());
                    continue;
                }
                LargeFundDealBean fundDealBean = value.get(0);
                org.add(fundDealBean.getOrg());
                tradeDate.add(fundDealBean.getTradeDate());
                direction.add(fundDealBean.getDirection());
                oppUnit.add(fundDealBean.getOppunitText());
                funduse.add(fundDealBean.getFunuse());
            }
            collect.keySet().removeAll(removeKey);
            if (EmptyUtil.isEmpty(collect)) {
                return 0;
            }
            QFilter qFilter = new QFilter("entryentity.e_org", "in", org);
            qFilter.and("bizdate", "in", tradeDate);
            qFilter.and("direction", "in", direction);
            qFilter.and("oppunittext", "in", oppUnit);
            qFilter.and("funuse", "in", funduse);
            qFilter.and("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue());
            DeleteServiceHelper.delete((String)"mon_largefunddetail", (QFilter[])qFilter.toArray());
            for (Map.Entry<String, List<LargeFundDealBean>> listEntry : collect.entrySet()) {
                this.buildLargeFundDeal(listEntry.getValue(), saveFundDeal, billStatusParam);
            }
        } else {
            collect = largeFundDealBeans.stream().collect(Collectors.groupingBy(LargeFundDealBean::geteScrbillno));
            Set<String> billnos = collect.keySet();
            QFilter qFilter = new QFilter("entryentity.e_scrbillno", "in", billnos);
            qFilter.and("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue());
            DeleteServiceHelper.delete((String)"mon_largefunddetail", (QFilter[])qFilter.toArray());
            for (Map.Entry<String, List<LargeFundDealBean>> listEntry : collect.entrySet()) {
                this.buildLargeFundDeal(listEntry.getValue(), saveFundDeal, billStatusParam);
            }
        }
        if (EmptyUtil.isNoEmpty(saveFundDeal)) {
            TmcDataServiceHelper.save((DynamicObject[])saveFundDeal.toArray(new DynamicObject[0]));
            Object[] ids = saveFundDeal.stream().map(DataEntityBase::getPkValue).toArray();
            if (BillStatusEnum.AUDIT.getValue().equals(billStatusParam)) {
                TmcOperateServiceHelper.execOperate((String)"audit", (String)"mon_largefunddetail", (Object[])ids, (OperateOption)OperateOption.create());
            }
        }
        return saveFundDeal.size();
    }

    private void buildLargeFundDeal(List<LargeFundDealBean> largeFundDealBeanList, List<DynamicObject> saveFundDeal, String billStatusParam) {
        LargeFundDealBean fundDealBean = largeFundDealBeanList.get(0);
        DynamicObject newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"mon_largefunddetail");
        newDynamicObject.set("billno", (Object)CodeRuleHelper.generateNumber((String)"mon_largefunddetail", (DynamicObject)newDynamicObject, (String)"", (String)""));
        newDynamicObject.set("billstatus", (Object)(BillStatusEnum.SAVE.getValue().equals(billStatusParam) ? billStatusParam : BillStatusEnum.SUBMIT.getValue()));
        newDynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        newDynamicObject.set("createtime", (Object)TimeServiceHelper.now());
        newDynamicObject.set("fundorg", (Object)fundDealBean.getFundOrg());
        newDynamicObject.set("bizdate", (Object)fundDealBean.getTradeDate());
        newDynamicObject.set("upcurrency", (Object)fundDealBean.getUpCurrency());
        newDynamicObject.set("upstatus", (Object)"waitup");
        newDynamicObject.set("combinegen", (Object)(largeFundDealBeanList.size() > 1 ? 1 : 0));
        newDynamicObject.set("direction", (Object)fundDealBean.getDirection());
        newDynamicObject.set("thresholdamt", (Object)fundDealBean.getThresholdamt());
        newDynamicObject.set("oppunittype", (Object)fundDealBean.getOppunitType());
        newDynamicObject.set("oppunit", (Object)fundDealBean.getOppUnit());
        newDynamicObject.set("oppunittext", (Object)fundDealBean.getOppunitText());
        newDynamicObject.set("funuse", (Object)fundDealBean.getFunuse());
        newDynamicObject.set("source", (Object)"1");
        DynamicObjectCollection entryentity = newDynamicObject.getDynamicObjectCollection("entryentity");
        BigDecimal convertamt = BigDecimal.ZERO;
        int index = 1;
        for (LargeFundDealBean entity : largeFundDealBeanList) {
            DynamicObject dynamicObject = entryentity.addNew();
            dynamicObject.set("seq", (Object)index++);
            dynamicObject.set("e_org", (Object)entity.getOrg());
            dynamicObject.set("e_currency", (Object)entity.geteCurrency());
            BigDecimal decimal = entity.geteDiscountamt();
            convertamt = convertamt.add(decimal);
            dynamicObject.set("e_detailamt", (Object)entity.geteDetailamt());
            dynamicObject.set("e_rate", (Object)entity.geteRate());
            dynamicObject.set("e_agreedquotation", (Object)entity.geteAgreedquotation());
            dynamicObject.set("e_discountamt", (Object)entity.geteDiscountamt());
            dynamicObject.set("e_source", (Object)entity.geteSource());
            dynamicObject.set("e_scrbillno", (Object)entity.geteScrbillno());
            dynamicObject.set("e_desc", (Object)entity.geteDesc());
        }
        newDynamicObject.set("convertamt", (Object)convertamt);
        saveFundDeal.add(newDynamicObject);
    }

    private Set<String> getStatusTs(Date queryDate) {
        QFilter billStatusFilter = new QFilter("bizdate", "=", (Object)queryDate);
        billStatusFilter.and(new QFilter("billstatus", "in", Arrays.asList(BillStatusEnum.SUBMIT.getValue(), BillStatusEnum.AUDIT.getValue())));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"mon_largefunddetail", (String)"entryentity.e_scrbillno", (QFilter[])billStatusFilter.toArray());
        return query.stream().filter(o -> EmptyUtil.isNoEmpty((String)o.getString("entryentity.e_scrbillno"))).map(d -> d.getString("entryentity.e_scrbillno")).collect(Collectors.toSet());
    }
}

