/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.sar.business.opservice.summary;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.sar.business.opservice.summary.FundSumBillBean;
import kd.tmc.sar.common.builder.LargeFundQueryFieldBuilder;
import kd.tmc.sar.common.enums.BillSourceEnum;
import kd.tmc.sar.common.enums.LargeDirectionEnum;
import kd.tmc.sar.common.enums.TradeDateEnum;
import kd.tmc.sar.common.enums.UpStatusEnum;
import kd.tmc.sar.common.helper.LargeFundQueryHelper;

public class ReportFundOrgSumQueryDataService
extends AbstractTmcBizOppService {
    private static final Log LOGGER = LogFactory.getLog(ReportFundOrgSumQueryDataService.class);
    private static final String LARGESUM_SET = "id,billno,billstatus";
    private static final String LARGEDETAIL_SET = "id,direction,billstatus,convertamt";
    private static final String BALANCE_SET = "id,company,accountbank,currency,amount";
    private static final String CAS_MGTINIT_SET = "id,startperiod,standardcurrency.id";
    private static final String CAS_JOURNAL_BALANCE_SET = "id, currency, monthstart";
    private static final String CAS_BANK_JOURNAL_SET = "currency.id,debitamount,creditamount";
    private boolean offInternal;
    private Set<String> unitTextSet = new HashSet<String>(16);
    private int successCount = 0;

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("org");
        selector.add("insystem");
        selector.add("reportcontent");
        selector.add("applyall");
        selector.add("source");
        selector.add("accountentity");
        selector.add("accountentity.a_account");
        selector.add("accountentity.a_source");
        selector.add("collect");
        selector.add("collectionorgentity");
        selector.add("collectionorgentity.seq");
        selector.add("collectionorgentity.c_org");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        String billStatusParam;
        String queryDateParam;
        Date queryDate = DateUtils.getCurrentDate();
        Map opVariMap = this.getOperationVariable();
        String queryDateSetStr = (String)opVariMap.get("tradeDate");
        if (EmptyUtil.isNoEmpty((String)queryDateSetStr)) {
            queryDate = DateUtils.stringToDate((String)queryDateSetStr, (String)"yyyy-MM-dd");
        }
        if (EmptyUtil.isNoEmpty((String)(queryDateParam = (String)opVariMap.get("querydate_param"))) && TradeDateEnum.YESTERDAY.getValue().equals(queryDateParam)) {
            queryDate = DateUtils.getLastDay((Date)DateUtils.getCurrentDate(), (int)1);
        }
        if (EmptyUtil.isEmpty((String)(billStatusParam = (String)opVariMap.get("billstatus_param")))) {
            billStatusParam = BillStatusEnum.AUDIT.getValue();
        }
        DynamicObject largeParamSet = LargeFundQueryHelper.getLargeParamSet();
        this.offInternal = largeParamSet.getBoolean("offinternal");
        DynamicObjectCollection otherUnitSetEntities = largeParamSet.getDynamicObjectCollection("otherunitsetentity");
        this.unitTextSet = otherUnitSetEntities.stream().map(d -> d.getString("unittext")).collect(Collectors.toSet());
        ArrayList<FundSumBillBean> fundSumBillBeans = new ArrayList<FundSumBillBean>(16);
        for (DynamicObject reportOrgSet : dataEntities) {
            DynamicObject headOrg = reportOrgSet.getDynamicObject("org");
            if (!reportOrgSet.getBoolean("insystem") || headOrg == null || this.existFundSumBill(reportOrgSet, queryDate)) continue;
            OperateOption option = OperateOption.create();
            option.setVariableValue("tradeDate", DateUtils.formatString((Date)queryDate, (String)"yyyy-MM-dd"));
            OperationResult result = TmcOperateServiceHelper.execOperate((String)"detailquerydata", (String)"mon_reportfundorg", (Object[])new Object[]{reportOrgSet.getPkValue()}, (OperateOption)option);
            if (!result.isSuccess()) continue;
            LOGGER.info("FundSumBill: op_query_detail_result:{}", (Object)result.toString());
            ArrayList<DynamicObject> orgs = new ArrayList<DynamicObject>(16);
            orgs.add(reportOrgSet.getDynamicObject("org"));
            if (reportOrgSet.getBoolean("collect")) {
                DynamicObjectCollection cOrgs = reportOrgSet.getDynamicObjectCollection("collectionorgentity");
                orgs.addAll(cOrgs.stream().map(c -> c.getDynamicObject("c_org")).collect(Collectors.toList()));
            }
            for (DynamicObject org : orgs) {
                FundSumBillBean fundSumBillBean = new FundSumBillBean();
                fundSumBillBean.setQueryDate(queryDate);
                fundSumBillBean.setBillStatusParam(BillStatusEnum.SAVE.getValue().equals(billStatusParam) ? billStatusParam : BillStatusEnum.SUBMIT.getValue());
                fundSumBillBean.setReportOrgSet(reportOrgSet);
                fundSumBillBean.setReportOrgId(reportOrgSet.getLong("id"));
                fundSumBillBean.setOrg(org);
                DynamicObject fundThresholdInfo = LargeFundQueryHelper.getFundThresholdInfo((DynamicObject)reportOrgSet);
                Long transCurrency = fundThresholdInfo.getLong("currency");
                fundSumBillBean.setTransCurrency(transCurrency);
                String reportContent = reportOrgSet.getString("reportcontent");
                fundSumBillBean.setReportContent(reportContent);
                this.queryTradeAndBalance(fundSumBillBean);
                this.queryLargeFundDetail(fundSumBillBean);
                fundSumBillBeans.add(fundSumBillBean);
            }
        }
        this.successCount = this.genFundSumBill(fundSumBillBeans, billStatusParam);
    }

    public void onReturnOperation(IOperationResult e) throws KDException {
        super.onReturnOperation(e);
        if (this.getOperationResult().isSuccess() && EmptyUtil.isNoEmpty((Integer)this.successCount)) {
            e.setMessage(this.successCount + "");
            this.successCount = 0;
        }
    }

    private boolean existFundSumBill(DynamicObject reportOrgSet, Date queryDate) {
        QFilter fundSumBillFilter = new QFilter("fundorg", "=", reportOrgSet.getPkValue()).and("bizdate", "=", (Object)queryDate);
        DynamicObjectCollection fundSumBills = QueryServiceHelper.query((String)"mon_fundsumbill", (String)LARGESUM_SET, (QFilter[])fundSumBillFilter.toArray());
        ArrayList<Long> saveBillIds = new ArrayList<Long>(16);
        for (DynamicObject fundSumBill : fundSumBills) {
            String billStatus = fundSumBill.getString("billstatus");
            if (BillStatusEnum.SUBMIT.getValue().equals(billStatus) || BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                return true;
            }
            if (!BillStatusEnum.SAVE.getValue().equals(billStatus)) continue;
            saveBillIds.add(fundSumBill.getLong("id"));
        }
        if (EmptyUtil.isNoEmpty(saveBillIds)) {
            DeleteServiceHelper.delete((IDataEntityType)reportOrgSet.getDataEntityType(), (Object[])saveBillIds.toArray());
        }
        return false;
    }

    private void queryTradeAndBalance(FundSumBillBean fundSumBillBean) {
        BigDecimal sumTradeAmount = BigDecimal.ZERO;
        BigDecimal sumBalanceAmount = BigDecimal.ZERO;
        DynamicObject reportOrgSet = fundSumBillBean.getReportOrgSet();
        DynamicObject org = fundSumBillBean.getOrg();
        if (reportOrgSet.getBoolean("applyall")) {
            String queryResource = reportOrgSet.getString("source");
            Map<String, String> resouceListBySet = this.getResouceAmtPropBySet(fundSumBillBean.getReportContent(), queryResource);
            for (Map.Entry<String, String> entry : resouceListBySet.entrySet()) {
                String resource = entry.getKey();
                String direct = entry.getValue();
                BigDecimal accountAmt = this.queryBizData(org, fundSumBillBean.getQueryDate(), resource, direct, fundSumBillBean.getTransCurrency(), 0L);
                sumTradeAmount = sumTradeAmount.add(accountAmt);
            }
            sumBalanceAmount = "online".equals(queryResource) ? this.queryBalanceData(org, fundSumBillBean.getQueryDate(), fundSumBillBean.getTransCurrency(), 0L) : this.queryBankJournalBalance(org, fundSumBillBean.getQueryDate(), fundSumBillBean.getTransCurrency(), 0L);
        } else {
            DynamicObjectCollection entrys = reportOrgSet.getDynamicObjectCollection("accountentity");
            for (DynamicObject entry : entrys) {
                String queryResource = entry.getString("a_source");
                DynamicObject aAccount = entry.getDynamicObject("a_account");
                Map<String, String> resouceListBySet = this.getResouceAmtPropBySet(fundSumBillBean.getReportContent(), queryResource);
                for (Map.Entry<String, String> reSouceEntry : resouceListBySet.entrySet()) {
                    String resource = reSouceEntry.getKey();
                    String direct = reSouceEntry.getValue();
                    BigDecimal accountAmt = this.queryBizData(org, fundSumBillBean.getQueryDate(), resource, direct, fundSumBillBean.getTransCurrency(), aAccount.getLong("id"));
                    sumTradeAmount = sumTradeAmount.add(accountAmt);
                }
                BigDecimal balanceAmount = "online".equals(queryResource) ? this.queryBalanceData(org, fundSumBillBean.getQueryDate(), fundSumBillBean.getTransCurrency(), aAccount.getLong("id")) : this.queryBankJournalBalance(org, fundSumBillBean.getQueryDate(), fundSumBillBean.getTransCurrency(), aAccount.getLong("id"));
                sumBalanceAmount = sumBalanceAmount.add(balanceAmount);
            }
        }
        fundSumBillBean.setSumTradeAmount(sumTradeAmount);
        fundSumBillBean.setSumBalanceAmount(sumBalanceAmount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal queryBizData(DynamicObject org, Date queryDate, String resource, String direct, Long transCurrency, Long acctBankId) {
        String entityName;
        LargeFundQueryFieldBuilder fundQureyFieldObj = LargeFundQueryFieldBuilder.getFundQureyFieldObj((String)resource);
        QFilter filter = new QFilter(fundQureyFieldObj.getOrg(), "=", org.getPkValue()).and(fundQureyFieldObj.getTradeDate(), ">=", (Object)DateUtils.getDataFormat((Date)queryDate, (boolean)true)).and(fundQureyFieldObj.getTradeDate(), "<=", (Object)DateUtils.getDataFormat((Date)queryDate, (boolean)false));
        if (this.offInternal) {
            this.unitTextSet.addAll(LargeFundQueryHelper.getBankRoll());
            filter.and(new QFilter(fundQureyFieldObj.getOppUnit(), "not in", this.unitTextSet));
        }
        if (EmptyUtil.isNoEmpty((Long)acctBankId)) {
            filter.and(new QFilter(fundQureyFieldObj.getAcctBank(), "=", (Object)acctBankId));
        }
        if ("cas_recbill".equals(entityName = fundQureyFieldObj.getEntityName()) || "cas_paybill".equals(entityName)) {
            filter.and("billstatus", "=", (Object)BillStatusEnum.PAYED.getValue());
        }
        LOGGER.info("FundSumBill: queryBizData, entity:{}; filter:{}", (Object)entityName, (Object)filter.toString());
        BigDecimal sumAmount = BigDecimal.ZERO;
        try (DataSet dataSet = null;){
            dataSet = QueryServiceHelper.queryDataSet((String)"resource", (String)entityName, (String)LargeFundQueryFieldBuilder.getbizBillQueryFileds((LargeFundQueryFieldBuilder)fundQureyFieldObj, (String)direct), (QFilter[])filter.toArray(), null);
            for (Row row : dataSet) {
                BigDecimal resultAmt = row.getBigDecimal(fundQureyFieldObj.getResultAmt());
                if (resultAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal rate = LargeFundQueryHelper.getRate((Long)row.getLong(fundQureyFieldObj.getCurrency()), (Long)transCurrency, (Long)org.getLong("id"));
                sumAmount = sumAmount.add(resultAmt.multiply(rate));
            }
        }
        return sumAmount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal queryBalanceData(DynamicObject org, Date queryDate, Long transCurrency, Long acctBankId) {
        BigDecimal balanceAmt = BigDecimal.ZERO;
        QFilter balanceFilter = new QFilter("company", "=", org.getPkValue()).and("amount", "!=", (Object)0).and("bizdate", ">=", (Object)DateUtils.getDataFormat((Date)queryDate, (boolean)true)).and("bizdate", "<=", (Object)DateUtils.getDataFormat((Date)queryDate, (boolean)false));
        if (EmptyUtil.isNoEmpty((Long)acctBankId)) {
            balanceFilter.and("accountbank", "=", (Object)acctBankId);
        }
        LOGGER.info("FundSumBill: queryBalanceData,filter:{}", (Object)balanceFilter.toString());
        try (DataSet dataSet = null;){
            dataSet = QueryServiceHelper.queryDataSet((String)"bei_bankbalance", (String)"bei_bankbalance", (String)BALANCE_SET, (QFilter[])balanceFilter.toArray(), null);
            for (Row row : dataSet) {
                BigDecimal amount = row.getBigDecimal("amount");
                if (amount.compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal rate = LargeFundQueryHelper.getRate((Long)row.getLong("currency"), (Long)transCurrency, (Long)org.getLong("id"));
                balanceAmt = balanceAmt.add(amount.multiply(rate));
            }
        }
        return balanceAmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal queryBankJournalBalance(DynamicObject org, Date queryDate, Long transCurrency, Long acctBankId) {
        BigDecimal balanceAmt = BigDecimal.ZERO;
        long orgId = org.getLong("id");
        DynamicObject cashMgtInit = TmcDataServiceHelper.loadSingleFromCache((String)"cas_cashmgtinit", (String)CAS_MGTINIT_SET, (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
        if (cashMgtInit == null || cashMgtInit.getDynamicObject("standardcurrency") == null) {
            return BigDecimal.ZERO;
        }
        long periodId = cashMgtInit.getDynamicObject("startperiod").getLong("id");
        LOGGER.info("FundSumBill.queryBankJournalBalance, periodId:{}", (Object)periodId);
        QFilter initBalanceFilter = new QFilter("org", "=", (Object)orgId).and("period", "=", (Object)periodId);
        if (EmptyUtil.isNoEmpty((Long)acctBankId)) {
            initBalanceFilter.and("accountbank", "=", (Object)acctBankId);
        }
        Map initJournalBalanceMap = TmcDataServiceHelper.loadFromCache((String)"cas_journalbalance", (String)CAS_JOURNAL_BALANCE_SET, (QFilter[])initBalanceFilter.toArray());
        for (Map.Entry entry : initJournalBalanceMap.entrySet()) {
            BigDecimal monthStart = ((DynamicObject)entry.getValue()).getBigDecimal("monthstart");
            if (monthStart.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal rate = LargeFundQueryHelper.getRate((Long)((DynamicObject)entry.getValue()).getLong("currency.id"), (Long)transCurrency, (Long)orgId);
            balanceAmt = balanceAmt.add(monthStart.multiply(rate));
        }
        QFilter balanceFilter = new QFilter("org", "=", (Object)orgId).and("bookdate", "<=", (Object)DateUtils.getDataFormat((Date)queryDate, (boolean)false));
        if (EmptyUtil.isNoEmpty((Long)acctBankId)) {
            balanceFilter.and("accountbank", "=", (Object)acctBankId);
        }
        try (DataSet dataSet = null;){
            dataSet = QueryServiceHelper.queryDataSet((String)"journal", (String)"cas_bankjournal", (String)CAS_BANK_JOURNAL_SET, (QFilter[])balanceFilter.toArray(), null);
            for (Row row : dataSet) {
                BigDecimal amount = row.getBigDecimal("debitamount").subtract(row.getBigDecimal("creditamount"));
                if (amount.compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal rate = LargeFundQueryHelper.getRate((Long)row.getLong("currency.id"), (Long)transCurrency, (Long)orgId);
                balanceAmt = balanceAmt.add(amount.multiply(rate));
            }
        }
        return balanceAmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryLargeFundDetail(FundSumBillBean fundSumBillBean) {
        QFilter detailFilter = new QFilter("fundorg", "=", fundSumBillBean.getReportOrgSet().getPkValue()).and("entryentity.e_org", "=", fundSumBillBean.getOrg().getPkValue()).and("bizdate", "=", (Object)fundSumBillBean.getQueryDate()).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        if (!LargeDirectionEnum.ALL.getValue().equals(fundSumBillBean.getReportContent())) {
            detailFilter.and("direction", "=", (Object)fundSumBillBean.getReportContent());
        }
        Integer largeTradeNum = 0;
        BigDecimal sumConvertAmt = BigDecimal.ZERO;
        try (DataSet detailDataset = null;){
            detailDataset = QueryServiceHelper.queryDataSet((String)"largefunddetail", (String)"mon_largefunddetail", (String)LARGEDETAIL_SET, (QFilter[])detailFilter.toArray(), null);
            detailDataset = detailDataset.distinct();
            for (Row row : detailDataset) {
                BigDecimal convertAmt = row.getBigDecimal("convertamt");
                if (BigDecimal.ZERO.compareTo(convertAmt) >= 0) continue;
                sumConvertAmt = sumConvertAmt.add(convertAmt);
                Integer n = largeTradeNum;
                Integer n2 = largeTradeNum = Integer.valueOf(largeTradeNum + 1);
            }
        }
        fundSumBillBean.setLargeTradeNum(largeTradeNum);
        fundSumBillBean.setSumConvertAmt(sumConvertAmt);
    }

    private int genFundSumBill(List<FundSumBillBean> fundSumBillBeans, String billStatusParam) {
        if (EmptyUtil.isEmpty(fundSumBillBeans)) {
            return 0;
        }
        Map<Long, List<FundSumBillBean>> fundSumBillBeanMap = fundSumBillBeans.stream().collect(Collectors.groupingBy(FundSumBillBean::getReportOrgId));
        ArrayList<DynamicObject> saveSumBills = new ArrayList<DynamicObject>(fundSumBillBeanMap.size());
        for (Map.Entry<Long, List<FundSumBillBean>> entry : fundSumBillBeanMap.entrySet()) {
            List<FundSumBillBean> value = entry.getValue();
            FundSumBillBean billHead = value.get(0);
            DynamicObject newDynamicObject = TmcDataServiceHelper.newDynamicObject((String)"mon_fundsumbill");
            DynamicObject reportOrgSet = billHead.getReportOrgSet();
            newDynamicObject.set("fundorg", (Object)reportOrgSet);
            newDynamicObject.set("billstatus", (Object)billHead.getBillStatusParam());
            newDynamicObject.set("upstatus", (Object)UpStatusEnum.WAITUP.getValue());
            newDynamicObject.set("bizdate", (Object)billHead.getQueryDate());
            newDynamicObject.set("upcurrency", (Object)billHead.getTransCurrency());
            newDynamicObject.set("direction", (Object)billHead.getReportContent());
            newDynamicObject.set("source", (Object)BillSourceEnum.SYSTEM.getValue());
            BigDecimal tradeAmt = BigDecimal.ZERO;
            Integer largeTradeNum = 0;
            BigDecimal largeTradeAmt = BigDecimal.ZERO;
            BigDecimal stockAmt = BigDecimal.ZERO;
            HashMap<Long, Integer> orgSeqMap = new HashMap<Long, Integer>();
            if (reportOrgSet.getBoolean("collect")) {
                DynamicObjectCollection cOrgEntities = reportOrgSet.getDynamicObjectCollection("collectionorgentity");
                orgSeqMap.put(reportOrgSet.getDynamicObject("org").getLong("id"), 0);
                for (DynamicObject cOrgEntity : cOrgEntities) {
                    orgSeqMap.put(cOrgEntity.getDynamicObject("c_org").getLong("id"), cOrgEntity.getInt("seq"));
                }
            }
            DynamicObjectCollection sumDetailEntity = newDynamicObject.getDynamicObjectCollection("sumdetailentity");
            for (FundSumBillBean fundSumBillBean : value) {
                DynamicObject valueOrg = fundSumBillBean.getOrg();
                LOGGER.info("FundSumBill: org:{}; sumTradeAmount: {}; sumConvertAmt:{}; largeTradeNum:{}; sumBalanceAmount:{}", new Object[]{valueOrg.getString("name"), fundSumBillBean.getSumTradeAmount(), fundSumBillBean.getSumConvertAmt(), fundSumBillBean.getLargeTradeNum(), fundSumBillBean.getSumBalanceAmount()});
                if (fundSumBillBean.getLargeTradeNum() == 0 && BigDecimal.ZERO.compareTo(fundSumBillBean.getSumTradeAmount()) == 0 && BigDecimal.ZERO.compareTo(fundSumBillBean.getSumConvertAmt()) == 0 && BigDecimal.ZERO.compareTo(fundSumBillBean.getSumBalanceAmount()) == 0) continue;
                DynamicObject newEntry = sumDetailEntity.addNew();
                newEntry.set("seq", orgSeqMap.get(valueOrg.getLong("id")));
                newEntry.set("s_org", (Object)fundSumBillBean.getOrg());
                newEntry.set("s_tradeamt", (Object)fundSumBillBean.getSumTradeAmount());
                newEntry.set("s_largetradenum", (Object)fundSumBillBean.getLargeTradeNum());
                newEntry.set("s_largetradeamt", (Object)fundSumBillBean.getSumConvertAmt());
                newEntry.set("s_stockamt", (Object)fundSumBillBean.getSumBalanceAmount());
                tradeAmt = tradeAmt.add(fundSumBillBean.getSumTradeAmount());
                largeTradeNum = largeTradeNum + fundSumBillBean.getLargeTradeNum();
                largeTradeAmt = largeTradeAmt.add(fundSumBillBean.getSumConvertAmt());
                stockAmt = stockAmt.add(fundSumBillBean.getSumBalanceAmount());
            }
            if (EmptyUtil.isEmpty((DynamicObjectCollection)sumDetailEntity)) continue;
            newDynamicObject.set("tradeamt", (Object)tradeAmt);
            newDynamicObject.set("largetradenum", (Object)largeTradeNum);
            newDynamicObject.set("largetradeamt", (Object)largeTradeAmt);
            newDynamicObject.set("stockamt", (Object)stockAmt);
            newDynamicObject.set("billno", (Object)CodeRuleHelper.generateNumber((String)"mon_fundsumbill", (DynamicObject)newDynamicObject, (String)"", (String)""));
            saveSumBills.add(newDynamicObject);
        }
        if (EmptyUtil.isNoEmpty(saveSumBills)) {
            TmcDataServiceHelper.save((DynamicObject[])saveSumBills.toArray(new DynamicObject[0]));
            Object[] ids = saveSumBills.stream().map(DataEntityBase::getPkValue).toArray();
            if (BillStatusEnum.AUDIT.getValue().equals(billStatusParam)) {
                TmcOperateServiceHelper.execOperate((String)"audit", (String)"mon_fundsumbill", (Object[])ids, (OperateOption)OperateOption.create());
            }
        }
        return saveSumBills.size();
    }

    private Map<String, String> getResouceAmtPropBySet(String reportContent, String queryResource) {
        HashMap<String, String> result = new HashMap<String, String>();
        switch (reportContent) {
            case "pay": {
                switch (queryResource) {
                    case "online": {
                        result.put("transdetail", "debitamount as resultAmt");
                        return result;
                    }
                    case "bankjournal": {
                        result.put("bankjournal", "creditamount  as resultAmt ");
                        return result;
                    }
                    case "rpbill": {
                        result.put("paybill", "actpayamt  as resultAmt");
                        return result;
                    }
                }
            }
            case "rec": {
                switch (queryResource) {
                    case "online": {
                        result.put("transdetail", "creditamount  as resultAmt");
                        return result;
                    }
                    case "bankjournal": {
                        result.put("bankjournal", "debitamount  as resultAmt");
                        return result;
                    }
                    case "rpbill": {
                        result.put("recbill", "actrecamt  as resultAmt");
                        return result;
                    }
                }
            }
            case "all": {
                switch (queryResource) {
                    case "online": {
                        result.put("transdetail", "creditamount+debitamount   as resultAmt");
                        return result;
                    }
                    case "bankjournal": {
                        result.put("bankjournal", "creditamount+debitamount  as resultAmt");
                        return result;
                    }
                    case "rpbill": {
                        result.put("paybill", "actpayamt  as resultAmt");
                        result.put("recbill", "actrecamt  as resultAmt");
                        return result;
                    }
                }
            }
        }
        return result;
    }
}

