/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.sar.business.service.debt;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.sar.business.opservice.debt.DebtDetailBillBean;
import kd.tmc.sar.business.service.debt.IDebtBillService;
import kd.tmc.sar.common.builder.DebtBillQueryFieldBuilder;
import kd.tmc.sar.common.enums.BillTypeEnum;
import kd.tmc.sar.common.helper.LargeFundQueryHelper;
import kd.tmc.sar.common.helper.LargeFundUseMatchHelper;
import org.apache.commons.lang3.tuple.Pair;

public class CdmPayableBillService
implements IDebtBillService {
    private static final Log LOGGER = LogFactory.getLog(CdmPayableBillService.class);

    @Override
    public void billF7Evt(DynamicObject fundOrg, Date reportEndDate, Set<Long> orgSet, Set<String> statusTs, Map<Long, Pair<Long, BigDecimal>> amtByOrg, boolean offInternalLoan, Set<String> unitTextSet, List<QFilter> qFilters) {
        Date reportEndTime = DateUtils.getDataFormat((Date)reportEndDate, (boolean)false);
        HashSet<Long> filterIds = new HashSet<Long>();
        Pair<Long, BigDecimal> pair = amtByOrg.get(999L);
        Long upCurrency = (Long)pair.getKey();
        BigDecimal threshold = ((BigDecimal)pair.getValue()).multiply(Constants.TEN_THOUSAND);
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("drawercompany", "in", orgSet);
        qFilter.and("draftbilltype.settlementtype", "in", Arrays.asList("5", "6"));
        if (offInternalLoan) {
            qFilter.and("payeetype", "!=", (Object)"bos_org");
            qFilter.and("receivername", "not in", unitTextSet);
        }
        qFilter.and("billno", "not in", statusTs);
        DynamicObjectCollection cdmPayableBillIds = QueryServiceHelper.query((String)"cdm_payablebill", (String)"id, draftbilltype, company, billno, bizdate, currency, amount, drawercompany, receivername, payeetype, acceptdate", (QFilter[])qFilter.toArray());
        Map matchResult = LargeFundUseMatchHelper.getDebtMatchResult((String)"cdm_payablebill", (DynamicObjectCollection)cdmPayableBillIds);
        for (DynamicObject cdmId : cdmPayableBillIds) {
            Pair<Long, BigDecimal> decimalPair;
            DynamicObject debtType = (DynamicObject)matchResult.get(cdmId.getLong("id"));
            if (debtType != null && (decimalPair = amtByOrg.get(debtType.getLong("id"))) != null) {
                upCurrency = (Long)decimalPair.getKey();
                threshold = ((BigDecimal)decimalPair.getValue()).multiply(Constants.TEN_THOUSAND);
            }
            Long currency = cdmId.getLong("currency");
            BigDecimal rate = LargeFundQueryHelper.getRate((Long)currency, (Long)upCurrency, (Long)cdmId.getLong("company"));
            BigDecimal srcAmt = cdmId.getBigDecimal("amount");
            BigDecimal convertAmt = srcAmt.multiply(rate).setScale(20, RoundingMode.HALF_UP);
            if (convertAmt.compareTo(threshold) < 0) continue;
            QFilter draftTradeBillFilter = new QFilter("tradetype", "=", (Object)"payoff");
            draftTradeBillFilter.and("bizdate", "<=", (Object)reportEndTime);
            draftTradeBillFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
            draftTradeBillFilter.and("entrys.draftbill.id", "=", (Object)cdmId.getLong("id"));
            DynamicObjectCollection draftTradeBillIds = QueryServiceHelper.query((String)"cdm_drafttradebill", (String)"id", (QFilter[])draftTradeBillFilter.toArray());
            if (!EmptyUtil.isEmpty((DynamicObjectCollection)draftTradeBillIds)) continue;
            filterIds.add(cdmId.getLong("id"));
        }
        qFilters.add(new QFilter("id", "in", filterIds));
    }

    @Override
    public void billCloseCallBack(String billType, DynamicObject resultData, IDataModel model) {
        DebtBillQueryFieldBuilder debtBillQueryFieldObj = DebtBillQueryFieldBuilder.getDebtBillQueryFieldObj((String)billType);
        Date reportStartTime = DateUtils.getDataFormat((Date)((Date)model.getValue("reportperiod_startdate")), (boolean)true);
        Date reportEndTime = DateUtils.getDataFormat((Date)((Date)model.getValue("reportperiod_enddate")), (boolean)false);
        DynamicObject fundOrg = (DynamicObject)model.getValue("fundorg");
        model.setValue("debtbillno", (Object)resultData.getString(debtBillQueryFieldObj.getBillNo()));
        long debtType = 0L;
        DynamicObjectCollection resultDatas = new DynamicObjectCollection();
        resultDatas.add((Object)resultData);
        Map matchResult = LargeFundUseMatchHelper.getDebtMatchResult((String)billType, (DynamicObjectCollection)resultDatas);
        long id = resultData.getLong("id");
        DynamicObject billResult = (DynamicObject)matchResult.get(id);
        if (billResult != null) {
            debtType = billResult.getLong("id");
        }
        model.setValue("debttype", (Object)debtType);
        model.setValue("debtorg", (Object)resultData.getDynamicObject(debtBillQueryFieldObj.getCompany()));
        DynamicObject fundThresholdInfo = LargeFundQueryHelper.getFundThresholdInfo((DynamicObject)fundOrg);
        BigDecimal srcDebtCapitalAmt = resultData.getBigDecimal(debtBillQueryFieldObj.getDebtCapitalAmt());
        Long srcCurrency = resultData.getDynamicObject(debtBillQueryFieldObj.getCurrency()).getLong("id");
        BigDecimal rate = LargeFundQueryHelper.getRate((Long)srcCurrency, (Long)fundThresholdInfo.getLong("currency"), (Long)resultData.getDynamicObject(debtBillQueryFieldObj.getCompany()).getLong("id"));
        model.setValue("debtcapitalamt", (Object)srcDebtCapitalAmt.multiply(rate));
        model.setValue("creditortext", (Object)resultData.getString(debtBillQueryFieldObj.getCreditor()));
        model.setValue("debtinterestrate", (Object)(EmptyUtil.isEmpty((String)debtBillQueryFieldObj.getDebtInterestRate()) ? Integer.valueOf(0) : resultData.getBigDecimal(debtBillQueryFieldObj.getDebtInterestRate())));
        model.setValue("debtbizdata", (Object)resultData.getDate(debtBillQueryFieldObj.getBizData()));
        model.setValue("expiredate", (Object)resultData.getDate(debtBillQueryFieldObj.getExpireDate()));
        BigDecimal notRepayAmtSum = BigDecimal.ZERO;
        Date minRepaymentDate = null;
        Date acceptDate = resultData.getDate(debtBillQueryFieldObj.getCurrentExpireDate());
        if (reportStartTime.before(acceptDate) && reportEndTime.after(acceptDate)) {
            notRepayAmtSum = resultData.getBigDecimal(debtBillQueryFieldObj.getCurrentExpireAmt());
            minRepaymentDate = acceptDate;
        }
        notRepayAmtSum = notRepayAmtSum.multiply(rate);
        model.setValue("currentexpireamt", (Object)notRepayAmtSum);
        model.setValue("currentexpiredate", (Object)minRepaymentDate);
        model.setValue("src_billtype", (Object)BillTypeEnum.getNameByValue((String)billType), 0);
        model.setValue("src_billno", (Object)resultData.getString(debtBillQueryFieldObj.getBillNo()), 0);
        model.setValue("src_debtor", (Object)resultData.getDynamicObject(debtBillQueryFieldObj.getCompany()).getString("name"), 0);
        model.setValue("src_currency", (Object)srcCurrency, 0);
        model.setValue("src_amount", (Object)srcDebtCapitalAmt, 0);
        model.setValue("src_creditor", (Object)resultData.getString(debtBillQueryFieldObj.getCreditor()), 0);
        model.setValue("src_startdate", (Object)resultData.getDate(debtBillQueryFieldObj.getBizData()), 0);
        model.setValue("src_enddate", (Object)resultData.getDate(debtBillQueryFieldObj.getExpireDate()), 0);
    }

    @Override
    public List<DebtDetailBillBean> queryBizData(DynamicObject reportOrgSet, Set<String> statusTs, Set<Long> orgSet, Map<Long, Pair<Long, BigDecimal>> amtByOrg, boolean offInternalLoan, Set<String> unitTextSet, Map<String, Date> dateMap) {
        ArrayList<DebtDetailBillBean> debtDetailBillBeanList = new ArrayList<DebtDetailBillBean>(16);
        Date reportEndTime = DateUtils.getDataFormat((Date)dateMap.get("reportperiod_enddate"), (boolean)false);
        HashSet<Long> filterIds = new HashSet<Long>();
        Pair<Long, BigDecimal> pair = amtByOrg.get(999L);
        Long upCurrency = (Long)pair.getKey();
        BigDecimal threshold = ((BigDecimal)pair.getValue()).multiply(Constants.TEN_THOUSAND);
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("drawercompany", "in", orgSet);
        qFilter.and("draftbilltype.settlementtype", "in", Arrays.asList("5", "6"));
        if (offInternalLoan) {
            qFilter.and("payeetype", "!=", (Object)"bos_org");
            qFilter.and("receivername", "not in", unitTextSet);
        }
        qFilter.and("billno", "not in", statusTs);
        LOGGER.info("DebtDetail.cdm_payablebill.filter: {}", (Object)qFilter.toString());
        DynamicObjectCollection cdmPayableBillIds = QueryServiceHelper.query((String)"cdm_payablebill", (String)"id, draftbilltype, company, company.number, company.name, billno, bizdate, currency, currency.number, currency.name, amount, drawercompany, drawercompany.number, drawercompany.name, drawerorg, drawerorg.number, drawerorg.name, receivername, payeetype, acceptdate, billstatus, creator.name, createtime, modifier.name, auditor.name", (QFilter[])qFilter.toArray());
        LOGGER.info("DebtDetail.cdm_payablebill.billIdsSize: {}", (Object)cdmPayableBillIds.size());
        Map matchResult = LargeFundUseMatchHelper.getDebtMatchResult((String)"cdm_payablebill", (DynamicObjectCollection)cdmPayableBillIds);
        for (DynamicObject cdmId : cdmPayableBillIds) {
            Pair<Long, BigDecimal> decimalPair;
            DynamicObject debtType = (DynamicObject)matchResult.get(cdmId.getLong("id"));
            if (debtType != null && (decimalPair = amtByOrg.get(debtType.getLong("id"))) != null) {
                upCurrency = (Long)decimalPair.getKey();
                threshold = ((BigDecimal)decimalPair.getValue()).multiply(Constants.TEN_THOUSAND);
            }
            Long currency = cdmId.getLong("currency");
            BigDecimal rate = LargeFundQueryHelper.getRate((Long)currency, (Long)upCurrency, (Long)cdmId.getLong("company"));
            BigDecimal srcAmt = cdmId.getBigDecimal("amount");
            BigDecimal convertAmt = srcAmt.multiply(rate).setScale(20, RoundingMode.HALF_UP);
            if (convertAmt.compareTo(threshold) < 0) continue;
            QFilter draftTradeBillFilter = new QFilter("tradetype", "=", (Object)"payoff");
            draftTradeBillFilter.and("bizdate", "<=", (Object)reportEndTime);
            draftTradeBillFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
            draftTradeBillFilter.and("entrys.draftbill.id", "=", (Object)cdmId.getLong("id"));
            DynamicObjectCollection draftTradeBillIds = QueryServiceHelper.query((String)"cdm_drafttradebill", (String)"id", (QFilter[])draftTradeBillFilter.toArray());
            if (!EmptyUtil.isEmpty((DynamicObjectCollection)draftTradeBillIds)) continue;
            filterIds.add(cdmId.getLong("id"));
        }
        LOGGER.info("DebtDetail.cdm_payablebill.filterIds: {}", (Object)((Object)filterIds).toString());
        DynamicObject[] bizDataList = TmcDataServiceHelper.load((Object[])filterIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_payablebill"));
        LOGGER.info("DebtDetail.cdm_payablebill.bizDataListSize: {}", (Object)bizDataList.length);
        for (DynamicObject bizData : bizDataList) {
            DynamicObject debtType = (DynamicObject)matchResult.get(bizData.getLong("id"));
            debtDetailBillBeanList.add(this.dynamicObjectToBean(reportOrgSet, bizData, debtType, upCurrency, dateMap));
        }
        LOGGER.info("DebtDetail.cdm_payablebill.beanList: {}", (Object)SerializationUtils.toJsonString(debtDetailBillBeanList));
        return debtDetailBillBeanList;
    }

    @Override
    public DebtDetailBillBean dynamicObjectToBean(DynamicObject reportOrgSet, DynamicObject resultData, DynamicObject debtType, Long upCurrency, Map<String, Date> dateMap) {
        String billType = resultData.getDataEntityType().getName();
        DebtBillQueryFieldBuilder debtBillQueryFieldObj = DebtBillQueryFieldBuilder.getDebtBillQueryFieldObj((String)billType);
        DebtDetailBillBean bean = new DebtDetailBillBean();
        bean.setBillType(billType);
        bean.setUpCurrency(upCurrency);
        bean.setFundOrg(reportOrgSet.getLong("id"));
        bean.setBizDate(dateMap.get("bizdate"));
        Date reportStartTime = DateUtils.getDataFormat((Date)dateMap.get("reportperiod_startdate"), (boolean)true);
        Date reportEndTime = DateUtils.getDataFormat((Date)dateMap.get("reportperiod_enddate"), (boolean)false);
        bean.setStartDate(dateMap.get("reportperiod_startdate"));
        bean.setEndDate(dateMap.get("reportperiod_enddate"));
        bean.setDebtBillNo(resultData.getString(debtBillQueryFieldObj.getBillNo()));
        bean.setDebtType(debtType.getLong("id"));
        DynamicObject drawCompany = resultData.getDynamicObject(debtBillQueryFieldObj.getCompany());
        DynamicObject drawOrg = resultData.getDynamicObject(debtBillQueryFieldObj.getOrg());
        Long drawId = null;
        String drawName = null;
        if (EmptyUtil.isNoEmpty((DynamicObject)drawCompany)) {
            drawId = drawCompany.getLong("id");
            drawName = drawCompany.getString("name");
        } else if (EmptyUtil.isNoEmpty((DynamicObject)drawOrg)) {
            drawId = drawOrg.getLong("id");
            drawName = drawOrg.getString("name");
        }
        bean.setDebtOrg(drawId);
        BigDecimal srcDebtCapitalAmt = resultData.getBigDecimal(debtBillQueryFieldObj.getDebtCapitalAmt());
        Long srcCurrency = resultData.getDynamicObject(debtBillQueryFieldObj.getCurrency()).getLong("id");
        BigDecimal rate = LargeFundQueryHelper.getRate((Long)srcCurrency, (Long)upCurrency, (Long)drawId);
        bean.setDebtCapitalAmt(srcDebtCapitalAmt.multiply(rate));
        bean.setCreditorText(resultData.getString(debtBillQueryFieldObj.getCreditor()));
        bean.setDebtInterestRate(EmptyUtil.isEmpty((String)debtBillQueryFieldObj.getDebtInterestRate()) ? BigDecimal.ZERO : resultData.getBigDecimal(debtBillQueryFieldObj.getDebtInterestRate()));
        bean.setDebtBizData(resultData.getDate(debtBillQueryFieldObj.getBizData()));
        bean.setExpireDate(resultData.getDate(debtBillQueryFieldObj.getExpireDate()));
        BigDecimal notRepayAmtSum = BigDecimal.ZERO;
        Date minRepaymentDate = null;
        Date acceptDate = resultData.getDate(debtBillQueryFieldObj.getCurrentExpireDate());
        if (reportStartTime.before(acceptDate) && reportEndTime.after(acceptDate)) {
            notRepayAmtSum = resultData.getBigDecimal(debtBillQueryFieldObj.getCurrentExpireAmt());
            minRepaymentDate = acceptDate;
        }
        notRepayAmtSum = notRepayAmtSum.multiply(rate);
        bean.setCurrentExpireAmt(notRepayAmtSum);
        bean.setCurrentExpireDate(minRepaymentDate);
        DebtDetailBillBean.EntryEntity entryEntity = new DebtDetailBillBean.EntryEntity();
        entryEntity.setSrcBillType(BillTypeEnum.getNameByValue((String)billType));
        entryEntity.setSrcBillNo(resultData.getString(debtBillQueryFieldObj.getBillNo()));
        entryEntity.setSrcDebtor(drawName);
        entryEntity.setSrcCurrency(srcCurrency);
        entryEntity.setSrcAmount(srcDebtCapitalAmt);
        entryEntity.setSrcCreditor(resultData.getString(debtBillQueryFieldObj.getCreditor()));
        entryEntity.setSrcStartDate(resultData.getDate(debtBillQueryFieldObj.getBizData()));
        entryEntity.setSrcEndDate(resultData.getDate(debtBillQueryFieldObj.getExpireDate()));
        ArrayList<DebtDetailBillBean.EntryEntity> entryEntities = new ArrayList<DebtDetailBillBean.EntryEntity>();
        entryEntities.add(entryEntity);
        bean.setSrcEntryEntity(entryEntities);
        return bean;
    }
}

