/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.sar.business.service.debt;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.sar.business.opservice.debt.DebtDetailBillBean;
import kd.tmc.sar.business.service.debt.IDebtBillService;
import kd.tmc.sar.common.builder.DebtBillQueryFieldBuilder;
import kd.tmc.sar.common.enums.BillTypeEnum;
import kd.tmc.sar.common.helper.LargeFundQueryHelper;
import kd.tmc.sar.common.helper.LargeFundUseMatchHelper;
import org.apache.commons.lang3.tuple.Pair;

public class CfmLoanBillBondService
implements IDebtBillService {
    private static final Log LOGGER = LogFactory.getLog(CfmLoanBillBondService.class);
    private static final String QUERY_SET = "id, billno, org, bizdate, accountbank, currency, drawamount, latestrate, sourcebillid, description, bitbackinfo, textcreditor";

    @Override
    public void billF7Evt(DynamicObject fundOrg, Date reportEndDate, Set<Long> orgSet, Set<String> statusTs, Map<Long, Pair<Long, BigDecimal>> amtByOrg, boolean offInternalLoan, Set<String> unitTextSet, List<QFilter> qFilters) {
        Date reportEndTime = DateUtils.getDataFormat((Date)reportEndDate, (boolean)false);
        HashSet<Long> filterIds = new HashSet<Long>();
        Pair<Long, BigDecimal> pair = amtByOrg.get(999L);
        Long upCurrency = (Long)pair.getKey();
        BigDecimal threshold = ((BigDecimal)pair.getValue()).multiply(Constants.TEN_THOUSAND);
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("org", "in", orgSet);
        qFilter.and("loantype", "=", (Object)"bond");
        qFilter.and("billno", "not in", statusTs);
        DynamicObjectCollection bondIds = QueryServiceHelper.query((String)"cfm_loanbill_bond", (String)QUERY_SET, (QFilter[])qFilter.toArray());
        Map matchResult = LargeFundUseMatchHelper.getDebtMatchResult((String)"cfm_loanbill_bond", (DynamicObjectCollection)bondIds);
        for (DynamicObject bondId : bondIds) {
            Pair<Long, BigDecimal> decimalPair;
            DynamicObject debtType = (DynamicObject)matchResult.get(bondId.getLong("id"));
            if (debtType != null && (decimalPair = amtByOrg.get(debtType.getLong("id"))) != null) {
                upCurrency = (Long)decimalPair.getKey();
                threshold = ((BigDecimal)decimalPair.getValue()).multiply(Constants.TEN_THOUSAND);
            }
            Long currency = bondId.getLong("currency");
            BigDecimal rate = LargeFundQueryHelper.getRate((Long)currency, (Long)upCurrency, (Long)bondId.getLong("org"));
            BigDecimal srcAmt = bondId.getBigDecimal("drawamount");
            BigDecimal convertAmt = srcAmt.multiply(rate).setScale(20, RoundingMode.HALF_UP);
            if (convertAmt.compareTo(threshold) < 0) continue;
            DynamicObjectCollection repaymentBills = QueryServiceHelper.query((String)"cfm_repaymentbill", (String)"id, loans.e_loanbill, loans.e_repayamount", (QFilter[])new QFilter[]{new QFilter("loans.e_loanbill", "=", (Object)bondId.getLong("id")), new QFilter("bizdate", "<=", (Object)reportEndTime)});
            BigDecimal repayAmt = BigDecimal.ZERO;
            for (DynamicObject repaymentBill : repaymentBills) {
                repayAmt = repayAmt.add(repaymentBill.getBigDecimal("loans.e_repayamount"));
            }
            BigDecimal drawAmount = bondId.getBigDecimal("drawamount");
            if (repayAmt.compareTo(drawAmount) >= 0) continue;
            filterIds.add(bondId.getLong("id"));
        }
        qFilters.add(new QFilter("id", "in", filterIds));
    }

    @Override
    public void billCloseCallBack(String billType, DynamicObject resultData, IDataModel model) {
        DebtBillQueryFieldBuilder debtBillQueryFieldObj = DebtBillQueryFieldBuilder.getDebtBillQueryFieldObj((String)billType);
        Date reportStartTime = DateUtils.getDataFormat((Date)((Date)model.getValue("reportperiod_startdate")), (boolean)true);
        Date reportEndTime = DateUtils.getDataFormat((Date)((Date)model.getValue("reportperiod_enddate")), (boolean)false);
        DynamicObject fundOrg = (DynamicObject)model.getValue("fundorg");
        model.setValue("debtbillno", (Object)resultData.getString(debtBillQueryFieldObj.getBillNo()));
        long debtType = 0L;
        DynamicObjectCollection resultDatas = new DynamicObjectCollection();
        resultDatas.add((Object)resultData);
        Map matchResult = LargeFundUseMatchHelper.getDebtMatchResult((String)billType, (DynamicObjectCollection)resultDatas);
        long id = resultData.getLong("id");
        DynamicObject billResult = (DynamicObject)matchResult.get(id);
        if (billResult != null) {
            debtType = billResult.getLong("id");
        }
        model.setValue("debttype", (Object)debtType);
        model.setValue("debtorg", (Object)resultData.getDynamicObject(debtBillQueryFieldObj.getOrg()));
        DynamicObject fundThresholdInfo = LargeFundQueryHelper.getFundThresholdInfo((DynamicObject)fundOrg);
        BigDecimal srcDebtCapitalAmt = resultData.getBigDecimal(debtBillQueryFieldObj.getDebtCapitalAmt());
        Long srcCurrency = resultData.getDynamicObject(debtBillQueryFieldObj.getCurrency()).getLong("id");
        BigDecimal rate = LargeFundQueryHelper.getRate((Long)srcCurrency, (Long)fundThresholdInfo.getLong("currency"), (Long)resultData.getDynamicObject(debtBillQueryFieldObj.getOrg()).getLong("id"));
        model.setValue("debtcapitalamt", (Object)srcDebtCapitalAmt.multiply(rate));
        model.setValue("creditortext", (Object)resultData.getString(debtBillQueryFieldObj.getCreditor()));
        model.setValue("debtinterestrate", (Object)this.getLatestRate(resultData));
        model.setValue("debtbizdata", (Object)resultData.getDate(debtBillQueryFieldObj.getBizData()));
        model.setValue("expiredate", (Object)resultData.getDate(debtBillQueryFieldObj.getExpireDate()));
        BigDecimal notRepayAmtSum = BigDecimal.ZERO;
        Date minRepaymentDate = null;
        DynamicObjectCollection investorEntry = resultData.getDynamicObjectCollection("investor_entry");
        BigDecimal maxInvestAmount = BigDecimal.ZERO;
        String investorName = "";
        for (DynamicObject investor : investorEntry) {
            BigDecimal eInvestAmount = investor.getBigDecimal("e_investamount");
            if (eInvestAmount.compareTo(maxInvestAmount) <= 0) continue;
            maxInvestAmount = eInvestAmount;
            investorName = investor.getString("e_investorname");
        }
        model.setValue("creditortext", (Object)investorName);
        DynamicObjectCollection repayPlanEntry = resultData.getDynamicObjectCollection("repayplan_entry");
        for (DynamicObject repayPlan : repayPlanEntry) {
            Date exRepaymentDate = repayPlan.getDate("exrepaymentdate");
            if (!reportStartTime.before(exRepaymentDate) || !reportEndTime.after(exRepaymentDate)) continue;
            notRepayAmtSum = notRepayAmtSum.add(repayPlan.getBigDecimal("enotrepayamount"));
            if (minRepaymentDate == null) {
                minRepaymentDate = exRepaymentDate;
                continue;
            }
            if (!exRepaymentDate.before(minRepaymentDate)) continue;
            minRepaymentDate = exRepaymentDate;
        }
        notRepayAmtSum = notRepayAmtSum.multiply(rate);
        model.setValue("currentexpireamt", (Object)notRepayAmtSum);
        model.setValue("currentexpiredate", minRepaymentDate);
        model.setValue("src_billtype", (Object)BillTypeEnum.getNameByValue((String)billType), 0);
        model.setValue("src_billno", (Object)resultData.getString(debtBillQueryFieldObj.getBillNo()), 0);
        model.setValue("src_debtor", (Object)resultData.getDynamicObject(debtBillQueryFieldObj.getOrg()).getString("name"), 0);
        model.setValue("src_currency", (Object)srcCurrency, 0);
        model.setValue("src_amount", (Object)srcDebtCapitalAmt, 0);
        model.setValue("src_creditor", (Object)investorName, 0);
        model.setValue("src_startdate", (Object)resultData.getDate(debtBillQueryFieldObj.getBizData()), 0);
        model.setValue("src_enddate", (Object)resultData.getDate(debtBillQueryFieldObj.getExpireDate()), 0);
    }

    @Override
    public List<DebtDetailBillBean> queryBizData(DynamicObject reportOrgSet, Set<String> statusTs, Set<Long> orgSet, Map<Long, Pair<Long, BigDecimal>> amtByOrg, boolean offInternalLoan, Set<String> unitTextSet, Map<String, Date> dateMap) {
        ArrayList<DebtDetailBillBean> debtDetailBillBeanList = new ArrayList<DebtDetailBillBean>(16);
        Date reportEndTime = DateUtils.getDataFormat((Date)dateMap.get("reportperiod_enddate"), (boolean)false);
        HashSet<Long> filterIds = new HashSet<Long>();
        Pair<Long, BigDecimal> pair = amtByOrg.get(999L);
        Long upCurrency = (Long)pair.getKey();
        BigDecimal threshold = ((BigDecimal)pair.getValue()).multiply(Constants.TEN_THOUSAND);
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("org", "in", orgSet);
        qFilter.and("loantype", "=", (Object)"bond");
        qFilter.and("billno", "not in", statusTs);
        LOGGER.info("DebtDetail.cfm_loanbill_bond.filter: {}", (Object)qFilter.toString());
        DynamicObjectCollection bondIds = QueryServiceHelper.query((String)"cfm_loanbill_bond", (String)"id, billno, org, org.number, org.name, bizdate, accountbank, currency, currency.number, currency.name, drawamount,bondtype, latestrate, sourcebillid, description, bitbackinfo, textcreditor, amount, startintdate, term, expiredate,drawway, publishprice, ticketamt, interesttype, repaymentway, accountbank.number, accountbank.name, guaranteeway, region,billstatus, creator.name, createtime, modifier.name, auditor.name", (QFilter[])qFilter.toArray());
        LOGGER.info("DebtDetail.cfm_loanbill_bond.bondIdsSize: {}", (Object)bondIds.size());
        Map matchResult = LargeFundUseMatchHelper.getDebtMatchResult((String)"cfm_loanbill_bond", (DynamicObjectCollection)bondIds);
        for (DynamicObject bondId : bondIds) {
            Pair<Long, BigDecimal> decimalPair;
            DynamicObject debtType = (DynamicObject)matchResult.get(bondId.getLong("id"));
            if (debtType != null && (decimalPair = amtByOrg.get(debtType.getLong("id"))) != null) {
                upCurrency = (Long)decimalPair.getKey();
                threshold = ((BigDecimal)decimalPair.getValue()).multiply(Constants.TEN_THOUSAND);
            }
            Long currency = bondId.getLong("currency");
            BigDecimal rate = LargeFundQueryHelper.getRate((Long)currency, (Long)upCurrency, (Long)bondId.getLong("org"));
            BigDecimal srcAmt = bondId.getBigDecimal("drawamount");
            BigDecimal convertAmt = srcAmt.multiply(rate).setScale(20, RoundingMode.HALF_UP);
            if (convertAmt.compareTo(threshold) < 0) continue;
            DynamicObjectCollection repaymentBills = QueryServiceHelper.query((String)"cfm_repaymentbill", (String)"id, loans.e_loanbill, loans.e_repayamount", (QFilter[])new QFilter[]{new QFilter("loans.e_loanbill", "=", (Object)bondId.getLong("id")), new QFilter("bizdate", "<=", (Object)reportEndTime)});
            BigDecimal repayAmt = BigDecimal.ZERO;
            for (DynamicObject repaymentBill : repaymentBills) {
                repayAmt = repayAmt.add(repaymentBill.getBigDecimal("loans.e_repayamount"));
            }
            BigDecimal drawAmount = bondId.getBigDecimal("drawamount");
            if (repayAmt.compareTo(drawAmount) >= 0) continue;
            filterIds.add(bondId.getLong("id"));
        }
        LOGGER.info("DebtDetail.cfm_loanbill_bond.filterIds: {}", (Object)((Object)filterIds).toString());
        DynamicObject[] bizDataList = TmcDataServiceHelper.load((Object[])filterIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cfm_loanbill_bond"));
        LOGGER.info("DebtDetail.cfm_loanbill_bond.bizDataListSize: {}", (Object)bizDataList.length);
        for (DynamicObject bizData : bizDataList) {
            DynamicObject debtType = (DynamicObject)matchResult.get(bizData.getLong("id"));
            debtDetailBillBeanList.add(this.dynamicObjectToBean(reportOrgSet, bizData, debtType, upCurrency, dateMap));
        }
        LOGGER.info("DebtDetail.cfm_loanbill_bond.beanList: {}", (Object)SerializationUtils.toJsonString(debtDetailBillBeanList));
        return debtDetailBillBeanList;
    }

    @Override
    public DebtDetailBillBean dynamicObjectToBean(DynamicObject reportOrgSet, DynamicObject resultData, DynamicObject debtType, Long upCurrency, Map<String, Date> dateMap) {
        String billType = resultData.getDataEntityType().getName();
        DebtBillQueryFieldBuilder debtBillQueryFieldObj = DebtBillQueryFieldBuilder.getDebtBillQueryFieldObj((String)billType);
        DebtDetailBillBean bean = new DebtDetailBillBean();
        bean.setBillType(billType);
        bean.setUpCurrency(upCurrency);
        bean.setFundOrg(reportOrgSet.getLong("id"));
        bean.setBizDate(dateMap.get("bizdate"));
        Date reportStartTime = DateUtils.getDataFormat((Date)dateMap.get("reportperiod_startdate"), (boolean)true);
        Date reportEndTime = DateUtils.getDataFormat((Date)dateMap.get("reportperiod_enddate"), (boolean)false);
        bean.setStartDate(dateMap.get("reportperiod_startdate"));
        bean.setEndDate(dateMap.get("reportperiod_enddate"));
        bean.setDebtBillNo(resultData.getString(debtBillQueryFieldObj.getBillNo()));
        bean.setDebtType(debtType.getLong("id"));
        bean.setDebtOrg(resultData.getDynamicObject(debtBillQueryFieldObj.getOrg()).getLong("id"));
        BigDecimal srcDebtCapitalAmt = resultData.getBigDecimal(debtBillQueryFieldObj.getDebtCapitalAmt());
        Long srcCurrency = resultData.getDynamicObject(debtBillQueryFieldObj.getCurrency()).getLong("id");
        BigDecimal rate = LargeFundQueryHelper.getRate((Long)srcCurrency, (Long)upCurrency, (Long)resultData.getDynamicObject(debtBillQueryFieldObj.getOrg()).getLong("id"));
        bean.setDebtCapitalAmt(srcDebtCapitalAmt.multiply(rate));
        bean.setCreditorText(resultData.getString(debtBillQueryFieldObj.getCreditor()));
        bean.setDebtInterestRate(this.getLatestRate(resultData));
        bean.setDebtBizData(resultData.getDate(debtBillQueryFieldObj.getBizData()));
        bean.setExpireDate(resultData.getDate(debtBillQueryFieldObj.getExpireDate()));
        BigDecimal notRepayAmtSum = BigDecimal.ZERO;
        Date minRepaymentDate = null;
        DynamicObjectCollection investorEntry = resultData.getDynamicObjectCollection("investor_entry");
        BigDecimal maxInvestAmount = BigDecimal.ZERO;
        String investorName = "";
        for (Object investor : investorEntry) {
            BigDecimal eInvestAmount = investor.getBigDecimal("e_investamount");
            if (eInvestAmount.compareTo(maxInvestAmount) <= 0) continue;
            maxInvestAmount = eInvestAmount;
            investorName = investor.getString("e_investorname");
        }
        bean.setCreditorText(investorName);
        DynamicObjectCollection repayPlanEntry = resultData.getDynamicObjectCollection("repayplan_entry");
        for (DynamicObject repayPlan : repayPlanEntry) {
            Date exRepaymentDate = repayPlan.getDate("exrepaymentdate");
            if (!reportStartTime.before(exRepaymentDate) || !reportEndTime.after(exRepaymentDate)) continue;
            notRepayAmtSum = notRepayAmtSum.add(repayPlan.getBigDecimal("enotrepayamount"));
            if (minRepaymentDate == null) {
                minRepaymentDate = exRepaymentDate;
                continue;
            }
            if (!exRepaymentDate.before(minRepaymentDate)) continue;
            minRepaymentDate = exRepaymentDate;
        }
        notRepayAmtSum = notRepayAmtSum.multiply(rate);
        bean.setCurrentExpireAmt(notRepayAmtSum);
        bean.setCurrentExpireDate(minRepaymentDate);
        DebtDetailBillBean.EntryEntity entryEntity = new DebtDetailBillBean.EntryEntity();
        entryEntity.setSrcBillType(BillTypeEnum.getNameByValue((String)billType));
        entryEntity.setSrcBillNo(resultData.getString(debtBillQueryFieldObj.getBillNo()));
        entryEntity.setSrcDebtor(resultData.getDynamicObject(debtBillQueryFieldObj.getOrg()).getString("name"));
        entryEntity.setSrcCurrency(srcCurrency);
        entryEntity.setSrcAmount(srcDebtCapitalAmt);
        entryEntity.setSrcCreditor(investorName);
        entryEntity.setSrcStartDate(resultData.getDate(debtBillQueryFieldObj.getBizData()));
        entryEntity.setSrcEndDate(resultData.getDate(debtBillQueryFieldObj.getExpireDate()));
        ArrayList<DebtDetailBillBean.EntryEntity> entryEntities = new ArrayList<DebtDetailBillBean.EntryEntity>();
        entryEntities.add(entryEntity);
        bean.setSrcEntryEntity(entryEntities);
        return bean;
    }

    private BigDecimal getLatestRate(DynamicObject resultData) {
        Long id = resultData.getLong("id");
        QFilter qfilter = new QFilter("id", "=", (Object)id).and("drawtype", "!=", (Object)"closeout").and("rateadjust_entry.ra_effectdate", "<=", (Object)DateUtils.getCurrentDate());
        DynamicObjectCollection queryDatas = QueryServiceHelper.query((String)"cfm_loanbill", (String)"id,rateadjust_entry.ra_effectdate,rateadjust_entry.ra_yearrate", (QFilter[])qfilter.toArray());
        Map idObjMap = queryDatas.stream().collect(Collectors.toMap(o -> o.getLong("id"), Function.identity(), (a, b) -> a.getDate("rateadjust_entry.ra_effectdate").compareTo(b.getDate("rateadjust_entry.ra_effectdate")) >= 0 ? a : b));
        DynamicObject rateObj = (DynamicObject)idObjMap.get(id);
        if (EmptyUtil.isNoEmpty((DynamicObject)rateObj)) {
            return rateObj.getBigDecimal("rateadjust_entry.ra_yearrate");
        }
        return BigDecimal.ZERO;
    }
}

