/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.sar.business.service.debt;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.sar.business.opservice.debt.DebtDetailBillBean;
import kd.tmc.sar.business.service.debt.IDebtBillService;
import kd.tmc.sar.common.builder.DebtBillQueryFieldBuilder;
import kd.tmc.sar.common.enums.BillTypeEnum;
import kd.tmc.sar.common.helper.LargeFundQueryHelper;
import kd.tmc.sar.common.helper.LargeFundUseMatchHelper;
import org.apache.commons.lang3.tuple.Pair;

public class LcLetterCreditService
implements IDebtBillService {
    private static final Log LOGGER = LogFactory.getLog(LcLetterCreditService.class);

    @Override
    public void billF7Evt(DynamicObject fundOrg, Date reportEndDate, Set<Long> orgSet, Set<String> statusTs, Map<Long, Pair<Long, BigDecimal>> amtByOrg, boolean offInternalLoan, Set<String> unitTextSet, List<QFilter> qFilters) {
        Date reportEndTime = DateUtils.getDataFormat((Date)reportEndDate, (boolean)false);
        HashSet<Long> filterIds = new HashSet<Long>();
        Pair<Long, BigDecimal> pair = amtByOrg.get(999L);
        Long upCurrency = (Long)pair.getKey();
        BigDecimal threshold = ((BigDecimal)pair.getValue()).multiply(Constants.TEN_THOUSAND);
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("org", "in", orgSet);
        if (offInternalLoan) {
            qFilter.and("benefitertype", "!=", (Object)"bos_org");
            qFilter.and("benefiterother", "not in", unitTextSet);
        }
        qFilter.and("modifytime", "<=", (Object)reportEndTime).and("creditstatus", "not in", Arrays.asList("done_repeal", "done_close"));
        qFilter.and("billno", "not in", statusTs);
        DynamicObjectCollection lcBills = QueryServiceHelper.query((String)"lc_lettercredit", (String)"id, benefitertype, org, creditstatus, bizdate, applydate, creditno, remark, currency, amount", (QFilter[])qFilter.toArray());
        Map matchResult = LargeFundUseMatchHelper.getDebtMatchResult((String)"lc_lettercredit", (DynamicObjectCollection)lcBills);
        for (DynamicObject lcBill : lcBills) {
            Pair<Long, BigDecimal> decimalPair;
            DynamicObject debtType = (DynamicObject)matchResult.get(lcBill.getLong("id"));
            if (debtType != null && (decimalPair = amtByOrg.get(debtType.getLong("id"))) != null) {
                upCurrency = (Long)decimalPair.getKey();
                threshold = ((BigDecimal)decimalPair.getValue()).multiply(Constants.TEN_THOUSAND);
            }
            Long currency = lcBill.getLong("currency");
            BigDecimal rate = LargeFundQueryHelper.getRate((Long)currency, (Long)upCurrency, (Long)lcBill.getLong("org"));
            BigDecimal srcAmt = lcBill.getBigDecimal("amount");
            BigDecimal convertAmt = srcAmt.multiply(rate).setScale(20, RoundingMode.HALF_UP);
            if (convertAmt.compareTo(threshold) < 0) continue;
            filterIds.add(lcBill.getLong("id"));
        }
        qFilters.add(new QFilter("id", "in", filterIds));
    }

    @Override
    public void billCloseCallBack(String billType, DynamicObject resultData, IDataModel model) {
        DebtBillQueryFieldBuilder debtBillQueryFieldObj = DebtBillQueryFieldBuilder.getDebtBillQueryFieldObj((String)billType);
        Date reportStartTime = DateUtils.getDataFormat((Date)((Date)model.getValue("reportperiod_startdate")), (boolean)true);
        Date reportEndTime = DateUtils.getDataFormat((Date)((Date)model.getValue("reportperiod_enddate")), (boolean)false);
        DynamicObject fundOrg = (DynamicObject)model.getValue("fundorg");
        model.setValue("debtbillno", (Object)resultData.getString(debtBillQueryFieldObj.getBillNo()));
        long debtType = 0L;
        DynamicObjectCollection resultDatas = new DynamicObjectCollection();
        resultDatas.add((Object)resultData);
        Map matchResult = LargeFundUseMatchHelper.getDebtMatchResult((String)billType, (DynamicObjectCollection)resultDatas);
        long id = resultData.getLong("id");
        DynamicObject billResult = (DynamicObject)matchResult.get(id);
        if (billResult != null) {
            debtType = billResult.getLong("id");
        }
        model.setValue("debttype", (Object)debtType);
        model.setValue("debtorg", (Object)resultData.getDynamicObject(debtBillQueryFieldObj.getOrg()));
        DynamicObject fundThresholdInfo = LargeFundQueryHelper.getFundThresholdInfo((DynamicObject)fundOrg);
        BigDecimal srcDebtCapitalAmt = resultData.getBigDecimal(debtBillQueryFieldObj.getDebtCapitalAmt());
        Long srcCurrency = resultData.getDynamicObject(debtBillQueryFieldObj.getCurrency()).getLong("id");
        BigDecimal rate = LargeFundQueryHelper.getRate((Long)srcCurrency, (Long)fundThresholdInfo.getLong("currency"), (Long)resultData.getDynamicObject(debtBillQueryFieldObj.getOrg()).getLong("id"));
        model.setValue("debtcapitalamt", (Object)srcDebtCapitalAmt.multiply(rate));
        model.setValue("creditortext", (Object)resultData.getString(debtBillQueryFieldObj.getCreditor()));
        model.setValue("debtinterestrate", (Object)(EmptyUtil.isEmpty((String)debtBillQueryFieldObj.getDebtInterestRate()) ? Integer.valueOf(0) : resultData.getBigDecimal(debtBillQueryFieldObj.getDebtInterestRate())));
        model.setValue("debtbizdata", (Object)resultData.getDate(debtBillQueryFieldObj.getBizData()));
        model.setValue("expiredate", (Object)resultData.getDate(debtBillQueryFieldObj.getExpireDate()));
        BigDecimal notRepayAmtSum = BigDecimal.ZERO;
        Date minRepaymentDate = null;
        if (EmptyUtil.isEmpty((String)resultData.getString(debtBillQueryFieldObj.getCreditor()))) {
            model.setValue("creditortext", (Object)resultData.getString("benefiterother"));
        }
        QFilter arrivalFilter = new QFilter("lettercredit", "=", (Object)resultData.getLong("id"));
        arrivalFilter.and("arrivalstatus", "!=", (Object)"arrival_register");
        DynamicObjectCollection arrivalBills = QueryServiceHelper.query((String)"lc_arrival", (String)"id, arrivalamount, endpaydate", (QFilter[])arrivalFilter.toArray());
        for (DynamicObject arrivalBill : arrivalBills) {
            Date endPayDate;
            if (EmptyUtil.isEmpty((Object)resultData.getDate(debtBillQueryFieldObj.getExpireDate()))) {
                model.setValue("expiredate", (Object)arrivalBill.getDate("endpaydate"));
            }
            if (!DateUtils.isSameDay((Date)(endPayDate = (Date)model.getValue("expiredate")), (Date)arrivalBill.getDate("endpaydate")) || !reportStartTime.before(endPayDate) || !reportEndTime.after(endPayDate)) continue;
            notRepayAmtSum = resultData.getBigDecimal(debtBillQueryFieldObj.getCurrentExpireAmt());
            minRepaymentDate = endPayDate;
        }
        notRepayAmtSum = notRepayAmtSum.multiply(rate);
        model.setValue("currentexpireamt", (Object)notRepayAmtSum);
        model.setValue("currentexpiredate", minRepaymentDate);
        model.setValue("src_billtype", (Object)BillTypeEnum.getNameByValue((String)billType), 0);
        model.setValue("src_billno", (Object)resultData.getString(debtBillQueryFieldObj.getBillNo()), 0);
        model.setValue("src_debtor", (Object)resultData.getDynamicObject(debtBillQueryFieldObj.getOrg()).getString("name"), 0);
        model.setValue("src_currency", (Object)srcCurrency, 0);
        model.setValue("src_amount", (Object)srcDebtCapitalAmt, 0);
        model.setValue("src_creditor", (Object)resultData.getString(debtBillQueryFieldObj.getCreditor()), 0);
        model.setValue("src_startdate", (Object)resultData.getDate(debtBillQueryFieldObj.getBizData()), 0);
        model.setValue("src_enddate", (Object)resultData.getDate(debtBillQueryFieldObj.getExpireDate()), 0);
    }

    @Override
    public List<DebtDetailBillBean> queryBizData(DynamicObject reportOrgSet, Set<String> statusTs, Set<Long> orgSet, Map<Long, Pair<Long, BigDecimal>> amtByOrg, boolean offInternalLoan, Set<String> unitTextSet, Map<String, Date> dateMap) {
        ArrayList<DebtDetailBillBean> debtDetailBillBeanList = new ArrayList<DebtDetailBillBean>(16);
        Date reportEndTime = DateUtils.getDataFormat((Date)dateMap.get("reportperiod_enddate"), (boolean)false);
        HashSet<Long> filterIds = new HashSet<Long>();
        Pair<Long, BigDecimal> pair = amtByOrg.get(999L);
        Long upCurrency = (Long)pair.getKey();
        BigDecimal threshold = ((BigDecimal)pair.getValue()).multiply(Constants.TEN_THOUSAND);
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("org", "in", orgSet);
        if (offInternalLoan) {
            qFilter.and("benefitertype", "!=", (Object)"bos_org");
            qFilter.and("benefiterother", "not in", unitTextSet);
        }
        qFilter.and("modifytime", "<=", (Object)reportEndTime).and("creditstatus", "not in", Arrays.asList("done_repeal", "done_close"));
        qFilter.and("billno", "not in", statusTs);
        LOGGER.info("DebtDetail.lc_lettercredit.filter: {}", (Object)qFilter.toString());
        DynamicObjectCollection lcBills = QueryServiceHelper.query((String)"lc_lettercredit", (String)"id, billno, benefitertype, org, org.number, org.name, creditapplyno, bank.number, bank.name, bizcontactor.name, datasources,creditstatus, bizdate, applydate, creditno, remark, currency, currency.number, currency.name, amount, guarantee,isnationalcard, isforward, credittype.name, applycountry.name, benefitcountry.name, noticebank, cargodesc,billstatus, creator.name, negotiatingdate, createtime, modifier.name, auditor.name", (QFilter[])qFilter.toArray());
        LOGGER.info("DebtDetail.lc_lettercredit.lcBillSize: {}", (Object)lcBills.size());
        Map matchResult = LargeFundUseMatchHelper.getDebtMatchResult((String)"lc_lettercredit", (DynamicObjectCollection)lcBills);
        for (DynamicObject lcBill : lcBills) {
            Pair<Long, BigDecimal> decimalPair;
            DynamicObject debtType = (DynamicObject)matchResult.get(lcBill.getLong("id"));
            if (debtType != null && (decimalPair = amtByOrg.get(debtType.getLong("id"))) != null) {
                upCurrency = (Long)decimalPair.getKey();
                threshold = ((BigDecimal)decimalPair.getValue()).multiply(Constants.TEN_THOUSAND);
            }
            Long currency = lcBill.getLong("currency");
            BigDecimal rate = LargeFundQueryHelper.getRate((Long)currency, (Long)upCurrency, (Long)lcBill.getLong("org"));
            BigDecimal srcAmt = lcBill.getBigDecimal("amount");
            BigDecimal convertAmt = srcAmt.multiply(rate).setScale(20, RoundingMode.HALF_UP);
            if (convertAmt.compareTo(threshold) < 0) continue;
            filterIds.add(lcBill.getLong("id"));
        }
        LOGGER.info("DebtDetail.lc_lettercredit.filterIds: {}", (Object)((Object)filterIds).toString());
        DynamicObject[] bizDataList = TmcDataServiceHelper.load((Object[])filterIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"lc_lettercredit"));
        LOGGER.info("DebtDetail.lc_lettercredit.bizDataListSize: {}", (Object)bizDataList.length);
        for (DynamicObject bizData : bizDataList) {
            DynamicObject debtType = (DynamicObject)matchResult.get(bizData.getLong("id"));
            debtDetailBillBeanList.add(this.dynamicObjectToBean(reportOrgSet, bizData, debtType, upCurrency, dateMap));
        }
        LOGGER.info("DebtDetail.lc_lettercredit.beanList: {}", (Object)SerializationUtils.toJsonString(debtDetailBillBeanList));
        return debtDetailBillBeanList;
    }

    @Override
    public DebtDetailBillBean dynamicObjectToBean(DynamicObject reportOrgSet, DynamicObject resultData, DynamicObject debtType, Long upCurrency, Map<String, Date> dateMap) {
        String billType = resultData.getDataEntityType().getName();
        DebtBillQueryFieldBuilder debtBillQueryFieldObj = DebtBillQueryFieldBuilder.getDebtBillQueryFieldObj((String)billType);
        DebtDetailBillBean bean = new DebtDetailBillBean();
        bean.setBillType(billType);
        bean.setUpCurrency(upCurrency);
        bean.setFundOrg(reportOrgSet.getLong("id"));
        bean.setBizDate(dateMap.get("bizdate"));
        Date reportStartTime = DateUtils.getDataFormat((Date)dateMap.get("reportperiod_startdate"), (boolean)true);
        Date reportEndTime = DateUtils.getDataFormat((Date)dateMap.get("reportperiod_enddate"), (boolean)false);
        bean.setStartDate(dateMap.get("reportperiod_startdate"));
        bean.setEndDate(dateMap.get("reportperiod_enddate"));
        bean.setDebtBillNo(resultData.getString(debtBillQueryFieldObj.getBillNo()));
        bean.setDebtType(debtType.getLong("id"));
        bean.setDebtOrg(resultData.getDynamicObject(debtBillQueryFieldObj.getOrg()).getLong("id"));
        BigDecimal srcDebtCapitalAmt = resultData.getBigDecimal(debtBillQueryFieldObj.getDebtCapitalAmt());
        Long srcCurrency = resultData.getDynamicObject(debtBillQueryFieldObj.getCurrency()).getLong("id");
        BigDecimal rate = LargeFundQueryHelper.getRate((Long)srcCurrency, (Long)upCurrency, (Long)resultData.getDynamicObject(debtBillQueryFieldObj.getOrg()).getLong("id"));
        bean.setDebtCapitalAmt(srcDebtCapitalAmt.multiply(rate));
        bean.setCreditorText(resultData.getString(debtBillQueryFieldObj.getCreditor()));
        bean.setDebtInterestRate(EmptyUtil.isEmpty((String)debtBillQueryFieldObj.getDebtInterestRate()) ? BigDecimal.ZERO : resultData.getBigDecimal(debtBillQueryFieldObj.getDebtInterestRate()));
        bean.setDebtBizData(resultData.getDate(debtBillQueryFieldObj.getBizData()));
        bean.setExpireDate(resultData.getDate(debtBillQueryFieldObj.getExpireDate()));
        BigDecimal notRepayAmtSum = BigDecimal.ZERO;
        Date minRepaymentDate = null;
        if (EmptyUtil.isEmpty((String)resultData.getString(debtBillQueryFieldObj.getCreditor()))) {
            bean.setCreditorText(resultData.getString("benefiterother"));
        }
        QFilter arrivalFilter = new QFilter("lettercredit", "=", (Object)resultData.getLong("id"));
        arrivalFilter.and("arrivalstatus", "!=", (Object)"arrival_register");
        DynamicObjectCollection arrivalBills = QueryServiceHelper.query((String)"lc_arrival", (String)"id, arrivalamount, endpaydate", (QFilter[])arrivalFilter.toArray());
        for (DynamicObject arrivalBill : arrivalBills) {
            Date endPayDate;
            if (EmptyUtil.isEmpty((Object)resultData.getDate(debtBillQueryFieldObj.getExpireDate()))) {
                bean.setExpireDate(arrivalBill.getDate("endpaydate"));
            }
            if (!DateUtils.isSameDay((Date)(endPayDate = bean.getExpireDate()), (Date)arrivalBill.getDate("endpaydate")) || !reportStartTime.before(endPayDate) || !reportEndTime.after(endPayDate)) continue;
            notRepayAmtSum = arrivalBill.getBigDecimal("arrivalamount");
            minRepaymentDate = endPayDate;
        }
        notRepayAmtSum = notRepayAmtSum.multiply(rate);
        bean.setCurrentExpireAmt(notRepayAmtSum);
        bean.setCurrentExpireDate(minRepaymentDate);
        DebtDetailBillBean.EntryEntity entryEntity = new DebtDetailBillBean.EntryEntity();
        entryEntity.setSrcBillType(BillTypeEnum.getNameByValue((String)billType));
        entryEntity.setSrcBillNo(resultData.getString(debtBillQueryFieldObj.getBillNo()));
        entryEntity.setSrcDebtor(resultData.getDynamicObject(debtBillQueryFieldObj.getOrg()).getString("name"));
        entryEntity.setSrcCurrency(srcCurrency);
        entryEntity.setSrcAmount(srcDebtCapitalAmt);
        entryEntity.setSrcCreditor(resultData.getString(debtBillQueryFieldObj.getCreditor()));
        entryEntity.setSrcStartDate(resultData.getDate(debtBillQueryFieldObj.getBizData()));
        entryEntity.setSrcEndDate(resultData.getDate(debtBillQueryFieldObj.getExpireDate()));
        ArrayList<DebtDetailBillBean.EntryEntity> entryEntities = new ArrayList<DebtDetailBillBean.EntryEntity>();
        entryEntities.add(entryEntity);
        bean.setSrcEntryEntity(entryEntities);
        return bean;
    }
}

