/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.sar.business.validate.debt;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.sar.common.enums.UpStatusEnum;

public class DebtDetailBillUnUpdataValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billstatus");
        selector.add("upstatus");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity entity : dataEntity) {
            DynamicObject dynamicObject = entity.getDataEntity();
            String billStatus = dynamicObject.getString("billstatus");
            if (!BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u624d\u80fd\u53cd\u4e0a\u62a5\u3002", (String)"FundSumBillUnUpdataValidator_0", (String)"tmc-sar-business", (Object[])new Object[0]));
            }
            String upStatus = dynamicObject.getString("upstatus");
            if (UpStatusEnum.UPSUCESS.getValue().equals(upStatus)) continue;
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u4e0a\u62a5\u72b6\u6001\u4e3a\u4e0a\u62a5\u6210\u529f\u624d\u80fd\u53cd\u4e0a\u62a5\u3002", (String)"FundSumBillUnUpdataValidator_1", (String)"tmc-sar-business", (Object[])new Object[0]));
        }
    }
}

