/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.sar.business.validate.setting;

import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ReportFundOrgSaveValidator
extends AbstractTmcBizOppValidator {
    private static final String REPORTFUNDORG_SET = "org, number";

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("org");
        selector.add("org.id");
        selector.add("number");
        selector.add("name");
        selector.add("applyall");
        selector.add("accountentity");
        selector.add("c_org");
        return selector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        block3: for (ExtendedDataEntity entity : dataEntity) {
            DynamicObjectCollection accountEntities;
            DynamicObject dynamicObject = entity.getDataEntity();
            if (!dynamicObject.getBoolean("applyall") && EmptyUtil.isEmpty((DynamicObjectCollection)(accountEntities = dynamicObject.getDynamicObjectCollection("accountentity")))) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff01\u672a\u9002\u7528\u6240\u6709\u8d26\u6237\u65f6\uff0c\u8bf7\u586b\u5199\u53d6\u6570\u94f6\u884c\u8d26\u6237\u4fe1\u606f\u5206\u5f55\u3002", (String)"ReportFundOrgSaveValidator_3", (String)"tmc-sar-business", (Object[])new Object[0]));
                break;
            }
            Long id = dynamicObject.getLong("id");
            Long orgId = dynamicObject.getLong("org.id");
            String orgName = dynamicObject.getString("name");
            QFilter qFilter = new QFilter("collectionorgentity.c_org", "=", (Object)orgId);
            qFilter.and("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue());
            DynamicObjectCollection headQuery = QueryServiceHelper.query((String)"mon_reportfundorg", (String)REPORTFUNDORG_SET, (QFilter[])qFilter.toArray());
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)headQuery)) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff01%1$s\u5728%2$s\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u5b58\u5728\u3002", (String)"ReportFundOrgSaveValidator_1", (String)"tmc-sar-business", (Object[])new Object[0]), orgName, ((DynamicObject)headQuery.get(0)).getString("number")));
                continue;
            }
            if (!dynamicObject.getBoolean("collect")) continue;
            DynamicObjectCollection collectionOrgEntities = dynamicObject.getDynamicObjectCollection("collectionorgentity");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)collectionOrgEntities)) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff01\u6c47\u96c6\u4e0b\u7ea7\u7ec4\u7ec7\u65f6\uff0c\u8bf7\u586b\u5199\u6c47\u96c6\u7ec4\u7ec7\u8bbe\u7f6e\u4fe1\u606f\u3002", (String)"ReportFundOrgSaveValidator_0", (String)"tmc-sar-business", (Object[])new Object[0]));
                continue;
            }
            for (DynamicObject cOrgEntity : collectionOrgEntities) {
                Long cOrgId = cOrgEntity.getDynamicObject("c_org").getLong("id");
                String cOrgName = cOrgEntity.getDynamicObject("c_org").getString("name");
                if (orgId.equals(cOrgId)) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff01%s\u4e3a\u5f53\u524d\u4e0a\u62a5\u7ec4\u7ec7\uff0c\u4e0d\u5141\u8bb8\u518d\u4fdd\u5b58\u4e3a\u6c47\u96c6\u7ec4\u7ec7\u3002", (String)"ReportFundOrgSaveValidator_2", (String)"tmc-sar-business", (Object[])new Object[0]), cOrgName));
                    continue block3;
                }
                QFilter subQFilter = new QFilter("collectionorgentity.c_org", "=", (Object)cOrgId);
                subQFilter.or("org", "=", (Object)cOrgId);
                if (EmptyUtil.isNoEmpty((Long)id)) {
                    subQFilter.and("id", "!=", (Object)id);
                }
                subQFilter.and("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue());
                DataSet subQuery = null;
                try {
                    subQuery = QueryServiceHelper.queryDataSet((String)"ReportFundOrgSaveValidator.validate", (String)"mon_reportfundorg", (String)REPORTFUNDORG_SET, (QFilter[])subQFilter.toArray(), null).distinct();
                    if (subQuery.isEmpty()) continue;
                    for (Row row : subQuery) {
                        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff01%1$s\u5728%2$s\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u5b58\u5728\u3002", (String)"ReportFundOrgSaveValidator_1", (String)"tmc-sar-business", (Object[])new Object[0]), cOrgName, row.getString("number")));
                    }
                }
                finally {
                    if (subQuery == null) continue;
                    subQuery.close();
                }
            }
        }
    }
}

