/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.sar.formplugin.debt;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.sar.business.service.debt.IDebtBillService;
import kd.tmc.sar.common.enums.BillTypeEnum;
import kd.tmc.sar.common.helper.LargeFundHelper;
import kd.tmc.sar.common.helper.LargeFundQueryHelper;
import kd.tmc.sar.servicehelper.ServiceFactory;

public class DebtDetailEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener,
HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"debtbillno"});
        EntryGrid entryGrid = (EntryGrid)this.getControl("src_entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit debtOrg = (BasedataEdit)this.getControl("debtorg");
        debtOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("src_entryentity", rowIndex);
        String scrBillNo = entryRowEntity.getString("src_billno");
        String billType = (String)this.getModel().getValue("billtype");
        DynamicObject bizBill = QueryServiceHelper.queryOne((String)billType, (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)scrBillNo)});
        if (bizBill == null) {
            return;
        }
        HashMap<String, String> openParameter = new HashMap<String, String>();
        HashMap customParams = new HashMap();
        openParameter.put("formId", billType);
        openParameter.put("pkId", String.valueOf(bizBill.getLong("id")));
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(openParameter);
        showParameter.setCustomParams(customParams);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm(showParameter);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propName = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        switch (propName) {
            case "debtorg": {
                String appId = this.getView().getFormShowParameter().getAppId();
                List authorizedBankOrgId = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"sar_debtdetail", (String)"47150e89000000ac");
                List qFilters = formShowParameter.getListFilterParameter().getQFilters();
                qFilters.add(new QFilter("id", "in", (Object)authorizedBankOrgId));
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (!BillTypeEnum.CFM_LOANBILL_BOND.isEquals((String)this.getModel().getValue("billtype"))) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"creditortext"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object bizDate = this.getModel().getValue("bizdate");
        this.bizDateChange((Date)bizDate);
        long currentOrgId = TmcOrgDataHelper.getCurrentOrgId();
        if (EmptyUtil.isNoEmpty((Long)currentOrgId)) {
            QFilter qFilter = new QFilter("org.id", "=", (Object)currentOrgId);
            DynamicObject fundOrgId = TmcDataServiceHelper.loadSingle((String)"mon_reportfundorg", (String)"id", (QFilter[])qFilter.toArray());
            this.getModel().setValue("fundorg", (Object)fundOrgId);
            this.fundOrgChgEvt(fundOrgId);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object oldValue = changeSet[0].getOldValue();
        Object newValue = changeSet[0].getNewValue();
        switch (key) {
            case "bizdate": {
                if (EmptyUtil.isEmpty((Object)newValue)) {
                    return;
                }
                this.bizDateChange((Date)newValue);
                break;
            }
            case "fundorg": {
                this.fundOrgChgEvt(oldValue);
                break;
            }
            case "billtype": {
                this.getModel().setValue("debtbillno", null);
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (!"cfm_loanbill_bond".equals(newValue) ? 1 : 0) != 0, (String[])new String[]{"creditortext"});
                break;
            }
            case "debtbillno": {
                if (EmptyUtil.isEmpty((Object)newValue)) {
                    TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"currentexpireamt"});
                    TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"currentexpiredate"});
                    this.clearReport();
                    break;
                }
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"currentexpireamt"});
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"currentexpiredate"});
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("debtbillno".equals(key)) {
            this.debtBillNoF7Evt();
        }
    }

    private void clearReport() {
        this.getModel().setValue("debttype", null);
        this.getModel().setValue("debtorg", null);
        this.getModel().setValue("debtcapitalamt", null);
        this.getModel().setValue("creditortext", null);
        this.getModel().setValue("debtinterestrate", null);
        this.getModel().setValue("debtbizdata", null);
        this.getModel().setValue("expiredate", null);
        this.getModel().setValue("currentexpireamt", null);
        this.getModel().setValue("currentexpiredate", null);
    }

    private void bizDateChange(Date bizDate) {
        DynamicObject largeParamSet = LargeFundQueryHelper.getLargeParamSet();
        Map dateMap = LargeFundHelper.calPeriod((Date)bizDate, (DynamicObject)largeParamSet);
        this.getModel().setValue("reportperiod_startdate", dateMap.get("reportperiod_startdate"));
        this.getModel().setValue("reportperiod_enddate", dateMap.get("reportperiod_enddate"));
    }

    private void fundOrgChgEvt(Object oldValue) {
        DynamicObject fundOrg = (DynamicObject)this.getModel().getValue("fundorg");
        Long currencyId = null;
        DynamicObject largeThreshold = null;
        if (EmptyUtil.isEmpty((DynamicObject)fundOrg)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0a\u62a5\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u88ab\u6e05\u7a7a\u3002", (String)"FundSumBillEdit_01", (String)"tmc-sar-formplugin", (Object[])new Object[0]));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"fundorg", (Object)oldValue);
            return;
        }
        if (null != fundOrg && fundOrg.getBoolean("insystem")) {
            if (fundOrg.getBoolean("insystem")) {
                largeThreshold = QueryServiceHelper.queryOne((String)"mon_largethreshold", (String)"currency", (QFilter[])new QFilter[]{new QFilter("applyorgentity.ao_fundorg.id", "=", fundOrg.getPkValue()), new QFilter("enable", "=", (Object)"1")});
            }
            if (EmptyUtil.isEmpty(largeThreshold)) {
                largeThreshold = QueryServiceHelper.queryOne((String)"mon_largethreshold", (String)"currency", (QFilter[])new QFilter[]{new QFilter("applyall", "=", (Object)"1"), new QFilter("enable", "=", (Object)"1")});
            }
            if (null != largeThreshold) {
                currencyId = largeThreshold.getLong("currency");
            }
        }
        this.getModel().setValue("upcurrency", currencyId);
        this.getModel().setValue("debtbillno", null);
    }

    private void debtBillNoF7Evt() {
        if (!TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"fundorg")) {
            return;
        }
        DynamicObject fundOrg = (DynamicObject)this.getModel().getValue("fundorg");
        if (!fundOrg.getBoolean("insystem")) {
            return;
        }
        if (!TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"bizdate")) {
            return;
        }
        String billType = (String)this.getModel().getValue("billtype");
        IDebtBillService service = (IDebtBillService)ServiceFactory.getService((String)billType);
        Date reportEndDate = (Date)this.getModel().getValue("reportperiod_enddate");
        Set<Long> orgSet = this.collectOrg(fundOrg);
        Date queryDate = (Date)this.getModel().getValue("bizdate");
        Set<String> statusTs = this.getStatusTs(queryDate);
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)billType, (boolean)false, (int)0, (boolean)true);
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        Map amtByOrg = LargeFundQueryHelper.getDebtAmtByOrg((DynamicObject)fundOrg);
        DynamicObject largeParamSet = LargeFundQueryHelper.getLargeParamSet();
        boolean offInternalLoan = largeParamSet.getBoolean("offinternalloan");
        DynamicObjectCollection otherUnitSetEntities = largeParamSet.getDynamicObjectCollection("otherunitsetentity");
        Set unitTextSet = otherUnitSetEntities.stream().map(d -> d.getString("unittext")).collect(Collectors.toSet());
        if (offInternalLoan) {
            List bankRoll = LargeFundQueryHelper.getBankRoll();
            unitTextSet.addAll(bankRoll);
        }
        service.billF7Evt(fundOrg, reportEndDate, orgSet, statusTs, amtByOrg, offInternalLoan, unitTextSet, qFilters);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "debtbillno"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectedRows;
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if ("debtbillno".equals(key) && EmptyUtil.isNoEmpty((Object)(selectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData())) && selectedRows.size() > 0) {
            ListSelectedRow listSelectedRow = selectedRows.get(0);
            Object primaryKeyValue = listSelectedRow.getPrimaryKeyValue();
            String billType = (String)this.getModel().getValue("billtype");
            DynamicObject resultData = TmcDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)billType);
            IDebtBillService service = (IDebtBillService)ServiceFactory.getService((String)billType);
            service.billCloseCallBack(billType, resultData, this.getModel());
        }
    }

    private Set<Long> collectOrg(DynamicObject fundOrg) {
        DynamicObject org = fundOrg.getDynamicObject("org");
        HashSet<Long> orgSet = new HashSet<Long>(16);
        orgSet.add(org.getLong("id"));
        if (fundOrg.getBoolean("collect")) {
            DynamicObjectCollection cOrgEntities = fundOrg.getDynamicObjectCollection("collectionorgentity");
            for (DynamicObject cOrg : cOrgEntities) {
                orgSet.add(cOrg.getDynamicObject("c_org").getLong("id"));
            }
        }
        return orgSet;
    }

    private Set<String> getStatusTs(Date queryDate) {
        QFilter billStatusFilter = new QFilter("bizdate", "=", (Object)queryDate);
        billStatusFilter.and(new QFilter("billstatus", "in", Arrays.asList(BillStatusEnum.SUBMIT.getValue(), BillStatusEnum.AUDIT.getValue())));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"sar_debtdetail", (String)"src_entryentity.src_billno", (QFilter[])billStatusFilter.toArray());
        return query.stream().filter(o -> EmptyUtil.isNoEmpty((String)o.getString("src_entryentity.src_billno"))).map(d -> d.getString("src_entryentity.src_billno")).collect(Collectors.toSet());
    }
}

