/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.sar.formplugin.debt;

import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.sar.common.helper.LargeFundQueryHelper;

public class DebtDetailList
extends AbstractListPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject largeParamSet;
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        String key = source.getOperateKey();
        if ("new".equals(key) && (largeParamSet = LargeFundQueryHelper.getLargeParamSet()) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8fdb\u884c\u5927\u989d\u8d44\u91d1\u53c2\u6570\u8bbe\u7f6e\u3002", (String)"LargeFundDetailList_02", (String)"tmc-sar-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        if ("handgetdata".equals(opKey) && opResult.isSuccess()) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("mon_fundhandquery");
            showParameter.getOpenStyle().setShowType(ShowType.NonModal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "handgetdata"));
            this.getView().showForm(showParameter);
        } else if ("updata".equals(opKey) || "unupdata".equals(opKey)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("handgetdata".equals(actionId)) {
            Map data = (Map)evt.getReturnData();
            if (EmptyUtil.isEmpty((Object)data)) {
                return;
            }
            Date tradeDate = (Date)data.get("tradeDate");
            Object[] ids = LargeFundQueryHelper.queryReportOrgIdsByOrg((Map)data);
            OperateOption option = OperateOption.create();
            option.setVariableValue("tradedate", DateUtils.formatString((Date)tradeDate, (String)"yyyy-MM-dd"));
            OperationResult result = TmcOperateServiceHelper.execOperate((String)"debtquerydata", (String)"mon_reportfundorg", (Object[])ids, (OperateOption)option);
            if (result.isSuccess()) {
                String message = result.getMessage();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u624b\u5de5\u53d6\u6570\u64cd\u4f5c\u6210\u529f,\u53d6\u6570\u6210\u529f%s\u6761\u3002", (String)"FundSumBillList_01", (String)"tmc-sar-formplugin", (Object[])new Object[]{message != null ? message : "0"}));
            }
            this.getView().invokeOperation("refresh");
        }
    }
}

