/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.sar.formplugin.largefunddetail;

import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.EntityFieldTreeOption;
import kd.tmc.fbp.common.util.EntityFieldTreeResult;
import kd.tmc.fbp.common.util.EntityTreeUtil;
import kd.tmc.fbp.common.util.ExpressionType;

public class FundMatchRuleEdit
extends AbstractBasePlugIn
implements ClickListener {
    private static final String NON_FIELDS = "non_fields";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"condition"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if ("condition".equals(key)) {
            int index = this.getModel().getEntryCurrentRowIndex("entryentity");
            this.fillFields();
            this.showConditionForm(index, this.getPageCache().get("conditiondata"));
        }
    }

    private void fillFields() {
        MainEntityType type = this.readSrcMainET();
        if (type == null) {
            this.getPageCache().put("conditiondata", "");
        } else {
            EntityFieldTreeOption option = EntityFieldTreeOption.create();
            option.setEntityType((IDataEntityType)type);
            option.setReadEntryEntity(false);
            option.setExprType(ExpressionType.Condition);
            option.setFieldType(null);
            EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes((EntityFieldTreeOption)option);
            TreeNode tree = EntityTreeUtil.buildBillTree((List)result.getNodes());
            String toJson = SerializationUtils.toJsonString((Object)tree);
            this.getPageCache().put("conditiondata", toJson);
            String nonFdStr = this.getPageCache().get(NON_FIELDS);
            if (nonFdStr != null) {
                Set nonSet = (Set)SerializationUtils.fromJsonString((String)nonFdStr, Set.class);
                nonSet.addAll(result.getNonFields());
                this.getPageCache().put(NON_FIELDS, SerializationUtils.toJsonString((Object)nonSet));
            } else {
                this.getPageCache().put(NON_FIELDS, SerializationUtils.toJsonString((Object)result.getNonFields()));
            }
        }
    }

    private MainEntityType readSrcMainET() {
        return EntityMetadataCache.getDataEntityType((String)((String)this.getModel().getValue("billtype")));
    }

    private void showConditionForm(int rowIndex, String fieldNodes) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cas_condition");
        String conditionJson = (String)this.getModel().getValue("conditiondata_TAG", rowIndex);
        showParameter.getCustomParams().put("formula", conditionJson);
        String handle = (String)this.getModel().getValue("billtype");
        showParameter.getCustomParams().put("onlyheadfield", Boolean.TRUE.toString());
        showParameter.getCustomParams().put("entitynumber", handle);
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.setCustomParam(NON_FIELDS, (Object)this.getPageCache().get(NON_FIELDS));
        String funcsxml = this.getPageCache().get("functiontypes");
        if (StringUtils.isBlank((CharSequence)funcsxml)) {
            FunctionTypes functionTypes = FunctionTypes.get();
            funcsxml = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
            this.getPageCache().put("functiontypes", funcsxml);
        }
        showParameter.getCustomParams().put("functiontypes", funcsxml);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "conditiondata"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("conditiondata".equals(e.getActionId())) {
            this.receiveExpressionSet(e);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        String key = source.getOperateKey();
        if ("save".equals(key)) {
            String number = (String)this.getModel().getValue("number");
            String billtype = (String)this.getModel().getValue("billtype");
            QFilter qFilter = new QFilter("billtype", "=", (Object)billtype);
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            qFilter.and(new QFilter("number", "!=", (Object)number));
            boolean exists = TmcDataServiceHelper.exists((String)this.getView().getEntityId(), (QFilter[])new QFilter[]{qFilter});
            if (exists) {
                this.getModel().setValue("enable", (Object)"0");
            }
        }
    }

    private void receiveExpressionSet(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() != null) {
            String str = (String)closedCallBackEvent.getReturnData();
            int row = this.getModel().getEntryCurrentRowIndex("entryentity");
            if (StringUtils.isBlank((CharSequence)str)) {
                this.getModel().setValue("conditiondata", (Object)"", row);
            } else {
                CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)str, CRCondition.class);
                this.getModel().setValue("conditiondata_TAG", (Object)str, row);
                String desp = "";
                if (StringUtils.isNotEmpty((CharSequence)filterObj.getExprTran().trim())) {
                    desp = filterObj.getExprTran();
                }
                if (desp.length() > 1024) {
                    desp = desp.substring(0, 1024);
                }
                this.getModel().setValue("condition", (Object)desp, row);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        if ("funduse".equals(propName)) {
            if (EmptyUtil.isEmpty((Object)newValue)) {
                return;
            }
            int index = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
            entity.remove(index);
            List ids = entity.stream().map(d -> d.getDynamicObject("funduse").getLong("id")).collect(Collectors.toList());
            long newValueId = ((DynamicObject)newValue).getLong("id");
            if (ids.contains(newValueId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u8be5\u5927\u989d\u8d44\u91d1\u7528\u9014\uff0c\u9009\u62e9\u5931\u8d25\u3002", (String)"FundMatchRuleEdit_1", (String)"tmc-sar-formplugin", (Object[])new Object[0]));
                TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (int)index, (String[])new String[]{"funduse"});
            }
        } else if ("debttype".equals(propName)) {
            int index = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
            entity.remove(index);
            List ids = entity.stream().map(d -> d.getDynamicObject("debttype").getLong("id")).collect(Collectors.toList());
            long newValueId = ((DynamicObject)newValue).getLong("id");
            if (ids.contains(newValueId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u8be5\u503a\u52a1\u7c7b\u578b\uff0c\u9009\u62e9\u5931\u8d25\u3002", (String)"FundMatchRuleEdit_0", (String)"tmc-sar-formplugin", (Object[])new Object[0]));
                TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (int)index, (String[])new String[]{"debttype"});
            }
        }
    }
}

