/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.sar.formplugin.largefunddetail;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.sar.common.enums.AgreedQuotationEnum;
import kd.tmc.sar.common.enums.BillSourceEnum;
import kd.tmc.sar.common.helper.LargeFundQueryHelper;

public class LargeFundDetailEdit
extends AbstractBasePlugIn
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entrysGrid = (EntryGrid)this.getControl("entryentity");
        entrysGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String source = (String)this.getModel().getValue("source");
        if (BillSourceEnum.MANUAL.getValue().equals(source)) {
            ((BasedataEdit)this.getView().getControl("oppunit")).setMustInput(true);
        }
    }

    public void afterBindData(EventObject e) {
        DynamicObjectCollection entryEntity;
        String direction;
        String oppunittext;
        super.afterBindData(e);
        String source = (String)this.getModel().getValue("source");
        if (BillSourceEnum.SYSTEM.getValue().equals(source)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"bizdate", "direction", "oppunittype", "oppunit", "oppunittext"});
        }
        if (EmptyUtil.isEmpty((String)(oppunittext = (String)this.getModel().getValue("oppunittext")).trim())) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"oppunittype", "oppunit", "oppunittext"});
        }
        if (EmptyUtil.isEmpty((String)(direction = (String)this.getModel().getValue("direction")).trim())) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"direction"});
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(entryEntity = this.getModel().getEntryEntity("entryentity")))) {
            int rowCount = entryEntity.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                if (!this.isCurrencyEqual(i).booleanValue()) continue;
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"e_rate", "e_discountamt"});
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long currentOrgId = TmcOrgDataHelper.getCurrentOrgId();
        if (EmptyUtil.isNoEmpty((Long)currentOrgId)) {
            QFilter qFilter = new QFilter("org.id", "=", (Object)currentOrgId);
            DynamicObject fundOrgId = TmcDataServiceHelper.loadSingle((String)"mon_reportfundorg", (String)"id", (QFilter[])qFilter.toArray());
            this.getModel().setValue("fundorg", (Object)fundOrgId);
            this.fundOrgChgEvt(fundOrgId);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        DynamicObject funuse = (DynamicObject)this.getModel().getValue("funuse");
        Object oldValue = e.getChangeSet()[0].getOldValue();
        switch (propName) {
            case "oppunittype": {
                TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"oppunit", "oppunittext"});
                break;
            }
            case "oppunit": {
                DynamicObject oppUnit = (DynamicObject)this.getModel().getValue("oppunit");
                if (!EmptyUtil.isNoEmpty((DynamicObject)oppUnit)) break;
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"oppunittext", (Object)oppUnit.getString("name"));
                break;
            }
            case "fundorg": {
                this.fundOrgChgEvt(oldValue);
                break;
            }
            case "funuse": {
                Object fundorg = this.getModel().getValue("fundorg");
                DynamicObject funduse = LargeFundQueryHelper.getFundThresholdInfo((DynamicObject)((DynamicObject)fundorg));
                boolean aBoolean = funduse.getBoolean("byfunduse");
                BigDecimal threshold = funduse.getBigDecimal("defaultthreshold").multiply(new BigDecimal("10000"));
                if (aBoolean) {
                    DynamicObjectCollection thresholdentity = QueryServiceHelper.query((String)"mon_largethreshold", (String)"thresholdentity,thresholdentity.ts_funduse,thresholdentity.ts_threshold", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)funduse.getLong("id"))});
                    for (DynamicObject object : thresholdentity) {
                        Long fundUseId = object.getLong("thresholdentity.ts_funduse");
                        if (funuse == null || fundUseId.longValue() != funuse.getLong("id")) continue;
                        threshold = object.getBigDecimal("thresholdentity.ts_threshold").multiply(new BigDecimal("10000"));
                    }
                }
                this.getModel().setValue("thresholdamt", (Object)threshold);
                break;
            }
            case "e_rate": {
                e.getProperty();
                this.handleRateChange();
                break;
            }
            case "e_discountamt": {
                this.handleDiscountAmtChange(oldValue);
                break;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        String source = entryRowEntity.getString("e_source");
        String scrbillno = entryRowEntity.getString("e_scrbillno");
        String billnoType = this.getBillnoType(source);
        if (StringUtils.isNotEmpty((CharSequence)billnoType)) {
            DynamicObject bizBill = "cas_bankjournal".equals(billnoType) ? QueryServiceHelper.queryOne((String)billnoType, (String)"id", (QFilter[])new QFilter[]{new QFilter("sourcebillnumber", "=", (Object)scrbillno)}) : QueryServiceHelper.queryOne((String)billnoType, (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)scrbillno)});
            if (bizBill == null) {
                return;
            }
            HashMap<String, String> openParameter = new HashMap<String, String>();
            HashMap customParams = new HashMap();
            openParameter.put("formId", billnoType);
            openParameter.put("pkId", String.valueOf(bizBill.getLong("id")));
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(openParameter);
            showParameter.setCustomParams(customParams);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm(showParameter);
        }
    }

    private String getBillnoType(String source) {
        switch (source) {
            case "transdetail": {
                return "bei_transdetail";
            }
            case "bankjournal": {
                return "cas_bankjournal";
            }
            case "recbill": {
                return "cas_recbill";
            }
            case "paybill": {
                return "cas_paybill";
            }
        }
        return "";
    }

    private void handleRateChange() {
        BigDecimal rateBig;
        BigDecimal amtBig;
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        if (this.isCurrencyEqual(rowIndex).booleanValue()) {
            return;
        }
        Object detailAmt = this.getModel().getValue("e_detailamt", rowIndex);
        Object rate = this.getModel().getValue("e_rate", rowIndex);
        Object discountAmtOld = this.getModel().getValue("e_discountamt", rowIndex);
        BigDecimal bigDecimal = detailAmt instanceof BigDecimal ? (BigDecimal)detailAmt : (amtBig = new BigDecimal(detailAmt == null ? "0" : detailAmt.toString()));
        BigDecimal bigDecimal2 = rate instanceof BigDecimal ? (BigDecimal)rate : (rateBig = new BigDecimal(rate == null ? "0" : rate.toString()));
        BigDecimal discountAmtOldBig = discountAmtOld instanceof BigDecimal ? (BigDecimal)discountAmtOld : new BigDecimal(discountAmtOld == null ? "0" : discountAmtOld.toString());
        String agreedQuotation = (String)this.getModel().getValue("e_agreedquotation");
        BigDecimal discountAmtBig = AgreedQuotationEnum.INDIRECT.getValue().equals(agreedQuotation) ? amtBig.divide(rateBig, 10, RoundingMode.HALF_UP) : amtBig.multiply(rateBig).setScale(10, RoundingMode.HALF_UP);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_discountamt", (Object)discountAmtBig, (int)rowIndex);
        Object convertAmt = this.getModel().getValue("convertamt");
        BigDecimal convertAmtBig = convertAmt instanceof BigDecimal ? (BigDecimal)convertAmt : new BigDecimal(convertAmt == null ? "0" : convertAmt.toString());
        this.getModel().setValue("convertamt", (Object)convertAmtBig.add(discountAmtBig.subtract(discountAmtOldBig)));
    }

    private void handleDiscountAmtChange(Object oldValue) {
        BigDecimal convertAmtBig;
        BigDecimal amtBig;
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        if (this.isCurrencyEqual(rowIndex).booleanValue()) {
            return;
        }
        Object detailAmt = this.getModel().getValue("e_detailamt", rowIndex);
        Object discountAmt = this.getModel().getValue("e_discountamt", rowIndex);
        BigDecimal bigDecimal = detailAmt instanceof BigDecimal ? (BigDecimal)detailAmt : (amtBig = new BigDecimal(detailAmt == null ? "0" : detailAmt.toString()));
        BigDecimal discountAmtBig = discountAmt instanceof BigDecimal ? (BigDecimal)discountAmt : new BigDecimal(discountAmt == null ? "0" : discountAmt.toString());
        String agreedQuotation = (String)this.getModel().getValue("e_agreedquotation");
        BigDecimal rateBig = AgreedQuotationEnum.INDIRECT.getValue().equals(agreedQuotation) ? amtBig.divide(discountAmtBig, 10, 0) : discountAmtBig.divide(amtBig, 10, 0);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_rate", (Object)rateBig, (int)rowIndex);
        Object convertAmt = this.getModel().getValue("convertamt");
        BigDecimal bigDecimal2 = convertAmt instanceof BigDecimal ? (BigDecimal)convertAmt : (convertAmtBig = new BigDecimal(convertAmt == null ? "0" : convertAmt.toString()));
        BigDecimal oldValueBig = oldValue instanceof BigDecimal ? (BigDecimal)oldValue : new BigDecimal(oldValue == null ? "0" : oldValue.toString());
        this.getModel().setValue("convertamt", (Object)convertAmtBig.add(discountAmtBig.subtract(oldValueBig)));
    }

    private Boolean isCurrencyEqual(int rowIndex) {
        DynamicObject upCurrency = (DynamicObject)this.getModel().getValue("upcurrency");
        DynamicObject eCurrency = (DynamicObject)this.getModel().getValue("e_currency", rowIndex);
        if (EmptyUtil.isNoEmpty((DynamicObject)upCurrency) && EmptyUtil.isNoEmpty((DynamicObject)eCurrency) && !upCurrency.getPkValue().equals(eCurrency.getPkValue())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void fundOrgChgEvt(Object oldValue) {
        Object value = this.getModel().getValue("fundorg");
        DynamicObject funuse = (DynamicObject)this.getModel().getValue("funuse");
        if (value == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0a\u62a5\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u88ab\u6e05\u7a7a\u3002", (String)"FundSumBillEdit_01", (String)"tmc-sar-formplugin", (Object[])new Object[0]));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"fundorg", (Object)oldValue);
            return;
        }
        DynamicObject fund = LargeFundQueryHelper.getFundThresholdInfo((DynamicObject)((DynamicObject)value));
        DynamicObject defCurrency = TmcDataServiceHelper.loadSingle((Object)fund.getLong("currency"), (String)"bd_currency");
        boolean byfunduse = fund.getBoolean("byfunduse");
        BigDecimal defaultDecimal = null;
        if (byfunduse && funuse != null) {
            long funuseId = funuse.getLong("id");
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"mon_largethreshold", (String)"thresholdentity,thresholdentity.ts_funduse,thresholdentity.ts_threshold", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)fund.getLong("id"))});
            for (DynamicObject dynamicObject : collection) {
                Long id = dynamicObject.getLong("thresholdentity.ts_funduse");
                if (id != funuseId) continue;
                defaultDecimal = dynamicObject.getBigDecimal("thresholdentity.ts_threshold").multiply(new BigDecimal("10000"));
            }
        } else {
            defaultDecimal = fund.getBigDecimal("defaultthreshold").multiply(new BigDecimal("10000"));
        }
        this.getModel().setValue("upcurrency", (Object)defCurrency);
        if (defaultDecimal != null) {
            this.getModel().setValue("thresholdamt", (Object)defaultDecimal);
        }
    }
}

