/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.sar.formplugin.setting;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ReportFundOrgEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)Boolean.TRUE, (String[])new String[]{"org"});
        Boolean applyAll = (Boolean)this.getModel().getValue("applyall");
        this.handleApplyAll(applyAll);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Boolean inSystem = (Boolean)this.getModel().getValue("insystem");
        if (!inSystem.booleanValue()) {
            this.getModel().setValue("applyall", (Object)Boolean.TRUE);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit accountF7 = (BasedataEdit)this.getControl("a_account");
        accountF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit collectionOrg = (BasedataEdit)this.getControl("c_org");
        collectionOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String propName = evt.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        switch (propName) {
            case "a_account": {
                this.accountF7Filter(formShowParameter, evt);
                break;
            }
            case "c_org": {
                this.collectionOrgFilter(formShowParameter, evt);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        Object newVal = e.getChangeSet()[0].getNewValue();
        switch (propName) {
            case "insystem": {
                this.handleInSystem((Boolean)newVal);
                break;
            }
            case "applyall": {
                this.handleApplyAll((Boolean)newVal);
                break;
            }
            case "org": {
                this.handleHeadOrg();
                break;
            }
        }
    }

    private void accountF7Filter(ListShowParameter formShowParameter, BeforeF7SelectEvent evt) {
        List qFilters = formShowParameter.getListFilterParameter().getQFilters();
        if (!TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"org")) {
            evt.setCancel(true);
            return;
        }
        HashSet bankIds = new HashSet(16);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        qFilters.add(TmcAccountHelper.getAccountBankFilterByOrg((Long)((Long)org.getPkValue())));
        DynamicObjectCollection ids = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
        bankIds.addAll(ids.stream().map(i -> i.getLong("id")).collect(Collectors.toSet()));
        DynamicObjectCollection cOrgEntities = this.getModel().getEntryEntity("collectionorgentity");
        for (DynamicObject cOrgEntity : cOrgEntities) {
            DynamicObject cOrg = cOrgEntity.getDynamicObject("c_org");
            if (!EmptyUtil.isNoEmpty((DynamicObject)cOrg)) continue;
            qFilters.remove(qFilters.size() - 1);
            qFilters.add(TmcAccountHelper.getAccountBankFilterByOrg((Long)((Long)cOrg.getPkValue())));
            ids = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
            bankIds.addAll(ids.stream().map(i -> i.getLong("id")).collect(Collectors.toList()));
        }
        DynamicObjectCollection accountEntities = this.getModel().getEntryEntity("accountentity");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)accountEntities)) {
            for (DynamicObject entity : accountEntities) {
                DynamicObject account = entity.getDynamicObject("a_account");
                if (!EmptyUtil.isNoEmpty((DynamicObject)account)) continue;
                bankIds.remove((Long)account.getPkValue());
            }
        }
        qFilters.clear();
        qFilters.add(new QFilter("id", "in", bankIds));
    }

    private void collectionOrgFilter(ListShowParameter formShowParameter, BeforeF7SelectEvent evt) {
        List qFilters = formShowParameter.getListFilterParameter().getQFilters();
        if (!TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"org")) {
            evt.setCancel(true);
            return;
        }
        DynamicObject headOrg = (DynamicObject)this.getModel().getValue("org");
        qFilters.add(new QFilter("id", "!=", headOrg.getPkValue()));
        DynamicObjectCollection collectionOrgEntities = this.getModel().getEntryEntity("collectionorgentity");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)collectionOrgEntities)) {
            ArrayList<Long> ids = new ArrayList<Long>(collectionOrgEntities.size());
            for (DynamicObject entity : collectionOrgEntities) {
                DynamicObject org = entity.getDynamicObject("c_org");
                if (!EmptyUtil.isNoEmpty((DynamicObject)org)) continue;
                ids.add((Long)org.getPkValue());
            }
            qFilters.add(new QFilter("id", "not in", ids));
        }
    }

    private void handleInSystem(Boolean isInSystem) {
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isInSystem, (String[])new String[]{"org"});
    }

    private void handleApplyAll(Boolean isApplyAll) {
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isApplyAll, (String[])new String[]{"source"});
    }

    private void handleHeadOrg() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            this.getModel().setValue("name", null);
            return;
        }
        this.getModel().setValue("number", (Object)org.getString("number"));
        this.getModel().setValue("name", (Object)org.getString("name"));
        this.getModel().deleteEntryData("accountentity");
    }
}

