/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.scf.business.opservice.fincredit;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.service.paywriteback.AbstractPayBillWriteBackService;
import kd.tmc.fbp.service.paywriteback.PayBillWriteBackParam;
import kd.tmc.scf.common.enums.FinanceNatureEnum;
import kd.tmc.scf.common.resource.ScfCommonResourceEnum;

public class FincreditBillPayBillWriteBackService
extends AbstractPayBillWriteBackService {
    private static Log logger = LogFactory.getLog(FincreditBillPayBillWriteBackService.class);

    protected void doSaveExecute(PayBillWriteBackParam param, DynamicObject fincredit) {
        PayBillWriteBackParam.PayBillInfo payBillInfo = param.getPayBill();
        fincredit.set("payeebillno", (Object)payBillInfo.getPayBillNo());
        fincredit.set("paybill", (Object)payBillInfo.getPayBillId());
        fincredit.set("lockpayamt", (Object)payBillInfo.getAmount());
        this.DBTxBizUpdate(fincredit);
    }

    protected void doSubmitExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.doSaveExecute(param, sourceBill);
    }

    protected void doSaveValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        String financeProperty = sourceBill.getString("financenature");
        if (!financeProperty.equals(FinanceNatureEnum.APPLYRECOURSE.getValue())) {
            throw new KDBizException(ScfCommonResourceEnum.Push2PayValidator_0.loadKDString());
        }
        super.doSaveValidateExecute(param, sourceBill);
    }

    protected void doSubmitValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.doSaveValidateExecute(param, sourceBill);
    }

    protected void doChargebackExecute(PayBillWriteBackParam param, DynamicObject fincredit) {
        this.doDeleteExecute(param, fincredit);
    }

    protected void doRenoteExecute(PayBillWriteBackParam param, DynamicObject fincredit) {
        this.doDeleteExecute(param, fincredit);
    }

    protected void doDeleteExecute(PayBillWriteBackParam param, DynamicObject fincredit) {
        fincredit.set("payeebillno", (Object)"");
        fincredit.set("paybill", null);
        fincredit.set("lockpayamt", (Object)BigDecimal.ZERO);
        this.DBTxBizUpdate(fincredit);
    }

    protected DynamicObject getSourceBill(PayBillWriteBackParam.PayBillInfo payBillInfo) {
        return TmcDataServiceHelper.loadSingle((Object)payBillInfo.getSourceBillId(), (String)"scf_fincreditbill", (String)"billno,amount,currency,bizdate,payeebillno,paybill,lockpayamt,financenature");
    }

    protected Long getSourceBillCurrencyId(DynamicObject sourceBill) {
        return sourceBill.getDynamicObject("currency").getLong("id");
    }

    protected BigDecimal getSourceBillPayAmount(DynamicObject sourceBill) {
        return sourceBill.getBigDecimal("amount");
    }
}

