/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.scf.business.opservice.fincredit;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.scf.common.enums.ScfBizStatusEnum;

public class FincreditUnBuybackService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bizstatus");
        selector.add("billstatus");
        selector.add("confirmationor");
        selector.add("confirmationdate");
        selector.add("confirmationorg");
        selector.add("creditlimit");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<Object> finrepayIds = new ArrayList<Object>(dataEntities.length);
        for (DynamicObject fincredit : dataEntities) {
            DynamicObject finrepay;
            fincredit.set("bizstatus", (Object)ScfBizStatusEnum.CONFIRMED.getValue());
            if (EmptyUtil.isNoEmpty((DynamicObject)fincredit.getDynamicObject("creditlimit"))) {
                CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)fincredit, null, (boolean)false);
            }
            if (!EmptyUtil.isNoEmpty((DynamicObject)(finrepay = TmcBotpHelper.getTargetBill((String)fincredit.getDataEntityType().getName(), (Object)fincredit.getPkValue(), (String)"cas_paybill"))) || !finrepay.getString("billstatus").equals(BillStatusEnum.SAVE.getValue())) continue;
            finrepayIds.add(finrepay.getPkValue());
        }
        if (EmptyUtil.isNoEmpty(finrepayIds)) {
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"cas_paybill", (Object[])finrepayIds.toArray(), (OperateOption)OperateOption.create(), (boolean)true);
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }
}

