/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.scf.business.opservice.findebts;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.scf.common.enums.ScfBizStatusEnum;

public class FinDebtsBillCancelReturnDraftService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billno");
        selector.add("bizstatus");
        selector.add("returndraftdate");
        selector.add("returndraftreason");
        selector.add("scfapplybillf7");
        selector.add("org");
        selector.add("company");
        selector.add("orgcreditlimit");
        selector.add("creditlimit");
        selector.add("currency");
        selector.add("amount");
        selector.add("funderbank");
        return selector;
    }

    public void process(DynamicObject[] infos) throws KDException {
        for (DynamicObject info : infos) {
            info.set("bizstatus", (Object)ScfBizStatusEnum.CONFIRMED.getValue());
            info.set("returndraftdate", null);
            info.set("returndraftreason", null);
            DynamicObject creditLimitInfo = info.getDynamicObject("creditlimit");
            DynamicObject orgCreditLimitInfo = info.getDynamicObject("orgcreditlimit");
            if (!EmptyUtil.isNoEmpty((DynamicObject)creditLimitInfo) && !EmptyUtil.isNoEmpty((DynamicObject)orgCreditLimitInfo)) continue;
            CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)info, null, (boolean)false);
        }
        SaveServiceHelper.save((DynamicObject[])infos);
        Object[] applyIds = Arrays.stream(infos).filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("scfapplybillf7"))).map(o -> o.getDynamicObject("scfapplybillf7").getLong("id")).toArray();
        if (EmptyUtil.isNoEmpty((Object[])applyIds)) {
            DynamicObject[] applybills;
            for (DynamicObject applybill : applybills = TmcDataServiceHelper.load((String)"scf_debtsapplybill", (String)"bizstatus,returndraftdate,returndraftreason", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)applyIds)})) {
                applybill.set("bizstatus", (Object)ScfBizStatusEnum.CONFIRMED.getValue());
                applybill.set("returndraftdate", null);
                applybill.set("returndraftreason", null);
            }
            SaveServiceHelper.save((DynamicObject[])applybills);
        }
    }
}

