/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.scf.business.opservice.findebts;

import java.util.Arrays;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.scf.common.enums.ScfBizStatusEnum;

public class FinDebtsBillConfirmService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billno");
        selector.add("tradechannel");
        selector.add("bizstatus");
        selector.add("billstatus");
        selector.add("scfapplybillf7");
        selector.add("confirmer");
        selector.add("confirmtime");
        selector.add("confirmorg");
        selector.add("creditlimit");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        this.updateConfimInfo(dataEntities);
        Object[] applyIds = Arrays.stream(dataEntities).filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("scfapplybillf7"))).map(o -> o.getDynamicObject("scfapplybillf7").getLong("id")).toArray();
        if (EmptyUtil.isNoEmpty((Object[])applyIds)) {
            DynamicObject[] applybills = TmcDataServiceHelper.load((String)"scf_debtsapplybill", (String)"bizstatus,confirmer,confirmtime,confirmorg", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)applyIds)});
            this.updateConfimInfo(applybills);
        }
    }

    private void updateConfimInfo(DynamicObject[] waitUpdateInfos) {
        for (DynamicObject info : waitUpdateInfos) {
            info.set("bizstatus", (Object)ScfBizStatusEnum.CONFIRMED.getValue());
            info.set("confirmer", (Object)RequestContext.get().getCurrUserId());
            info.set("confirmtime", (Object)DateUtils.getCurrentTime());
            info.set("confirmorg", (Object)RequestContext.get().getOrgId());
        }
        SaveServiceHelper.save((DynamicObject[])waitUpdateInfos);
    }
}

