/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.scf.business.opservice.findebts;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.scf.common.enums.ScfBizStatusEnum;
import kd.tmc.scf.common.helper.BusinessHelper;

public class FinDebtsBillRepayService
extends AbstractTmcBizOppService {
    private static final Log LOGGER = LogFactory.getLog(FinDebtsBillRepayService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billno");
        selector.add("tradechannel");
        selector.add("bizstatus");
        selector.add("billstatus");
        selector.add("scfapplybillf7");
        selector.add("confirmer");
        selector.add("confirmtime");
        selector.add("confirmorg");
        return selector;
    }

    public void process(DynamicObject[] infos) throws KDException {
        LOGGER.info(ResManager.loadKDString((String)"\u4e0b\u63a8\u8fd8\u6b3e\u5355\u5f00\u59cb-->", (String)"FinDebtsBillRepayService_0", (String)"tmc-scf-business", (Object[])new Object[0]));
        TmcOperateServiceHelper.execOperate((String)"push2repay", (String)"scf_findebtsbill", (DynamicObject[])infos, (OperateOption)OperateOption.create(), (boolean)true);
        LOGGER.info(ResManager.loadKDString((String)"\u4e0b\u63a8\u8fd8\u6b3e\u5355\u7ed3\u675f-->", (String)"FinDebtsBillRepayService_1", (String)"tmc-scf-business", (Object[])new Object[0]));
        BusinessHelper.updateApplyBillStatus((DynamicObject[])infos, (String)ScfBizStatusEnum.REPAYING.getValue());
        for (DynamicObject info : infos) {
            info.set("bizstatus", (Object)ScfBizStatusEnum.REPAYING.getValue());
        }
        SaveServiceHelper.update((DynamicObject[])infos);
    }

    public void handlerException(DynamicObject[] infos) throws KDException {
        Object[] finDebetsIds = Arrays.stream(infos).map(DataEntityBase::getPkValue).toArray();
        DeleteServiceHelper.delete((String)"scf_finrepaybill", (QFilter[])new QFilter("findebtsbillf7", "in", (Object)finDebetsIds).toArray());
    }
}

