/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.scf.business.opservice.findebts;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.scf.common.enums.ScfBizStatusEnum;

public class FinDebtsBillReturnDraftService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billno");
        selector.add("bizstatus");
        selector.add("returndraftdate");
        selector.add("returndraftreason");
        selector.add("scfapplybillf7");
        selector.add("org");
        selector.add("creditlimit");
        selector.add("company");
        selector.add("orgcreditlimit");
        selector.add("currency");
        selector.add("amount");
        selector.add("funderbank");
        return selector;
    }

    public void process(DynamicObject[] infos) throws KDException {
        Map operationVariable = this.getOperationVariable();
        String returnDraftDateStr = (String)operationVariable.get("returndraftdate");
        Date returnDraftDate = DateUtils.getCurrentDate();
        if (EmptyUtil.isNoEmpty((String)returnDraftDateStr)) {
            DateUtils.stringToDate((String)returnDraftDateStr, (String)"yyyy-MM-dd HH:mm:ss");
        }
        String returnDraftReason = (String)operationVariable.get("returndraftreason");
        for (DynamicObject info : infos) {
            info.set("returndraftdate", (Object)returnDraftDate);
            info.set("returndraftreason", (Object)returnDraftReason);
            info.set("bizstatus", (Object)ScfBizStatusEnum.REFUNDED.getValue());
            DynamicObject creditLimitInfo = info.getDynamicObject("creditlimit");
            DynamicObject orgCreditLimitInfo = info.getDynamicObject("orgcreditlimit");
            if (!EmptyUtil.isNoEmpty((DynamicObject)creditLimitInfo) && !EmptyUtil.isNoEmpty((DynamicObject)orgCreditLimitInfo)) continue;
            CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)info, null, (boolean)false);
        }
        SaveServiceHelper.save((DynamicObject[])infos);
        Object[] applyIds = Arrays.stream(infos).filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("scfapplybillf7"))).map(o -> o.getDynamicObject("scfapplybillf7").getLong("id")).toArray();
        if (EmptyUtil.isNoEmpty((Object[])applyIds)) {
            DynamicObject[] applybills;
            for (DynamicObject applybill : applybills = TmcDataServiceHelper.load((String)"scf_debtsapplybill", (String)"bizstatus,returndraftdate,returndraftreason", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)applyIds)})) {
                applybill.set("bizstatus", (Object)ScfBizStatusEnum.REFUNDED.getValue());
                applybill.set("returndraftreason", (Object)returnDraftReason);
                applybill.set("returndraftdate", (Object)returnDraftDate);
            }
            SaveServiceHelper.save((DynamicObject[])applybills);
        }
    }
}

