/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.scf.business.opservice.finrepay;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.ReturnCreditLimitInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.scf.common.enums.ScfBizStatusEnum;
import kd.tmc.scf.common.helper.BusinessHelper;

public class FinRepayBillAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bizstatus");
        selector.add("findebtsbillf7");
        selector.add("amount");
        selector.add("billno");
        selector.add("billstatus");
        selector.add("genapplypaybill");
        selector.add("fintype");
        selector.add("applypayacct");
        selector.add("bankcheckflag");
        selector.add("bizdate");
        selector.add("id");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        this.dealRepayBizInfo(dataEntities);
    }

    private void dealRepayBizInfo(DynamicObject[] dataEntities) {
        HashMap id2RepayDates = new HashMap();
        Object[] debtsIds = Arrays.stream(dataEntities).map(o -> {
            id2RepayDates.put(o.getDynamicObject("findebtsbillf7").getLong("id"), o.getDate("bizdate"));
            return o.getDynamicObject("findebtsbillf7").getLong("id");
        }).toArray();
        DynamicObject[] debtsBills = TmcDataServiceHelper.load((String)"scf_findebtsbill", (String)"id,bizstatus,yetrepayamt,norepayamt,scfapplybillf7,billno,creditlimit,orgcreditlimit,repaydate,repayer", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)debtsIds)});
        BusinessHelper.updateApplyBillStatus((DynamicObject[])debtsBills, (String)ScfBizStatusEnum.YETREPAY.getValue());
        for (DynamicObject debtsBill : debtsBills) {
            debtsBill.set("yetrepayamt", (Object)debtsBill.getBigDecimal("norepayamt"));
            debtsBill.set("norepayamt", (Object)BigDecimal.ZERO);
            debtsBill.set("repaydate", id2RepayDates.get(debtsBill.getLong("id")));
            debtsBill.set("bizstatus", (Object)ScfBizStatusEnum.YETREPAY.getValue());
            debtsBill.set("repayer", (Object)RequestContext.get().getCurrUserId());
        }
        SaveServiceHelper.save((DynamicObject[])debtsBills);
        this.dealCreditmLimitInfo(dataEntities, debtsBills);
    }

    private void dealCreditmLimitInfo(DynamicObject[] dataEntities, DynamicObject[] debtsBills) {
        Map<Long, DynamicObject> debtsIdObjs = Arrays.stream(debtsBills).filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("creditlimit")) || EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("orgcreditlimit"))).collect(Collectors.toMap(o -> o.getLong("id"), o -> o));
        ArrayList<ReturnCreditLimitInfo> paramList = new ArrayList<ReturnCreditLimitInfo>();
        for (DynamicObject info : dataEntities) {
            Long debtsId = info.getDynamicObject("findebtsbillf7").getLong("id");
            DynamicObject debtsBill = debtsIdObjs.get(debtsId);
            if (!EmptyUtil.isNoEmpty((DynamicObject)debtsBill)) continue;
            BigDecimal repayAmt = info.getBigDecimal("amount");
            ReturnCreditLimitInfo info2 = FinRepayBillAuditService.getReturnInfo(info);
            info2.setReturnAmt(repayAmt);
            info2.setId(debtsId);
            info2.setEntityName("scf_findebtsbill");
            info2.setLast(true);
            info2.setReturnBillId(debtsId);
            HashMap<Long, BigDecimal> entryReturnAmtMap = new HashMap<Long, BigDecimal>(2);
            entryReturnAmtMap.put(1L, repayAmt);
            entryReturnAmtMap.put(2L, repayAmt);
            info2.setEntryReturnAmtMap(entryReturnAmtMap);
            info2.setBizBillId((Long)info.getPkValue());
            paramList.add(info2);
        }
        if (paramList.size() > 0) {
            CreditLimitServiceHelper.batchRreturnCreditLimit(paramList);
        }
    }

    private static ReturnCreditLimitInfo getReturnInfo(DynamicObject bill) {
        ReturnCreditLimitInfo param = new ReturnCreditLimitInfo();
        param.setPreOccupy(false);
        param.setPreEntityName(bill.getDynamicObjectType().getName());
        param.setBizBillId((Long)bill.getPkValue());
        return param;
    }
}

