/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.scf.business.opservice.finrepay;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.AcctClassifyEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.scf.common.enums.FinTypeEnum;
import kd.tmc.scf.common.helper.BusinessHelper;

public class FinRepayBillPush2PayService
extends AbstractTmcBizOppService {
    private static final Log LOGGER = LogFactory.getLog(FinRepayBillPush2PayService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bizstatus");
        selector.add("findebtsbillf7");
        selector.add("amount");
        selector.add("billno");
        selector.add("billstatus");
        selector.add("genapplypaybill");
        selector.add("fintype");
        selector.add("applypayacct");
        selector.add("bankcheckflag");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        try {
            BusinessHelper.push2Paybill((String)"orgpush2pay", (String)"scf_finrepaybill", (DynamicObject[])dataEntities);
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u751f\u6210\u4ed8\u6b3e\u5355\u5931\u8d25:%1$s", (String)"FincreditBuybackService_0", (String)"tmc-scf-business", (Object[])new Object[0]), e.getMessage()));
        }
        for (DynamicObject info : dataEntities) {
            String finType = info.getString("fintype");
            DynamicObject applyPayAcct = info.getDynamicObject("applypayacct");
            String acctClassify = "";
            if (EmptyUtil.isNoEmpty((DynamicObject)applyPayAcct)) {
                acctClassify = applyPayAcct.getString("acctclassify");
            }
            if (FinTypeEnum.ZIKAI.getValue().equals(finType) || !AcctClassifyEnum.INNER_ACCOUNT.getValue().equals(acctClassify)) continue;
            this.push2InnerPayBill(info);
        }
    }

    private void push2InnerPayBill(DynamicObject info) {
        String bankCheckFlag = BusinessHelper.pushInnerSettlePayBill((DynamicObject)info, (String)info.getDataEntityType().getName(), (boolean)true);
    }
}

