/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.scf.business.opservice.finrepay;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.AcctClassifyEnum;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.model.interest.ReturnCreditLimitInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.scf.common.enums.FinTypeEnum;
import kd.tmc.scf.common.enums.ScfBizStatusEnum;
import kd.tmc.scf.common.helper.BusinessHelper;

public class FinRepayBillUnAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bizstatus");
        selector.add("findebtsbillf7");
        selector.add("amount");
        selector.add("billno");
        selector.add("billstatus");
        selector.add("genapplypaybill");
        selector.add("fintype");
        selector.add("applypayacct");
        selector.add("bankcheckflag");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        Object[] debtsIds = Arrays.stream(dataEntities).map(o -> o.getDynamicObject("findebtsbillf7").getLong("id")).toArray();
        DynamicObject[] debtsBills = TmcDataServiceHelper.load((String)"scf_findebtsbill", (String)"id,bizstatus,yetrepayamt,norepayamt,billno,creditlimit,orgcreditlimit,scfapplybillf7,repaydate", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)debtsIds)});
        BusinessHelper.updateApplyBillStatus((DynamicObject[])debtsBills, (String)ScfBizStatusEnum.REPAYING.getValue());
        for (DynamicObject debtsBill : debtsBills) {
            debtsBill.set("norepayamt", (Object)debtsBill.getBigDecimal("yetrepayamt"));
            debtsBill.set("yetrepayamt", (Object)BigDecimal.ZERO);
            debtsBill.set("repaydate", (Object)"");
            debtsBill.set("bizstatus", (Object)ScfBizStatusEnum.REPAYING.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])debtsBills);
        this.dealCreditmLimitInfo(dataEntities, debtsBills);
        this.deleteTargetBills(dataEntities);
    }

    private void deleteTargetBills(DynamicObject[] dataEntities) {
        for (DynamicObject info : dataEntities) {
            boolean genApplyPaybill = info.getBoolean("genapplypaybill");
            String finType = info.getString("fintype");
            DynamicObject applyPayAcct = info.getDynamicObject("applypayacct");
            String acctClassify = "";
            if (EmptyUtil.isNoEmpty((DynamicObject)applyPayAcct)) {
                acctClassify = applyPayAcct.getString("acctclassify");
            }
            if (!genApplyPaybill || FinTypeEnum.ZIKAI.getValue().equals(finType) || !AcctClassifyEnum.INNER_ACCOUNT.getValue().equals(acctClassify)) {
                Map botpMap = BFTrackerServiceHelper.findTargetBills((String)info.getDataEntityType().getName(), (Long[])new Long[]{info.getLong("id")});
                if (botpMap == null || botpMap.size() <= 0) continue;
                for (Map.Entry entry : botpMap.entrySet()) {
                    TmcOperateServiceHelper.execOperate((String)"delete", (String)((String)entry.getKey()), (Object[])((HashSet)entry.getValue()).toArray(), (OperateOption)OperateOption.create(), (boolean)true);
                }
                continue;
            }
            this.deleteInnerAcctTargetBills(info);
        }
    }

    private void deleteInnerAcctTargetBills(DynamicObject repayBill) {
        Map botpMap = BFTrackerServiceHelper.findTargetBills((String)repayBill.getDynamicObjectType().getName(), (Long[])new Long[]{repayBill.getLong("id")});
        Set destIds = (Set)botpMap.get("ifm_transhandlebill");
        if (EmptyUtil.isNoEmpty((Object)destIds)) {
            TmcOperateServiceHelper.execOperate((String)"canclepay", (String)"ifm_transhandlebill", (Object[])destIds.toArray(new Long[0]), (OperateOption)OperateOption.create(), (boolean)true);
        }
        if (EmptyUtil.isNoEmpty((Object)(destIds = (Set)botpMap.get("cas_paybill")))) {
            DynamicObject[] payBills;
            for (DynamicObject payBill : payBills = TmcDataServiceHelper.load((String)"cas_paybill", (String)"billstatus,id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)destIds)})) {
                BusinessHelper.deleteRecOrPayBill((DynamicObject)payBill);
            }
        }
    }

    private void dealCreditmLimitInfo(DynamicObject[] dataEntities, DynamicObject[] debtsBills) {
        Map<Long, DynamicObject> debtsIdObjs = Arrays.stream(debtsBills).filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("creditlimit")) || EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("orgcreditlimit"))).collect(Collectors.toMap(o -> o.getLong("id"), o -> o));
        for (DynamicObject info : dataEntities) {
            Long debtsId = info.getDynamicObject("findebtsbillf7").getLong("id");
            DynamicObject debtsBill = debtsIdObjs.get(debtsId);
            if (!EmptyUtil.isNoEmpty((DynamicObject)debtsBill)) continue;
            ArrayList<ReturnCreditLimitInfo> paramList = new ArrayList<ReturnCreditLimitInfo>();
            ReturnCreditLimitInfo param = new ReturnCreditLimitInfo();
            param.setId(debtsId);
            param.setEntityName("scf_findebtsbill");
            param.setPreOccupy(false);
            param.setReturnBillId(debtsId);
            param.setBizBillId(Long.valueOf(info.getLong("id")));
            paramList.add(param);
            if (paramList.size() <= 0) continue;
            CreditLimitServiceHelper.batchCancelReturnCreditLimit(paramList);
        }
    }
}

