/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.scf.business.validate.debtsapply;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.OppUnitTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DebtsApplyBillSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("amount");
        selector.add("draftamount");
        selector.add("contractamount");
        selector.add("startdate");
        selector.add("enddate");
        selector.add("recertype");
        selector.add("recer");
        selector.add("recerf7");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject info = extendedDataEntity.getDataEntity();
            BigDecimal amount = (BigDecimal)info.get("amount");
            if (amount.compareTo(new BigDecimal(0)) < 0) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u878d\u8d44\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (String)"DebtsApplyBillSaveValidator_4", (String)"tmc-scf-business", (Object[])new Object[0]));
                continue;
            }
            BigDecimal draftAmount = (BigDecimal)info.get("draftamount");
            if (draftAmount.compareTo(new BigDecimal(0)) < 0) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53d1\u7968\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (String)"DebtsApplyBillSaveValidator_5", (String)"tmc-scf-business", (Object[])new Object[0]));
                continue;
            }
            BigDecimal contractAmount = (BigDecimal)info.get("contractamount");
            if (contractAmount.compareTo(new BigDecimal(0)) < 0) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5408\u540c\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (String)"DebtsApplyBillSaveValidator_6", (String)"tmc-scf-business", (Object[])new Object[0]));
                continue;
            }
            Date startDate = (Date)info.get("startdate");
            Date endDate = (Date)info.get("enddate");
            if (startDate.getTime() >= endDate.getTime()) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5230\u671f\u65e5\u5fc5\u987b\u5927\u4e8e\u5f00\u59cb\u65e5", (String)"DebtsApplyBillSaveValidator_7", (String)"tmc-scf-business", (Object[])new Object[0]));
            }
            String recerType = info.getString("recertype");
            boolean isOther = OppUnitTypeEnum.OTHER.getValue().equals(recerType);
            if ((!isOther || !EmptyUtil.isEmpty((Object)info.get("recer"))) && (isOther || !EmptyUtil.isEmpty((Object)info.get("recerf7")))) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u4e0d\u80fd\u4e3a\u7a7a", (String)"FinDebtsBillSubmitValidator_3", (String)"tmc-scf-business", (Object[])new Object[0]));
        }
    }
}

