/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.scf.business.validate.fincredit;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.scf.common.enums.FinanceNatureEnum;
import kd.tmc.scf.common.enums.ScfBizStatusEnum;

public class FincreditBuybackValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("id");
        sic.add("billno");
        sic.add("billstatus");
        sic.add("bizstatus");
        sic.add("financenature");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject finance = dataEntity.getDataEntity();
            String billno = finance.getString("billno");
            String billStatus = finance.getString("billstatus");
            String bizStatus = finance.getString("bizstatus");
            String financeProperty = finance.getString("financenature");
            if (billStatus.equals(BillStatusEnum.AUDIT.getValue()) && bizStatus.equals(ScfBizStatusEnum.CONFIRMED.getValue()) && financeProperty.equals(FinanceNatureEnum.APPLYRECOURSE.getValue())) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7[%s]\u53ea\u6709\u4e1a\u52a1\u72b6\u6001\u4e3a\u5df2\u786e\u6743\u4e14\u878d\u8d44\u6027\u8d28\u4e3a\u201c\u7533\u8bf7\u65b9\u8ffd\u7d22\u201d\u65f6\u624d\u5141\u8bb8\u56de\u8d2d\u3002", (String)"FincreditBuybackValidator_0", (String)"tmc-scf-business", (Object[])new Object[0]), billno));
        }
    }
}

