/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.scf.business.validate.fincredit;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.scf.common.enums.ScfBizStatusEnum;

public class FincreditCancelValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("id");
        sic.add("billno");
        sic.add("billstatus");
        sic.add("bizstatus");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject finance = dataEntity.getDataEntity();
            String billno = finance.getString("billno");
            String billStatus = finance.getString("billstatus");
            String bizStatus = finance.getString("bizstatus");
            if (billStatus.equals(BillStatusEnum.AUDIT.getValue()) && bizStatus.equals(ScfBizStatusEnum.CONFIRMED.getValue())) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7f16\u53f7%s\u7684\u4f9b\u5e94\u94fe\u878d\u8d44\u5355\u7684\u5355\u636e\u72b6\u6001\u4e0d\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\u6216\u4e1a\u52a1\u72b6\u6001\u4e0d\u4e3a\u201c\u5df2\u786e\u6743\u201d\uff0c\u4e0d\u5141\u8bb8\u6ce8\u9500\u3002", (String)"FincreditCancelValidator_0", (String)"tmc-scf-business", (Object[])new Object[0]), billno));
        }
    }
}

