/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.scf.business.validate.fincredit;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.scf.common.enums.ScfBizStatusEnum;

public class FincreditUnBuybackValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("id");
        sic.add("billno");
        sic.add("billstatus");
        sic.add("bizstatus");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject payBill;
            DynamicObject finance = dataEntity.getDataEntity();
            String billno = finance.getString("billno");
            String billStatus = finance.getString("billstatus");
            String bizStatus = finance.getString("bizstatus");
            if (!billStatus.equals(BillStatusEnum.AUDIT.getValue()) || !bizStatus.equals(ScfBizStatusEnum.BUYBACK.getValue())) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u5355\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\u72b6\u6001\u4e14\u4e1a\u52a1\u72b6\u6001\u4e3a\u201c\u5df2\u56de\u8d2d\u201d\u7684\u6570\u636e\u624d\u53ef\u4ee5\u53d6\u6d88\u56de\u8d2d\u3002", (String)"FincreditUnBuybackValidator_0", (String)"tmc-scf-business", (Object[])new Object[0]));
            }
            if (!EmptyUtil.isNoEmpty((DynamicObject)(payBill = TmcBotpHelper.getTargetBill((String)finance.getDataEntityType().getName(), (Object)finance.getPkValue(), (String)"cas_paybill"))) || payBill.getString("billstatus").equals(BillStatusEnum.SAVE.getValue())) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7f16\u53f7%s\u7684\u4f9b\u5e94\u94fe\u878d\u8d44\u5355\u5df2\u5b58\u5728\u4e0b\u6e38\u4ed8\u6b3e\u5355\u636e\uff0c\u8bf7\u5148\u64cd\u4f5c\u4e0b\u6e38\u5355\u636e\u6253\u56de\u540e\uff0c\u518d\u505a\u53d6\u6d88\u56de\u8d2d\u3002", (String)"FincreditUnBuybackValidator_1", (String)"tmc-scf-business", (Object[])new Object[0]), billno));
        }
    }
}

