/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.scf.business.validate.findebts;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.scf.common.enums.ScfBizStatusEnum;

public class FinDebtsBillCancelRepayValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billno");
        selector.add("tradechannel");
        selector.add("bizstatus");
        selector.add("billstatus");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject info = extendedDataEntity.getDataEntity();
            String billStatus = info.getString("billstatus");
            if (!BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8be5\u4f9b\u5e94\u94fe\u878d\u8d44\u5355\u7684\u5355\u636e\u72b6\u6001\u4e0d\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u53d6\u6d88\u8fd8\u6b3e\u3002", (String)"FinDebtsBillCancelRepayValidator_0", (String)"tmc-scf-business", (Object[])new Object[0]));
                continue;
            }
            String bizStatus = info.getString("bizstatus");
            if (!ScfBizStatusEnum.REPAYING.getValue().equals(bizStatus)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8be5\u4f9b\u5e94\u94fe\u878d\u8d44\u5355\u7684\u4e1a\u52a1\u72b6\u6001\u4e0d\u4e3a\u201c\u8fd8\u6b3e\u4e2d\u201d\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u53d6\u6d88\u8fd8\u6b3e\u3002", (String)"FinDebtsBillCancelRepayValidator_1", (String)"tmc-scf-business", (Object[])new Object[0]));
                continue;
            }
            DynamicObjectCollection finRepayBill = QueryServiceHelper.query((String)"scf_finrepaybill", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("findebtsbillf7", "=", info.getPkValue())});
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)finRepayBill)) continue;
            String billstatus = ((DynamicObject)finRepayBill.get(0)).getString("billstatus");
            if (BillStatusEnum.SAVE.getValue().equals(billstatus)) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8be5\u4f9b\u5e94\u94fe\u878d\u8d44\u5355\u5df2\u5b58\u5728\u4e0b\u6e38\u4f9b\u5e94\u94fe\u878d\u8d44\u8fd8\u6b3e\u5355\u636e,\u4e0d\u662f\u6682\u5b58\u72b6\u6001\uff0c\u8bf7\u5148\u53cd\u5411\u64cd\u4f5c\u4e0b\u6e38\u5355\u636e\uff0c\u518d\u505a\u53d6\u6d88\u8fd8\u6b3e", (String)"FinDebtsBillCancelRepayValidator_2", (String)"tmc-scf-business", (Object[])new Object[0]));
        }
    }
}

