/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.scf.business.validate.findebts;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.scf.common.enums.ScfBizStatusEnum;
import kd.tmc.scf.common.enums.TradeChannelEnum;

public class FinDebtsBillConfirmValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billno");
        selector.add("tradechannel");
        selector.add("bizstatus");
        selector.add("billstatus");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject info = extendedDataEntity.getDataEntity();
            String tradeChannel = info.getString("tradechannel");
            if (TradeChannelEnum.ONLINE.getValue().equals(tradeChannel)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8be5\u4f9b\u5e94\u94fe\u878d\u8d44\u5355\u7684\u4ea4\u6613\u6e20\u9053\u4e3a\u201c\u94f6\u4f01\u4e92\u8054\u201d,\u4e0d\u5141\u8bb8\u64cd\u4f5c\u786e\u6743", (String)"FinDebtsBillConfirmValidator_0", (String)"tmc-scf-business", (Object[])new Object[0]));
                continue;
            }
            String billStatus = info.getString("billstatus");
            if (!BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8be5\u4f9b\u5e94\u94fe\u878d\u8d44\u5355\u7684\u5355\u636e\u72b6\u6001\u4e0d\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u786e\u6743\u3002", (String)"FinDebtsBillConfirmValidator_1", (String)"tmc-scf-business", (Object[])new Object[0]));
                continue;
            }
            String bizStatus = info.getString("bizstatus");
            if (ScfBizStatusEnum.REGISTERING.getValue().equals(bizStatus)) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8be5\u4f9b\u5e94\u94fe\u878d\u8d44\u5355\u7684\u4e1a\u52a1\u72b6\u6001\u4e0d\u4e3a\u201c\u767b\u8bb0\u4e2d\u201d\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u786e\u6743\u3002", (String)"FinDebtsBillConfirmValidator_2", (String)"tmc-scf-business", (Object[])new Object[0]));
        }
    }
}

