/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.scf.business.validate.findebts;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.scf.common.enums.ScfBizStatusEnum;

public class FinDebtsBillRepayValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billno");
        selector.add("tradechannel");
        selector.add("bizstatus");
        selector.add("billstatus");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject sfbBill;
            DynamicObject info = extendedDataEntity.getDataEntity();
            String billStatus = info.getString("billstatus");
            if (!BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8be5\u4f9b\u5e94\u94fe\u878d\u8d44\u5355\u7684\u5355\u636e\u72b6\u6001\u4e0d\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u8fd8\u6b3e\u3002", (String)"FinDebtsBillRepayValidator_0", (String)"tmc-scf-business", (Object[])new Object[0]));
                continue;
            }
            String bizStatus = info.getString("bizstatus");
            if (!ScfBizStatusEnum.CONFIRMED.getValue().equals(bizStatus)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8be5\u4f9b\u5e94\u94fe\u878d\u8d44\u5355\u7684\u4e1a\u52a1\u72b6\u6001\u4e0d\u4e3a\u201c\u5df2\u786e\u6743\u201d\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u8fd8\u6b3e\u3002", (String)"FinDebtsBillRepayValidator_1", (String)"tmc-scf-business", (Object[])new Object[0]));
            }
            if (!EmptyUtil.isNoEmpty((DynamicObject)(sfbBill = TmcBotpHelper.getTargetBill((String)info.getDataEntityType().getName(), (Object)info.getPkValue(), (String)"scf_finrepaybill")))) continue;
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7f16\u53f7%s\u7684\u4f9b\u5e94\u94fe\u878d\u8d44\u503a\u52a1\u4e1a\u52a1\u5904\u7406\u5df2\u5b58\u5728\u4e0b\u6e38\u4f9b\u5e94\u94fe\u878d\u8d44\u8fd8\u6b3e\u5904\u7406\u5355\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u4e0b\u63a8", (String)"FinDebtsBillRepayValidator_2", (String)"tmc-scf-business", (Object[])new Object[0]), info.getString("billno")));
        }
    }
}

