/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.scf.business.validate.findebts;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.OppUnitTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.scf.common.enums.TradeChannelEnum;

public class FinDebtsBillSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billno");
        selector.add("tradechannel");
        selector.add("bizstatus");
        selector.add("billstatus");
        selector.add("funder");
        selector.add("amount");
        selector.add("recertype");
        selector.add("recer");
        selector.add("recerf7");
        selector.add("startdate");
        selector.add("enddate");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject info = extendedDataEntity.getDataEntity();
            String tradeChannel = info.getString("tradechannel");
            DynamicObject funderInfo = info.getDynamicObject("funder");
            if (EmptyUtil.isNoEmpty((DynamicObject)funderInfo)) {
                boolean isbank = funderInfo.getBoolean("isbank");
                if (isbank || !TradeChannelEnum.ONLINE.getValue().equals(tradeChannel)) continue;
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8be5\u5355\u636e\u7ef4\u62a4\u7684\u8d44\u91d1\u65b9\u4e0d\u652f\u6301\u5728\u7ebf\u529e\u7406\u4f9b\u5e94\u94fe\u878d\u8d44\u4e1a\u52a1\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u63d0\u4ea4", (String)"FinDebtsBillSubmitValidator_0", (String)"tmc-scf-business", (Object[])new Object[0]));
                continue;
            }
            BigDecimal amount = (BigDecimal)info.get("amount");
            if (EmptyUtil.isEmpty((BigDecimal)amount)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u878d\u8d44\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (String)"FinDebtsBillSubmitValidator_1", (String)"tmc-scf-business", (Object[])new Object[0]));
                continue;
            }
            Date startDate = (Date)info.get("startdate");
            Date endDate = (Date)info.get("enddate");
            if (startDate.getTime() >= endDate.getTime()) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5230\u671f\u65e5\u5fc5\u987b\u5927\u4e8e\u5f00\u59cb\u65e5", (String)"FinDebtsBillSubmitValidator_2", (String)"tmc-scf-business", (Object[])new Object[0]));
                continue;
            }
            String recerType = info.getString("recertype");
            boolean isOther = OppUnitTypeEnum.OTHER.getValue().equals(recerType);
            if ((!isOther || !EmptyUtil.isEmpty((Object)info.get("recer"))) && (isOther || !EmptyUtil.isEmpty((Object)info.get("recerf7")))) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u4e0d\u80fd\u4e3a\u7a7a", (String)"FinDebtsBillSubmitValidator_3", (String)"tmc-scf-business", (Object[])new Object[0]));
        }
    }
}

