/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.scf.business.validate.finrepay;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.AcctClassifyEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.scf.common.enums.FinTypeEnum;
import kd.tmc.scf.common.helper.BusinessHelper;

public class FinRepayBillUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billno");
        selector.add("id");
        selector.add("bizstatus");
        selector.add("findebtsbillf7");
        selector.add("amount");
        selector.add("billno");
        selector.add("billstatus");
        selector.add("genapplypaybill");
        selector.add("fintype");
        selector.add("applypayacct");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            String checkTargetBillsMsg;
            DynamicObject info = extendedDataEntity.getDataEntity();
            boolean genApplyPaybill = info.getBoolean("genapplypaybill");
            String finType = info.getString("fintype");
            DynamicObject applyPayAcct = info.getDynamicObject("applypayacct");
            String acctClassify = "";
            if (EmptyUtil.isNoEmpty((DynamicObject)applyPayAcct)) {
                acctClassify = applyPayAcct.getString("acctclassify");
            }
            if (genApplyPaybill && !FinTypeEnum.ZIKAI.getValue().equals(finType) && AcctClassifyEnum.INNER_ACCOUNT.getValue().equals(acctClassify) || !EmptyUtil.isNoEmpty((String)(checkTargetBillsMsg = BusinessHelper.checkTargetBills((String)info.getDataEntityType().getName(), (Long)info.getLong("id"), (boolean)true)))) continue;
            this.addErrorMessage(extendedDataEntity, checkTargetBillsMsg);
        }
    }
}

