/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.scf.common.helper;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.scf.common.resource.ScfNewBizResource;

public class BusinessHelper {
    private static Log logger = LogFactory.getLog(BusinessHelper.class);

    public static String checkTargetBills(String entityName, Long billId) {
        return BusinessHelper.checkTargetBills(entityName, billId, false);
    }

    public static String checkTargetBills(String entityName, Long billId, boolean includeAStatus) {
        ScfNewBizResource bizResource = new ScfNewBizResource();
        StringBuilder msg = new StringBuilder();
        Map botpMap = BFTrackerServiceHelper.findTargetBills((String)entityName, (Long[])new Long[]{billId});
        if (botpMap != null && botpMap.size() > 0) {
            for (Map.Entry entry : botpMap.entrySet()) {
                String existBillsMsg = BusinessHelper.findExistBillsMsg((String)entry.getKey(), (HashSet)entry.getValue(), includeAStatus);
                msg.append(existBillsMsg);
            }
        }
        if (msg.length() > 0) {
            msg.insert(0, bizResource.getExistTargetBillError());
        }
        return msg.toString();
    }

    private static String findExistBillsMsg(String targetEntityName, HashSet<Long> targetBillIds, boolean includeAStatus) {
        QFilter filter = new QFilter("id", "in", targetBillIds);
        DynamicObjectCollection tarBills = QueryServiceHelper.query((String)targetEntityName, (String)"billno,id,billstatus", (QFilter[])filter.toArray());
        if (tarBills == null || tarBills.size() <= 0) {
            return "";
        }
        if (includeAStatus && tarBills.stream().allMatch(o -> BillStatusEnum.SAVE.getValue().equals(o.getString("billstatus")))) {
            return "";
        }
        List billnos = tarBills.stream().map(v -> v.getString("billno")).collect(Collectors.toList());
        String targetBillName = EntityMetadataCache.getDataEntityType((String)targetEntityName).getDisplayName().getLocaleValue();
        logger.info("\u76ee\u6807\u5355:" + targetBillName + " billnos:" + billnos);
        return String.format(new ScfNewBizResource().getExistTargetBillDetail(), StringUtils.isBlank((CharSequence)targetBillName) ? targetEntityName : targetBillName, String.join((CharSequence)",", billnos));
    }

    public static Long getCreditTypeByScfTypeId(Long scfTypeId) {
        DynamicObject scfType = TmcDataServiceHelper.loadSingle((Object)scfTypeId, (String)"scf_type", (String)"credittype");
        DynamicObject creditType = scfType.getDynamicObject("credittype");
        if (creditType == null) {
            creditType = TmcDataServiceHelper.loadSingle((String)"cfm_credittype", (String)"iscomprehensive", (QFilter[])new QFilter[]{new QFilter("iscomprehensive", "=", (Object)"1")});
        }
        return (Long)creditType.getPkValue();
    }

    public static void updateApplyBillStatus(DynamicObject[] debtsBills, String needUpdateStatus) {
        Object[] applyIds = Arrays.stream(debtsBills).filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("scfapplybillf7"))).map(o -> o.getDynamicObject("scfapplybillf7").getLong("id")).toArray();
        if (EmptyUtil.isNoEmpty((Object[])applyIds)) {
            DynamicObject[] applybills;
            for (DynamicObject applybill : applybills = TmcDataServiceHelper.load((String)"scf_debtsapplybill", (String)"id,bizstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)applyIds)})) {
                applybill.set("bizstatus", (Object)needUpdateStatus);
            }
            SaveServiceHelper.save((DynamicObject[])applybills);
        }
    }

    public static String pushInnerSettlePayBill(DynamicObject scfRepayBill, String entityName, boolean isPay) {
        OperateOption operateOption = OperateOption.create();
        OperationResult reslut = TmcOperateServiceHelper.execOperate((String)"pushtranshandlebill", (String)entityName, (Object[])new Object[]{scfRepayBill.getPkValue()}, (OperateOption)operateOption);
        List successPkIds = reslut.getSuccessPkIds();
        Object successPkId = successPkIds.get(0);
        DynamicObject transhandlebill = TmcBotpHelper.getTargetBill((String)entityName, successPkId, (String)"ifm_transhandlebill");
        Object[] transhandlebillIds = new Object[]{transhandlebill.getPkValue()};
        OperationResult conmmitfmResult = TmcOperateServiceHelper.execOperate((String)"commitifm", (String)"ifm_transhandlebill", (Object[])transhandlebillIds, (OperateOption)operateOption);
        if (!conmmitfmResult.isSuccess()) {
            TmcOperateServiceHelper.execOperate((String)"unaudit", (String)"ifm_transhandlebill", (Object[])transhandlebillIds, (OperateOption)operateOption);
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"ifm_transhandlebill", (Object[])transhandlebillIds, (OperateOption)operateOption);
            throw new KDBizException(TmcOperateServiceHelper.decodeErrorMsg((OperationResult)conmmitfmResult));
        }
        DynamicObjectCollection transdetails = QueryServiceHelper.query((String)"ifm_transdetail", (String)"debitamount,creditamount,bankcheckflag", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", (Object)transhandlebillIds)});
        String amtFeild = isPay ? "debitamount" : "creditamount";
        for (DynamicObject transdetail : transdetails) {
            if (!EmptyUtil.isNoEmpty((Object)transdetail.get(amtFeild))) continue;
            String bankCheckflag = transdetail.getString("bankcheckflag");
            scfRepayBill.set("bankcheckflag", (Object)bankCheckflag);
            return bankCheckflag;
        }
        return "";
    }

    public static void push2Paybill(String opkey, String entityName, DynamicObject[] info) {
        if (EmptyUtil.isNoEmpty((Object[])info)) {
            String billnos = Arrays.toString(Arrays.stream(info).map(o -> o.getString("billno")).toArray());
            logger.info("\u4e0b\u63a8\u4ed8\u6b3e\u5355\u5f00\u59cb,\u7f16\u53f7\u4e3a-->" + billnos);
            TmcOperateServiceHelper.execOperate((String)opkey, (String)entityName, (DynamicObject[])info, (OperateOption)OperateOption.create(), (boolean)true);
            logger.info("\u4e0b\u63a8\u4ed8\u6b3e\u5355\u7ed3\u675f-->");
        }
    }

    public static void deleteRecOrPayBill(DynamicObject bill) {
        Object[] billIds = new Object[]{bill.getPkValue()};
        String billstatus = bill.getString("billstatus");
        String entityName = bill.getDynamicObjectType().getName();
        boolean isPayed = false;
        if (StringUtils.equals((CharSequence)billstatus, (CharSequence)"D")) {
            TmcOperateServiceHelper.execOperate((String)"cancelpay", (String)entityName, (Object[])billIds, (OperateOption)OperateOption.create(), (boolean)true);
            isPayed = true;
        }
        if (isPayed || StringUtils.equals((CharSequence)billstatus, (CharSequence)"C")) {
            TmcOperateServiceHelper.execOperate((String)"unaudit", (String)entityName, (Object[])billIds, (OperateOption)OperateOption.create(), (boolean)true);
        }
        if (StringUtils.equals((CharSequence)billstatus, (CharSequence)"B")) {
            TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)entityName, (Object[])billIds, (OperateOption)OperateOption.create(), (boolean)true);
        }
        TmcOperateServiceHelper.execOperate((String)"delete", (String)entityName, (Object[])billIds, (OperateOption)OperateOption.create(), (boolean)true);
    }

    public static Set<Long> getCurrencyPks(long acctBankId) {
        return BusinessHelper.getCurrencyPks("bd_accountbanks", Collections.singletonList(acctBankId));
    }

    public static Set<Long> getCurrencyPks(List<Long> acctBankIds) {
        return BusinessHelper.getCurrencyPks("bd_accountbanks", acctBankIds);
    }

    public static Set<Long> getCurrencyPks(String acctEntityName, List<Long> acctIds) {
        QFilter qf = new QFilter("id", "in", acctIds).and("currency.fbasedataid.enable", "=", (Object)Character.valueOf('1'));
        DynamicObjectCollection queryAcctColl = QueryServiceHelper.query((String)acctEntityName, (String)"id,currency.fbasedataid.id,currency.fbasedataid.enable", (QFilter[])qf.toArray(), null);
        HashSet<Long> currencyIdSet = new HashSet<Long>(queryAcctColl.size());
        for (int i = 0; i < queryAcctColl.size(); ++i) {
            DynamicObject acctObj = (DynamicObject)queryAcctColl.get(i);
            currencyIdSet.add(acctObj.getLong("currency.fbasedataid.id"));
        }
        return currencyIdSet;
    }
}

