/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.scf.formplugin.apply;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Objects;
import java.util.Set;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.scf.common.enums.FinTypeEnum;
import kd.tmc.scf.common.helper.BusinessHelper;

public class DebtsApplyBillEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit applypayacct = (BasedataEdit)this.getControl("applypayacct");
        this.addBeforeF7Select(applypayacct);
        BasedataEdit applypaybank = (BasedataEdit)this.getControl("applypaybank");
        this.addBeforeF7Select(applypaybank);
        BasedataEdit funder = (BasedataEdit)this.getControl("funder");
        this.addBeforeF7Select(funder);
        BasedataEdit funderbank = (BasedataEdit)this.getControl("funderbank");
        this.addBeforeF7Select(funderbank);
        BasedataEdit provider = (BasedataEdit)this.getControl("provider");
        this.addBeforeF7Select(provider);
        TextEdit textEdit = (TextEdit)this.getControl("receracct");
        textEdit.addClickListener((ClickListener)this);
        BasedataEdit currency = (BasedataEdit)this.getControl("currency");
        this.addBeforeF7Select(currency);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String prop;
        switch (prop = evt.getProperty().getName()) {
            case "funder": {
                this.funderF7(evt);
                break;
            }
            case "funderbank": {
                this.funderbankF7(evt);
                break;
            }
            case "applypayacct": {
                this.applypayacctF7(evt);
                break;
            }
            case "currency": {
                this.currencyF7(evt);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject currency;
        DynamicObject org = (DynamicObject)this.getModel().getValue("company");
        if (EmptyUtil.isNoEmpty((DynamicObject)org) && EmptyUtil.isNoEmpty((DynamicObject)(currency = TmcBusinessBaseHelper.getCasBaseCurrency((long)((Long)org.getPkValue()))))) {
            this.getModel().setValue("currency", (Object)currency);
        }
        Date startdate = (Date)this.getModel().getValue("startdate");
        this.getModel().setValue("enddate", (Object)DateUtils.getNextYear((Date)startdate, (int)1));
        Date enddate = (Date)this.getModel().getValue("enddate");
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", (Object)DateUtils.getDiff_ymd((Date)startdate, (Date)enddate));
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        switch (key) {
            case "term": {
                if (TermHelper.isRightFormat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)value.toString())) break;
                e.setCancel(true);
                this.getView().updateView(key);
                break;
            }
            case "enddate": {
                if (value == null) {
                    return;
                }
                Date startDate = (Date)this.getModel().getValue("startdate");
                if (startDate == null) {
                    return;
                }
                String fmtStr = ((DateEdit)this.getControl("enddate")).getFormatString();
                Date endDate = DateUtils.stringToDate((String)value.toString(), (String)fmtStr);
                if (!startDate.after(endDate)) break;
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5230\u671f\u65e5\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u65e5", (String)"DebtsApplyBillEdit_1", (String)"tmc-scf-formplugin", (Object[])new Object[0]));
                this.getView().updateView(key);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        Object newVal = e.getChangeSet()[0].getNewValue();
        switch (propName) {
            case "company": {
                this.companyChangeEvt(newVal);
                break;
            }
            case "applypayacct": {
                this.applyPayAcctChangeEvt(newVal);
                break;
            }
            case "funder": {
                this.funderChangeEvt(newVal);
                break;
            }
            case "startdate": {
                this.startDateChangeEvt();
                break;
            }
            case "enddate": {
                this.endDateChangeEvt();
                break;
            }
            case "term": {
                this.termChangeEvt();
            }
        }
    }

    private void companyChangeEvt(Object newVal) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        if (EmptyUtil.isNoEmpty((DynamicObject)company) && EmptyUtil.isNoEmpty((DynamicObject)org) && org.getPkValue() == company.getPkValue()) {
            this.getModel().setValue("fintype", (Object)FinTypeEnum.ZIKAI.getValue());
        } else {
            this.getModel().setValue("fintype", (Object)FinTypeEnum.WEIKAI.getValue());
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"fintype"});
    }

    private void applyPayAcctChangeEvt(Object newVal) {
        if (EmptyUtil.isEmpty((Object)newVal)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"currency"});
            this.getModel().setValue("applypaybank", null);
            return;
        }
        Object id = ((DynamicObject)newVal).getDynamicObject("bank").getPkValue();
        Object currencyId = ((DynamicObject)newVal).getDynamicObject("defaultcurrency").getPkValue();
        Set ids = BusinessHelper.getCurrencyPks((long)((Long)((DynamicObject)newVal).getPkValue()));
        if (ids.size() == 1) {
            this.getModel().setValue("currency", currencyId);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"currency"});
        } else if (ids.size() > 1) {
            DynamicObject curr = (DynamicObject)this.getModel().getValue("currency");
            if (EmptyUtil.isNoEmpty((DynamicObject)curr) && !ids.contains(curr.getPkValue())) {
                this.getModel().setValue("currency", currencyId);
            }
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"currency"});
        }
        this.getModel().setValue("applypaybank", id);
    }

    private void funderChangeEvt(Object newVal) {
        DynamicObject orgObj = (DynamicObject)this.getModel().getValue("org");
        if (EmptyUtil.isEmpty((DynamicObject)orgObj)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u6838\u5fc3\u516c\u53f8\u3002", (String)"DebtsApplyBillEdit_0", (String)"tmc-scf-formplugin", (Object[])new Object[0]));
            return;
        }
        if (EmptyUtil.isEmpty((Object)newVal)) {
            this.getModel().setValue("funderbank", null);
            return;
        }
        DynamicObjectCollection coll = ((DynamicObject)newVal).getDynamicObjectCollection("bankentry");
        DynamicObject provider = ((DynamicObject)newVal).getDynamicObject("scfprovider");
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)coll)) {
            this.getModel().setValue("funderbank", (Object)((DynamicObject)coll.get(0)).getLong("bank.id"));
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)provider)) {
            this.getModel().setValue("provider", provider.getPkValue());
        }
    }

    private void startDateChangeEvt() {
        Date startDate = (Date)this.getModel().getValue("startdate");
        if (startDate == null) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", null);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"enddate", null);
        } else {
            String term = (String)this.getModel().getValue("term");
            if (EmptyUtil.isNoEmpty((String)term)) {
                Date endDate = TermHelper.getDateByBaseDate4ymd((String)term, (Date)startDate);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"enddate", (Object)endDate);
            }
        }
    }

    private void endDateChangeEvt() {
        Date sDate = (Date)this.getModel().getValue("startdate");
        Date eDate = (Date)this.getModel().getValue("enddate");
        if (sDate != null && eDate != null) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", (Object)DateUtils.getDiff_ymd((Date)sDate, (Date)eDate));
        } else {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", null);
        }
    }

    private void termChangeEvt() {
        String termStr = (String)this.getModel().getValue("term");
        if (!TermHelper.isRightFormat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)termStr)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"enddate", null);
        } else {
            Date startDate_tmp = (Date)this.getModel().getValue("startdate");
            if (termStr != null && startDate_tmp != null) {
                Date endDate = TermHelper.getDateByBaseDate4ymd((String)termStr, (Date)startDate_tmp);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"enddate", (Object)endDate);
            }
        }
    }

    private void addBeforeF7Select(BasedataEdit basedataEdit) {
        if (Objects.nonNull(basedataEdit)) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    private void funderF7(BeforeF7SelectEvent evt) {
        DynamicObject orgObj = (DynamicObject)this.getModel().getValue("org");
        if (EmptyUtil.isEmpty((DynamicObject)orgObj)) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u6838\u5fc3\u516c\u53f8\u3002", (String)"DebtsApplyBillEdit_0", (String)"tmc-scf-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter filter = new QFilter("id", "!=", (Object)0);
        filter.and("orgentry.org", "=", null);
        filter.or("orgentry.org", "=", orgObj.getPkValue());
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.getListFilterParameter().getQFilters().add(filter);
    }

    private void funderbankF7(BeforeF7SelectEvent evt) {
        ArrayList<Long> ids = new ArrayList<Long>(10);
        Long id = (Long)this.getModel().getValue("funder_id");
        if (EmptyUtil.isEmpty((Long)id)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u8d44\u91d1\u65b9\u3002", (String)"DebtsApplyBillEdit_3", (String)"tmc-scf-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        DynamicObject funder = BusinessDataServiceHelper.loadSingle((Object)id, (String)"scf_funder");
        DynamicObjectCollection colls = funder.getDynamicObjectCollection("bankentry");
        for (DynamicObject coll : colls) {
            ids.add(coll.getLong("bank.id"));
        }
        if (!CollectionUtils.isEmpty(ids)) {
            QFilter filter = new QFilter("id", "in", ids);
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(filter);
        }
    }

    private void applypayacctF7(BeforeF7SelectEvent evt) {
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        if (EmptyUtil.isEmpty((DynamicObject)company)) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u7533\u8bf7\u516c\u53f8\u3002", (String)"DebtsApplyBillEdit_2", (String)"tmc-scf-formplugin", (Object[])new Object[0]));
            return;
        }
        long orgId = company.getLong("id");
        QFilter qf = TmcAccountHelper.getAccountBankFilterByOrg((Long)orgId).and("acctstatus", "=", (Object)BankAcctStatusEnum.NORMAL.getValue());
        ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
        sp.getListFilterParameter().getQFilters().add(qf);
    }

    private void currencyF7(BeforeF7SelectEvent evt) {
        DynamicObject applypayacct = (DynamicObject)this.getModel().getValue("applypayacct");
        if (EmptyUtil.isNoEmpty((DynamicObject)applypayacct)) {
            Set currencyids = BusinessHelper.getCurrencyPks((long)((Long)applypayacct.getPkValue()));
            QFilter qFilter = new QFilter("id", "in", (Object)currencyids);
            ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
            sp.getListFilterParameter().getQFilters().add(qFilter);
        }
    }
}

