/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.scf.formplugin.common;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.CreditFinTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.common.AbstractCreditLimitEditPlugin;
import kd.tmc.scf.common.helper.BusinessHelper;

public class ScfFinBillCreditLimitPlugin
extends AbstractCreditLimitEditPlugin {
    protected Map<String, String> getBizPropertys() {
        HashMap<String, String> propertys = new HashMap<String, String>();
        propertys.put("org", this.getOrgField());
        propertys.put("finorg", this.getCrditmField());
        propertys.put("amount", "amount");
        propertys.put("startDate", "startdate");
        propertys.put("endDate", "enddate");
        propertys.put("currency", "currency");
        return propertys;
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (this.getCreditlimiFieldMap().containsKey(key)) {
            this.getPageCache().remove("creditmlimitf7_key");
            this.getPageCache().put("creditmlimitf7_key", key);
        }
        super.beforeF7Select(evt);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "funderbank": {
                this.getModel().setValue("creditlimit", null);
                break;
            }
            case "company": {
                this.getModel().setValue("orgcreditlimit", null);
                break;
            }
            case "org": 
            case "scftype": 
            case "amount": 
            case "currency": {
                this.getModel().setValue("creditlimit", null);
                this.getModel().setValue("orgcreditlimit", null);
            }
        }
    }

    protected Long getSourceBillEntryId(String fieldF7, Long id) {
        return "creditlimit".equals(fieldF7) ? 1L : 2L;
    }

    private String getOrgField() {
        String orgFiled = "org";
        if (this.isClickOrgCreditmKey()) {
            orgFiled = "company";
        }
        return orgFiled;
    }

    private String getCrditmField() {
        String orgFiled = "funderbank";
        if (this.isClickOrgCreditmKey()) {
            orgFiled = "org";
        }
        return orgFiled;
    }

    protected Long getCreditTypeId() {
        return BusinessHelper.getCreditTypeByScfTypeId((Long)((Long)this.getFinProduct().getPkValue()));
    }

    protected String creditType() {
        return this.isClickOrgCreditmKey() ? CreditFinTypeEnum.ORG.getValue() : CreditFinTypeEnum.FINORG.getValue();
    }

    private boolean isClickOrgCreditmKey() {
        String creditmLimitF7Key = this.getPageCache().get("creditmlimitf7_key");
        return "orgcreditlimit".equals(creditmLimitF7Key);
    }

    protected String getCreditVariety() {
        DynamicObject finProduct = (DynamicObject)this.getModel().getValue("scftype");
        return finProduct.getString("name");
    }

    protected BigDecimal setCreditRatio() {
        return new BigDecimal("100");
    }

    private DynamicObject getFinProduct() {
        if (this.getModel().getValue("scftype") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f9b\u5e94\u94fe\u878d\u8d44\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ScfFinBillCreditLimitPlugin_0", (String)"tmc-scf-formplugin", (Object[])new Object[0]));
        }
        return (DynamicObject)this.getModel().getValue("scftype");
    }

    public boolean isPreOccupy() {
        return Boolean.FALSE;
    }

    protected BigDecimal getAmount() {
        return (BigDecimal)this.getModel().getValue("amount");
    }

    protected Map<String, String> getCreditlimiFieldMap() {
        HashMap<String, String> fieldMap = new HashMap<String, String>(16);
        fieldMap.put("creditlimit", "");
        fieldMap.put("orgcreditlimit", "");
        return fieldMap;
    }

    protected void setCreditUseFields() {
        DynamicObject creditLimit = (DynamicObject)this.getModel().getValue("creditlimit");
        DynamicObject orgCreditLimit = (DynamicObject)this.getModel().getValue("orgcreditlimit");
        if (EmptyUtil.isNoEmpty((DynamicObject)creditLimit) || EmptyUtil.isNoEmpty((DynamicObject)orgCreditLimit)) {
            Long id = (Long)this.getModel().getValue("id");
            if (EmptyUtil.isEmpty((Long)id)) {
                return;
            }
            QFilter qFilter = new QFilter("sourcebillid", "=", (Object)id);
            Object[] creditUses = TmcDataServiceHelper.load((String)"cfm_credituse", (String)"sourcebillentryid, currency, realamt", (QFilter[])qFilter.toArray());
            if (EmptyUtil.isNoEmpty((Object[])creditUses)) {
                for (Object creditUs : creditUses) {
                    long sourcebillentryid = creditUs.getLong("sourcebillentryid");
                    String creditAmt = sourcebillentryid == 1L ? "creditamt" : "orgcreditamt";
                    String creditCurrency = sourcebillentryid == 1L ? "creditcurrency" : "orgcreditcurrency";
                    TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)creditAmt, (Object)creditUs.getBigDecimal("realamt"));
                    TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)creditCurrency, (Object)creditUs.getDynamicObject("currency"));
                }
            }
        }
    }

    protected String getCreditUseAmtField() {
        return this.isClickOrgCreditmKey() ? "orgcreditamt" : "creditamt";
    }

    protected String getCreditUseCurrencyField() {
        return this.isClickOrgCreditmKey() ? "orgcreditcurrency" : "creditcurrency";
    }
}

