/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.scf.formplugin.common;

import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.OppUnitTypeEnum;
import kd.tmc.fbp.common.helper.ListConstructorHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ScfOpponAcctDealPlugin
extends AbstractBillPlugIn {
    private static final String OPPACCTBANK_CLOSECALLBACK = "oppacctbank_closeCallBack";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit oppAcctbank = (TextEdit)this.getControl("receracct");
        oppAcctbank.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "receracct": {
                this.dealAndShowBankInfo();
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setRecerMustInput((String)this.getModel().getValue("recertype"));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propName) {
            case "recertype": {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"recerf7", null);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"recer", (Object)" ");
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"receracct", (Object)" ");
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"recerbank", null);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"recerbebank", null);
                this.setRecerMustInput((String)newValue);
                break;
            }
            case "recerf7": {
                if (EmptyUtil.isNoEmpty((Object)newValue)) {
                    this.getModel().setValue("recer", (Object)((DynamicObject)newValue).getString("name"));
                }
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"receracct", (Object)" ");
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"recerbank", null);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"recerbebank", null);
                break;
            }
            case "recer": {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"receracct", (Object)" ");
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"recerbank", null);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"recerbebank", null);
                break;
            }
            case "receracct": {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"recerbank", null);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"recerbebank", null);
                break;
            }
            case "recerbank": {
                DynamicObject bebank;
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"recerbebank", null);
                if (!EmptyUtil.isNoEmpty((Object)newValue) || !EmptyUtil.isNoEmpty((DynamicObject)(bebank = ((DynamicObject)newValue).getDynamicObject("bebank")))) break;
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"recerbebank", (Object)bebank.getPkValue());
            }
        }
    }

    private void setRecerMustInput(String recerType) {
        boolean isOther = OppUnitTypeEnum.OTHER.getValue().equals(recerType);
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (!isOther ? 1 : 0) != 0, (String[])new String[]{"recerf7"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isOther, (String[])new String[]{"recer"});
    }

    private void dealAndShowBankInfo() {
        String recerType = (String)this.getModel().getValue("recertype");
        if (OppUnitTypeEnum.FINORGINFO.getValue().equals(recerType) || OppUnitTypeEnum.OTHER.getValue().equals(recerType) || OppUnitTypeEnum.BOSUSER.getValue().equals(recerType)) {
            return;
        }
        DynamicObject recerInfo = (DynamicObject)this.getModel().getValue("recerf7");
        if (EmptyUtil.isEmpty((DynamicObject)recerInfo)) {
            return;
        }
        String recerEntityType = recerInfo.getDataEntityType().getName();
        Object oppUnitId = recerInfo.getPkValue();
        Object innerOrgId = null;
        if (StringUtils.equals((CharSequence)recerEntityType, (CharSequence)"bd_supplier") || StringUtils.equals((CharSequence)recerEntityType, (CharSequence)"bd_customer")) {
            DynamicObject innerOrg = TmcBusinessBaseHelper.getInternalOrg((DynamicObject)recerInfo);
            if (EmptyUtil.isEmpty((DynamicObject)innerOrg)) {
                String qFilter = new QFilter("id", "=", oppUnitId);
                DynamicObject entryBankDO = TmcDataServiceHelper.loadSingle((String)recerEntityType, (String)"entry_bank", (QFilter[])qFilter.toArray());
                if (entryBankDO.getDynamicObjectCollection("entry_bank").size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5bf9\u5e94\u5ba2\u5546\u7684\u94f6\u884c\u4fe1\u606f", (String)"ScfOpponAcctDealPlugin_0", (String)"tmc-scf-formplugin", (Object[])new Object[0]));
                    return;
                }
            } else {
                innerOrgId = innerOrg.getPkValue();
            }
        }
        ListShowParameter lsp = new ListShowParameter();
        switch (recerEntityType) {
            case "bd_supplier": {
                if (EmptyUtil.isNoEmpty((Object)innerOrgId)) {
                    lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((Object)innerOrgId);
                    break;
                }
                lsp = ListConstructorHelper.getSupplierBankInfoShowParameter((Object)oppUnitId);
                break;
            }
            case "bd_customer": {
                if (EmptyUtil.isNoEmpty((Object)innerOrgId)) {
                    lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((Object)innerOrgId);
                    break;
                }
                lsp = ListConstructorHelper.getCustomerBankInfoShowParameter((Object)oppUnitId);
                break;
            }
            case "bos_org": {
                lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((Object)oppUnitId);
                break;
            }
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, OPPACCTBANK_CLOSECALLBACK);
        lsp.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)lsp);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (!EmptyUtil.isEmpty((Object)returnData)) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
            switch (actionId) {
                case "oppacctbank_closeCallBack": {
                    this.oppAcctBankCloseCallBack(selectedRows.get(0));
                }
            }
        }
    }

    private void oppAcctBankCloseCallBack(ListSelectedRow row) {
        DynamicObject recerInfo = (DynamicObject)this.getModel().getValue("recerf7");
        Object entryKey = row.getEntryPrimaryKeyValue();
        String entityName = recerInfo.getDataEntityType().getName();
        DynamicObject innerOrg = null;
        if ("bd_supplier".equals(entityName) || "bd_customer".equals(entityName)) {
            innerOrg = TmcBusinessBaseHelper.getInternalOrg((DynamicObject)recerInfo);
        }
        if ((StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_supplier") || StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_customer")) && EmptyUtil.isEmpty((DynamicObject)innerOrg)) {
            DynamicObject oppUnitDetail = TmcDataServiceHelper.loadSingle((String)recerInfo.getDataEntityType().getName(), (String)"id,bankaccount,bank", (QFilter[])new QFilter[]{new QFilter("entry_bank.id", "=", entryKey)});
            DynamicObjectCollection entryBank = oppUnitDetail.getDynamicObjectCollection("entry_bank");
            for (DynamicObject entry : entryBank) {
                if (!entry.getPkValue().equals(entryKey)) continue;
                this.getModel().setValue("receracct", (Object)entry.getString("bankaccount"));
                DynamicObject bebank = entry.getDynamicObject("bank");
                if (EmptyUtil.isNoEmpty((DynamicObject)bebank)) {
                    Object pkValue = bebank.getPkValue();
                    DynamicObjectCollection bankInfo = QueryServiceHelper.query((String)"bd_finorginfo", (String)"id", (QFilter[])new QFilter[]{new QFilter("bebank", "=", pkValue)});
                    if (EmptyUtil.isNoEmpty((DynamicObjectCollection)bankInfo)) {
                        this.getModel().setValue("recerbank", ((DynamicObject)bankInfo.get(0)).get("id"));
                    }
                    this.getModel().setValue("recerbebank", bebank.getPkValue());
                }
                break;
            }
        } else if ("bos_org".equals(entityName) || EmptyUtil.isNoEmpty((DynamicObject)innerOrg)) {
            DynamicObject accountbanksDO = TmcDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id,bank,number", (QFilter[])new QFilter("id", "=", row.getPrimaryKeyValue()).toArray());
            this.getModel().setValue("receracct", (Object)accountbanksDO.getString("number"));
            DynamicObject bankDO = accountbanksDO.getDynamicObject("bank");
            if (!EmptyUtil.isEmpty((DynamicObject)bankDO)) {
                this.getModel().setValue("recerbank", bankDO.getPkValue());
                DynamicObject bebankDO = bankDO.getDynamicObject("bebank");
                if (!EmptyUtil.isEmpty((DynamicObject)bebankDO)) {
                    this.getModel().setValue("recerbebank", bebankDO.getPkValue());
                }
            }
        }
    }
}

