/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.scf.formplugin.findebts;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.scf.common.helper.BusinessHelper;
import kd.tmc.scf.common.helper.TermChgHeper;

public class FinDebtsBillEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit payacct = (BasedataEdit)this.getControl("payacct");
        payacct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit funder = (BasedataEdit)this.getControl("funder");
        funder.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit funderbank = (BasedataEdit)this.getControl("funderbank");
        funderbank.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit provider = (BasedataEdit)this.getControl("provider");
        provider.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit currency = (BasedataEdit)this.getControl("currency");
        currency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String prop;
        switch (prop = evt.getProperty().getName()) {
            case "funder": {
                this.funderF7(evt);
                break;
            }
            case "funderbank": {
                this.funderbankF7(evt);
                break;
            }
            case "payacct": {
                this.payacctF7(evt);
                break;
            }
            case "currency": {
                this.currencyF7(evt);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject currency;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (EmptyUtil.isNoEmpty((DynamicObject)org) && EmptyUtil.isNoEmpty((DynamicObject)(currency = TmcBusinessBaseHelper.getCasBaseCurrency((long)((Long)org.getPkValue()))))) {
            this.getModel().setValue("currency", (Object)currency);
        }
        Date startdate = (Date)this.getModel().getValue("startdate");
        this.getModel().setValue("enddate", (Object)DateUtils.getNextYear((Date)startdate, (int)1));
        Date enddate = (Date)this.getModel().getValue("enddate");
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", (Object)DateUtils.getDiff_ymd((Date)startdate, (Date)enddate));
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        switch (key) {
            case "term": {
                if (TermHelper.isRightFormat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)value.toString())) break;
                e.setCancel(true);
                this.getView().updateView(key);
                break;
            }
            case "enddate": {
                if (value == null) {
                    return;
                }
                Date startDate = (Date)this.getModel().getValue("startdate");
                if (startDate == null) {
                    return;
                }
                String fmtStr = ((DateEdit)this.getControl("enddate")).getFormatString();
                Date endDate = DateUtils.stringToDate((String)value.toString(), (String)fmtStr);
                if (!startDate.after(endDate)) break;
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5230\u671f\u65e5\u5fc5\u987b\u5927\u4e8e\u5f00\u59cb\u65e5", (String)"FinDebtsBillEdit_0", (String)"tmc-scf-formplugin", (Object[])new Object[0]));
                this.getView().updateView(key);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        Object newVal = e.getChangeSet()[0].getNewValue();
        switch (propName) {
            case "payacct": {
                if (EmptyUtil.isEmpty((Object)newVal)) {
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"currency"});
                    this.getModel().setValue("paybank", null);
                    return;
                }
                Object payacctid = ((DynamicObject)newVal).getDynamicObject("bank").getPkValue();
                Object currencyId = ((DynamicObject)newVal).getDynamicObject("defaultcurrency").getPkValue();
                Set ids = BusinessHelper.getCurrencyPks((long)((Long)((DynamicObject)newVal).getPkValue()));
                if (ids.size() == 1) {
                    this.getModel().setValue("currency", currencyId);
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"currency"});
                } else if (ids.size() > 1) {
                    DynamicObject curr = (DynamicObject)this.getModel().getValue("currency");
                    if (EmptyUtil.isNoEmpty((DynamicObject)curr) && !ids.contains(curr.getPkValue())) {
                        this.getModel().setValue("currency", currencyId);
                    }
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"currency"});
                }
                this.getModel().setValue("paybank", payacctid);
                break;
            }
            case "funder": {
                DynamicObject orgObj = (DynamicObject)this.getModel().getValue("org");
                if (EmptyUtil.isEmpty((DynamicObject)orgObj)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u6838\u5fc3\u516c\u53f8\u3002", (String)"FinDebtsBillEdit_1", (String)"tmc-scf-formplugin", (Object[])new Object[0]));
                }
                if (EmptyUtil.isEmpty((Object)newVal)) {
                    this.getModel().setValue("funderbank", null);
                    return;
                }
                DynamicObjectCollection coll = ((DynamicObject)newVal).getDynamicObjectCollection("bankentry");
                DynamicObject provider = ((DynamicObject)newVal).getDynamicObject("scfprovider");
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)coll) && coll.size() == 1) {
                    this.getModel().setValue("funderbank", (Object)((DynamicObject)coll.get(0)).getLong("bank.id"));
                }
                if (!EmptyUtil.isNoEmpty((DynamicObject)provider)) break;
                this.getModel().setValue("provider", provider.getPkValue());
                break;
            }
            case "startdate": {
                TermChgHeper.startDateChgEvt((IDataModel)this.getModel(), (IFormView)this.getView());
                break;
            }
            case "enddate": {
                TermChgHeper.endDateChgEvt((IDataModel)this.getModel(), (IFormView)this.getView());
                break;
            }
            case "term": {
                TermChgHeper.termChgEvt((IDataModel)this.getModel(), (IFormView)this.getView());
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        if ("beforereturndraft".equals(opKey) && opResult.isSuccess()) {
            this.showBackForm("scf_returndraftinfo");
        } else if ("returndraft".equals(opKey) || "cancelreturndraft".equals(opKey)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
        Object operate = parameter.getCustomParam("operate");
        if (operate == null || operate.equals("copy")) {
            this.getModel().setValue("norepayamt", this.getModel().getValue("amount"));
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        Map data = (Map)e.getReturnData();
        if (null != data && "scf_returndraftinfo".equals(actionId = e.getActionId())) {
            OperateOption option = OperateOption.create();
            Date returnDate = (Date)data.get("returndraftdate");
            if (EmptyUtil.isEmpty((Object)returnDate)) {
                returnDate = DateUtils.getCurrentDate();
            }
            option.setVariableValue("returndraftdate", DateUtils.formatString((Date)returnDate, (String)"yyyy-MM-dd HH:mm:ss"));
            option.setVariableValue("returndraftreason", data.get("returndraftreason").toString());
            this.getView().invokeOperation("returndraft", option);
        }
    }

    private void showBackForm(String entityName) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(entityName);
        showParameter.getOpenStyle().setShowType(ShowType.NonModal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, entityName));
        this.getView().showForm(showParameter);
    }

    private void funderF7(BeforeF7SelectEvent evt) {
        DynamicObject orgObj = (DynamicObject)this.getModel().getValue("org");
        QFilter filter = new QFilter("id", "!=", (Object)0);
        filter.and("orgentry.org", "=", null);
        filter.or("orgentry.org", "=", orgObj.getPkValue());
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.getListFilterParameter().getQFilters().add(filter);
    }

    private void funderbankF7(BeforeF7SelectEvent evt) {
        ArrayList<Long> ids = new ArrayList<Long>(10);
        Long id = (Long)this.getModel().getValue("funder_id");
        if (EmptyUtil.isEmpty((Long)id)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d44\u91d1\u65b9\u3002", (String)"FinDebtsBillEdit_3", (String)"tmc-scf-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        DynamicObject funder = BusinessDataServiceHelper.loadSingle((Object)id, (String)"scf_funder");
        DynamicObjectCollection colls = funder.getDynamicObjectCollection("bankentry");
        for (DynamicObject coll : colls) {
            ids.add(coll.getLong("bank.id"));
        }
        if (!CollectionUtils.isEmpty(ids)) {
            QFilter filter = new QFilter("id", "in", ids);
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(filter);
        }
    }

    private void payacctF7(BeforeF7SelectEvent evt) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        DynamicObject scfapplybillf7 = (DynamicObject)this.getModel().getValue("scfapplybillf7");
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u7533\u8bf7\u516c\u53f8\u3002", (String)"FinDebtsBillEdit_2", (String)"tmc-scf-formplugin", (Object[])new Object[0]));
            return;
        }
        long orgId = org == null ? 0L : Long.parseLong(org.getPkValue().toString());
        QFilter qf = TmcAccountHelper.getAccountBankFilterByOrg((Long)orgId).and("acctstatus", "=", (Object)BankAcctStatusEnum.NORMAL.getValue());
        if (EmptyUtil.isNoEmpty((DynamicObject)scfapplybillf7)) {
            qf.and(new QFilter("currency.fbasedataid.id", "in", currency.getPkValue()));
        }
        ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
        sp.getListFilterParameter().getQFilters().add(qf);
    }

    private void currencyF7(BeforeF7SelectEvent evt) {
        DynamicObject payacct = (DynamicObject)this.getModel().getValue("payacct");
        if (EmptyUtil.isNoEmpty((DynamicObject)payacct)) {
            Set currencyids = BusinessHelper.getCurrencyPks((long)((Long)payacct.getPkValue()));
            QFilter qFilter = new QFilter("id", "in", (Object)currencyids);
            ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
            sp.getListFilterParameter().getQFilters().add(qFilter);
        }
    }
}

