/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.scf.formplugin.findebts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class FinDebtsBillInfoEdit
extends AbstractTmcBillEdit
implements BeforeF7SelectListener {
    private static final String SAVE = "save";
    private static final String SELECT_FIELDS = "id,billno,scftype,org,company,payacct,startdate,enddate,funder,funderbank,provider,recer,protocolno,creditlimit,orgcreditlimit,tradechannel,urgent,loandate";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit funder = (BasedataEdit)this.getControl("funder");
        funder.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit funderbank = (BasedataEdit)this.getControl("funderbank");
        funderbank.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit payacct = (BasedataEdit)this.getControl("payacct");
        payacct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        switch (key) {
            case "enddate": {
                if (value == null) {
                    return;
                }
                Date startDate = (Date)this.getModel().getValue("startdate");
                if (startDate == null) {
                    return;
                }
                String fmtStr = ((DateEdit)this.getControl("enddate")).getFormatString();
                Date endDate = DateUtils.stringToDate((String)value.toString(), (String)fmtStr);
                if (!startDate.after(endDate)) break;
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5230\u671f\u65e5\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u65e5", (String)"DebtsApplyBillEdit_1", (String)"tmc-scf-formplugin", (Object[])new Object[0]));
                this.getView().updateView("entryentity");
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String prop;
        switch (prop = evt.getProperty().getName()) {
            case "funder": {
                this.funderF7(evt);
                break;
            }
            case "funderbank": {
                this.funderbankF7(evt);
                break;
            }
            case "payacct": {
                this.payacctF7(evt);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        switch (propName = e.getProperty().getName()) {
            case "funder": {
                int entryIdx = this.getModel().getEntryCurrentRowIndex("ENTRYENTITY");
                DynamicObject funder = (DynamicObject)this.getModel().getValue("funder", entryIdx);
                DynamicObject orgObj = (DynamicObject)this.getModel().getValue("org");
                if (Objects.isNull(orgObj)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u6838\u5fc3\u516c\u53f8\u3002", (String)"FinDebtsBillInfoEdit_0", (String)"tmc-scf-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (EmptyUtil.isEmpty((DynamicObject)funder)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u8d44\u91d1\u65b9\u3002", (String)"FinDebtsBillInfoEdit_8", (String)"tmc-scf-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection coll = funder.getDynamicObjectCollection("bankentry");
                DynamicObject provider = funder.getDynamicObject("scfprovider");
                if (!EmptyUtil.isEmpty((DynamicObjectCollection)coll) && coll.size() == 1) {
                    this.getModel().setValue("funderbank", (Object)((DynamicObject)coll.get(0)).getLong("bank.id"), entryIdx);
                }
                if (EmptyUtil.isNoEmpty((DynamicObject)provider)) {
                    this.getModel().setValue("provider", provider.getPkValue(), entryIdx);
                }
                this.getModel().setValue("creditlimit", null, entryIdx);
                break;
            }
            case "org": 
            case "scftype": {
                int scftype_idx = this.getModel().getEntryCurrentRowIndex("ENTRYENTITY");
                this.getModel().setValue("creditlimit", null, scftype_idx);
                this.getModel().setValue("orgcreditlimit", null, scftype_idx);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List ids = (List)customParams.get("ids");
        if (EmptyUtil.isNoEmpty((Object)ids)) {
            DynamicObject[] payBills = TmcDataServiceHelper.load((String)"scf_findebtsbill", (String)SELECT_FIELDS, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
            this.batchCreateEntry(payBills);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (SAVE.equals(operateKey)) {
            this.infoSave();
        }
    }

    private void batchCreateEntry(DynamicObject[] bills) {
        if (EmptyUtil.isEmpty((Object[])bills)) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("id", new Object[0]);
        vs.addField("billno", new Object[0]);
        vs.addField("scftype", new Object[0]);
        vs.addField("org", new Object[0]);
        vs.addField("company", new Object[0]);
        vs.addField("payacct", new Object[0]);
        vs.addField("startdate", new Object[0]);
        vs.addField("enddate", new Object[0]);
        vs.addField("funder", new Object[0]);
        vs.addField("funderbank", new Object[0]);
        vs.addField("provider", new Object[0]);
        vs.addField("recer", new Object[0]);
        vs.addField("protocolno", new Object[0]);
        vs.addField("creditlimit", new Object[0]);
        vs.addField("orgcreditlimit", new Object[0]);
        vs.addField("tradechannel", new Object[0]);
        vs.addField("urgent", new Object[0]);
        vs.addField("loandate", new Object[0]);
        for (DynamicObject bill : bills) {
            Object[] rowData = new Object[]{bill.getLong("id"), bill.getString("billno"), this.getDynamicObjId(bill, "scftype"), this.getDynamicObjId(bill, "org"), this.getDynamicObjId(bill, "company"), this.getDynamicObjId(bill, "payacct"), bill.getDate("startdate"), bill.getDate("enddate"), this.getDynamicObjId(bill, "funder"), this.getDynamicObjId(bill, "funderbank"), this.getDynamicObjId(bill, "provider"), bill.getString("recer"), bill.getString("protocolno"), this.getDynamicObjId(bill, "creditlimit"), this.getDynamicObjId(bill, "orgcreditlimit"), bill.getString("tradechannel"), bill.getBoolean("urgent"), bill.getDate("loandate")};
            vs.addRow(rowData);
        }
        model.batchCreateNewEntryRow("ENTRYENTITY", vs);
        model.endInit();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(1);
        map.put("heightLimit", false);
        this.getView().updateControlMetadata("ENTRYENTITY", map);
        this.getView().updateView("ENTRYENTITY");
    }

    private Object getDynamicObjId(DynamicObject payBill, String prop) {
        DynamicObject value = payBill.getDynamicObject(prop);
        return EmptyUtil.isNoEmpty((DynamicObject)value) ? value.getPkValue() : Long.valueOf(0L);
    }

    private void funderF7(BeforeF7SelectEvent evt) {
        DynamicObject orgObj = (DynamicObject)this.getModel().getValue("org");
        if (EmptyUtil.isEmpty((DynamicObject)orgObj)) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u6838\u5fc3\u516c\u53f8\u3002", (String)"FinDebtsBillInfoEdit_0", (String)"tmc-scf-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter filter = new QFilter("id", "!=", (Object)0);
        filter.and("orgentry.org", "=", null);
        filter.or("orgentry.org", "=", orgObj.getPkValue());
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.getListFilterParameter().getQFilters().add(filter);
    }

    private void funderbankF7(BeforeF7SelectEvent evt) {
        ArrayList<Long> ids = new ArrayList<Long>(10);
        Long id = (Long)this.getModel().getValue("funder_id");
        DynamicObject funder = BusinessDataServiceHelper.loadSingle((Object)id, (String)"scf_funder");
        DynamicObjectCollection colls = funder.getDynamicObjectCollection("bankentry");
        for (DynamicObject coll : colls) {
            ids.add(coll.getLong("bank.id"));
        }
        if (!CollectionUtils.isEmpty(ids)) {
            QFilter filter = new QFilter("id", "in", ids);
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(filter);
        }
    }

    private void infoSave() {
        String msg = this.checkMsg();
        if (EmptyUtil.isNoEmpty((String)msg)) {
            this.getView().showTipNotification(msg);
            return;
        }
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("ENTRYENTITY");
        Object[] billIds = entrys.stream().map(o -> o.get("id")).toArray();
        DynamicObject[] bills = TmcDataServiceHelper.load((Object[])billIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"scf_findebtsbill"));
        this.updateBill(bills, entrys);
        OperationResult result = TmcOperateServiceHelper.execOperate((String)SAVE, (String)"scf_findebtsbill", (DynamicObject[])bills, (OperateOption)OperateOption.create());
        if (result.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"FinDebtsBillInfoEdit_1", (String)"tmc-scf-formplugin", (Object[])new Object[0]));
        }
    }

    private String checkMsg() {
        int entryRowCount = this.getModel().getEntryRowCount("ENTRYENTITY");
        if (entryRowCount == 0) {
            return ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u3002", (String)"FinDebtsBillInfoEdit_2", (String)"tmc-scf-formplugin", (Object[])new Object[0]);
        }
        StringBuilder checkMsg = new StringBuilder();
        for (int i = 0; i < entryRowCount; ++i) {
            StringBuilder checkEntry = new StringBuilder();
            DynamicObject rowEntity = this.getModel().getEntryRowEntity("ENTRYENTITY", i);
            String scftype = rowEntity.getString("scftype");
            Long org = (Long)rowEntity.get("org.id");
            Long payacct = (Long)rowEntity.get("payacct.id");
            Date startdate = rowEntity.getDate("startdate");
            Date enddate = rowEntity.getDate("enddate");
            if (EmptyUtil.isEmpty((String)scftype)) {
                checkEntry.append(ResManager.loadKDString((String)"\u4f9b\u5e94\u94fe\u878d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"FinDebtsBillInfoEdit_3", (String)"tmc-scf-formplugin", (Object[])new Object[0])).append(",");
            }
            if (EmptyUtil.isEmpty((Long)org)) {
                checkEntry.append(ResManager.loadKDString((String)"\u6838\u5fc3\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a", (String)"FinDebtsBillInfoEdit_4", (String)"tmc-scf-formplugin", (Object[])new Object[0])).append(",");
            }
            if (EmptyUtil.isEmpty((Long)payacct)) {
                checkEntry.append(ResManager.loadKDString((String)"\u6838\u5fc3\u516c\u53f8\u4ed8\u6b3e\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a", (String)"FinDebtsBillInfoEdit_5", (String)"tmc-scf-formplugin", (Object[])new Object[0])).append(",");
            }
            if (startdate.getTime() >= enddate.getTime()) {
                checkEntry.append(ResManager.loadKDString((String)"\u5230\u671f\u65e5\u5fc5\u987b\u5927\u4e8e\u5f00\u59cb\u65e5", (String)"FinDebtsBillInfoEdit_6", (String)"tmc-scf-formplugin", (Object[])new Object[0])).append(",");
            }
            if (!EmptyUtil.isNoEmpty((String)checkEntry.toString())) continue;
            checkMsg.append(ResManager.loadKDString((String)"\u7b2c%s\u884c", (String)"FinDebtsBillInfoEdit_7", (String)"tmc-scf-formplugin", (Object[])new Object[]{i + 1})).append(checkEntry.substring(0, checkEntry.length() - 1)).append("\n");
        }
        return checkMsg.toString();
    }

    private void updateBill(DynamicObject[] bills, DynamicObjectCollection entrys) {
        HashMap billMap = Arrays.stream(bills).collect(HashMap::new, (k, v) -> k.put(v.getLong("id"), v), HashMap::putAll);
        for (DynamicObject entry : entrys) {
            DynamicObject bill = (DynamicObject)billMap.get(entry.getLong("id"));
            bill.set("scftype", (Object)entry.getDynamicObject("scftype"));
            bill.set("org", (Object)entry.getDynamicObject("org"));
            bill.set("company", (Object)entry.getDynamicObject("company"));
            bill.set("payacct", (Object)entry.getDynamicObject("payacct"));
            bill.set("startdate", (Object)entry.getDate("startdate"));
            bill.set("enddate", (Object)entry.getDate("enddate"));
            bill.set("funder", (Object)entry.getDynamicObject("funder"));
            bill.set("funderbank", (Object)entry.getDynamicObject("funderbank"));
            bill.set("provider", (Object)entry.getDynamicObject("provider"));
            bill.set("recer", (Object)entry.getString("recer"));
            bill.set("protocolno", (Object)entry.getString("protocolno"));
            bill.set("creditlimit", (Object)entry.getDynamicObject("creditlimit"));
            bill.set("orgcreditlimit", (Object)entry.getDynamicObject("orgcreditlimit"));
            bill.set("tradechannel", (Object)entry.getString("tradechannel"));
            bill.set("urgent", (Object)entry.getBoolean("urgent"));
            bill.set("loandate", (Object)entry.getDate("loandate"));
            String term = DateUtils.getDiff_ymd((Date)entry.getDate("startdate"), (Date)entry.getDate("enddate"));
            bill.set("term", (Object)term);
        }
    }

    private void payacctF7(BeforeF7SelectEvent evt) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u7533\u8bf7\u516c\u53f8\u3002", (String)"FinDebtsBillEdit_2", (String)"tmc-scf-formplugin", (Object[])new Object[0]));
            return;
        }
        long orgId = org == null ? 0L : Long.parseLong(org.getPkValue().toString());
        QFilter qf = TmcAccountHelper.getAccountBankFilterByOrg((Long)orgId).and("acctstatus", "=", (Object)BankAcctStatusEnum.NORMAL.getValue());
        ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
        sp.getListFilterParameter().getQFilters().add(qf);
    }
}

