/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.scf.formplugin.findebts;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;

public class FinDebtsBillList
extends AbstractTmcListPlugin {
    public void filterContainerInit(FilterContainerInitArgs args) {
        String isquerydefault;
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilter.getFieldName();
            if (!fieldName.startsWith("org.")) continue;
            commonFilter.setDefaultValue("");
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        CommonFilterColumn bizDateFilterCol = filterColumnList.stream().filter(filterCol -> StringUtils.equals((CharSequence)filterCol.getFieldName(), (CharSequence)"startdate")).findFirst().orElse(null);
        if (bizDateFilterCol != null && null != (isquerydefault = (String)formShowParameter.getCustomParam("isquerydefault")) && isquerydefault.equals("no")) {
            bizDateFilterCol.setDefaultValue("");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        if ("dobeforeback".equals(opKey) && opResult.isSuccess()) {
            this.showBackForm("scf_backreason");
        } else if ("beforereturndraft".equals(opKey) && opResult.isSuccess()) {
            this.showBackForm("scf_returndraftinfo");
        }
        List<String> refreshOps = Arrays.asList("confirm", "cancelconfirm", "repay", "cancelrepay", "cancelreturndraft", "returndraft");
        if (refreshOps.contains(opKey)) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refresh();
        } else if ("back".equals(opKey)) {
            this.getView().invokeOperation("refresh");
        }
        if ("updateinfo".equals(args.getOperateKey()) && opResult.isSuccess()) {
            QFilter qf = new QFilter("id", "in", (Object)this.getSelectedIdList());
            qf.and("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue());
            DynamicObjectCollection dys = QueryServiceHelper.query((String)"scf_findebtsbill", (String)"id", (QFilter[])qf.toArray());
            List ids = dys.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setAppId("scf");
            parameter.setFormId("scf_findebtsbillinfo");
            parameter.setCustomParam("ids", ids);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "scf_findebtsbillinfo"));
            this.getView().showForm(parameter);
        }
    }

    private void showBackForm(String entityName) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(entityName);
        showParameter.getOpenStyle().setShowType(ShowType.NonModal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, entityName));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Map data = (Map)e.getReturnData();
        if (null != data) {
            String actionId = e.getActionId();
            if ("scf_backreason".equals(actionId)) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("backreason", data.get("reason").toString());
                this.getView().invokeOperation("back", option);
            } else if ("scf_returndraftinfo".equals(actionId)) {
                OperateOption option = OperateOption.create();
                Date returnDate = (Date)data.get("returndraftdate");
                if (EmptyUtil.isEmpty((Object)returnDate)) {
                    returnDate = DateUtils.getCurrentDate();
                }
                option.setVariableValue("returndraftdate", DateUtils.formatString((Date)returnDate, (String)"yyyy-MM-dd HH:mm:ss"));
                option.setVariableValue("returndraftreason", data.get("returndraftreason").toString());
                this.getView().invokeOperation("returndraft", option);
            } else if ("scf_findebtsbillinfo".equals(e.getActionId())) {
                BillList list = (BillList)this.getControl("billlistap");
                list.refreshData();
            }
        }
    }
}

