/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.scf.formplugin.finrec;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.scf.common.helper.TermChgHeper;

public class FinrecBillEdit
extends AbstractTmcBillEdit
implements BeforeF7SelectListener {
    private static final String sep = ".";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit funderF7 = (BasedataEdit)this.getControl("funder");
        funderF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit funderBankF7 = (BasedataEdit)this.getControl("funderbank");
        funderBankF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("org", null);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "bar_fincreditdraw": {
                this.fincreditChgEvt();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName;
        super.propertyChanged(args);
        switch (propName = args.getProperty().getName()) {
            case "term": {
                TermChgHeper.termChgEvt((IDataModel)this.getModel(), (IFormView)this.getView());
                break;
            }
            case "startdate": {
                TermChgHeper.startDateChgEvt((IDataModel)this.getModel(), (IFormView)this.getView());
                break;
            }
            case "enddate": {
                TermChgHeper.endDateChgEvt((IDataModel)this.getModel(), (IFormView)this.getView());
                break;
            }
            case "fincreditbillf7": {
                this.fincreditChgEvt();
                break;
            }
            case "ac_accountname": {
                this.applyacctChgEvt();
                break;
            }
            case "funder": {
                this.funderChgEvt();
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent bfe) {
        String key;
        switch (key = bfe.getProperty().getName()) {
            case "funder": {
                this.funderF7Evt(bfe);
                break;
            }
            case "funderbank": {
                this.funderBankF7Evt(bfe);
                break;
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        switch (key) {
            case "term": {
                if (TermHelper.isRightFormat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)value.toString())) break;
                e.setCancel(true);
                this.getView().updateView(key);
                break;
            }
            case "enddate": {
                if (value == null) {
                    return;
                }
                Date startDate = (Date)this.getModel().getValue("startdate");
                if (startDate == null) {
                    return;
                }
                String fmtStr = ((DateEdit)this.getControl("enddate")).getFormatString();
                Date endDate = DateUtils.stringToDate((String)value.toString(), (String)fmtStr);
                if (!startDate.after(endDate)) break;
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u65e5\u671f", (String)"FinrecBillEdit_1", (String)"tmc-scf-formplugin", (Object[])new Object[0]));
                this.getView().updateView(key);
                break;
            }
        }
    }

    private void fincreditChgEvt() {
        DynamicObject fincredit = (DynamicObject)this.getModel().getValue("fincreditbillf7");
        if (EmptyUtil.isEmpty((DynamicObject)fincredit)) {
            this.copyPropertys().stream().forEach(item -> this.getView().setEnable(Boolean.TRUE, new String[]{item.toString()}));
            return;
        }
        DataEntityPropertyCollection propertys = fincredit.getDataEntityType().getProperties();
        DataEntityPropertyCollection props = this.getModel().getDataEntityType().getProperties();
        for (IDataEntityProperty prop : propertys) {
            if (!this.copyPropertys().contains(prop.getName()) || !props.containsKey((Object)prop.getName())) continue;
            this.getModel().setValue(prop.getName(), fincredit.get(prop.getName()));
        }
        this.getModel().setValue("recdate", (Object)fincredit.getDate("recdate"));
        TmcViewInputHelper.registerDisableStatus((IFormView)this.getView(), (String[])new String[]{"financetype", "org", "financenature", "funder", "funderbank", "provider", "amount", "startdate", "enddate", "term", "currency", "protocol"});
    }

    protected List copyPropertys() {
        return Arrays.asList("financetype", "org", "financenature", "funder", "funderbank", "provider", "amount", "startdate", "enddate", "term", "currency", "protocol");
    }

    private void applyacctChgEvt() {
        DynamicObject applyacct = (DynamicObject)this.getModel().getValue("ac_accountname");
        if (applyacct == null) {
            this.getModel().setValue("applybank", null);
            return;
        }
        this.getModel().setValue("applybank", applyacct.get("bank"));
    }

    private void funderChgEvt() {
        DynamicObject funder = (DynamicObject)this.getModel().getValue("funder");
        if (funder == null) {
            this.getModel().setValue("funderbank", null);
            this.getModel().setValue("provider", null);
            return;
        }
        if (funder.getDynamicObjectCollection("bankentry").size() == 1) {
            this.getModel().setValue("funderbank", ((DynamicObject)funder.getDynamicObjectCollection("bankentry").get(0)).getPkValue());
        }
        this.getModel().setValue("provider", funder.get("scfprovider"));
    }

    private void funderF7Evt(BeforeF7SelectEvent evt) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (EmptyUtil.isNoEmpty((DynamicObject)org)) {
            ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
            QFilter qf = new QFilter("orgentry.org", "is null", (Object)"");
            qf.or(new QFilter("orgentry.org.id", "=", org.getPkValue()));
            sp.getListFilterParameter().setQFilters(Arrays.asList(qf.recombine()));
        } else {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u7533\u8bf7\u516c\u53f8\u3002", (String)"FinrecBillEdit_0", (String)"tmc-scf-formplugin", (Object[])new Object[0]));
        }
    }

    private void funderBankF7Evt(BeforeF7SelectEvent evt) {
        DynamicObject funder = (DynamicObject)this.getModel().getValue("funder");
        if (funder == null) {
            return;
        }
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        if (funder.getDynamicObjectCollection("bankentry").size() > 1) {
            ArrayList ids = new ArrayList();
            funder.getDynamicObjectCollection("bankentry").stream().forEach(dyo -> ids.add(dyo.getDynamicObject("bank").getPkValue()));
            QFilter qFilter = new QFilter("id", "in", ids);
            showParameter.getListFilterParameter().setQFilters(Arrays.asList(qFilter.recombine()));
        } else if (funder.getDynamicObjectCollection("bankentry").size() == 0) {
            QFilter qFilter = new QFilter("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue());
            showParameter.getListFilterParameter().setQFilters(Arrays.asList(qFilter.recombine()));
        }
    }

    private void setDefCCY() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        Long orgId = (Long)org.getPkValue();
        DynamicObject currency = TmcBusinessBaseHelper.getCasBaseCurrency((long)orgId);
        if (currency != null) {
            this.getModel().setValue("currency", (Object)currency);
        }
    }
}

