/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.scf.formplugin.finrepay;

import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinRepayBillEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("org", null);
    }

    public void registerListener(EventObject e) {
        BasedataEdit applypayacct = (BasedataEdit)this.getControl("applypayacct");
        applypayacct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit payAcct = (BasedataEdit)this.getControl("payacct");
        payAcct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String prop;
        switch (prop = evt.getProperty().getName()) {
            case "applypayacct": {
                this.applyPayAcctF7(evt);
                break;
            }
            case "payacct": {
                this.payAcctF7(evt);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        Object newVal = e.getChangeSet()[0].getNewValue();
        switch (propName) {
            case "payacct": {
                if (EmptyUtil.isEmpty((Object)newVal)) {
                    this.getModel().setValue("paybank", null);
                    return;
                }
                this.getModel().setValue("paybank", ((DynamicObject)newVal).getDynamicObject("bank").getPkValue());
                break;
            }
            case "applypayacct": {
                if (EmptyUtil.isEmpty((Object)newVal)) {
                    this.getModel().setValue("applypaybank", null);
                    return;
                }
                this.getModel().setValue("applypaybank", ((DynamicObject)newVal).getDynamicObject("bank").getPkValue());
                break;
            }
            case "genapplypaybill": {
                this.setApplyMustInput((Boolean)newVal);
            }
        }
    }

    private void setApplyMustInput(boolean isApplyPush2Paybill) {
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isApplyPush2Paybill, (String[])new String[]{"applypayacct"});
    }

    private void applyPayAcctF7(BeforeF7SelectEvent evt) {
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (EmptyUtil.isEmpty((DynamicObject)company)) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u7533\u8bf7\u516c\u53f8\u3002", (String)"FinRepayBillEdit_0", (String)"tmc-scf-formplugin", (Object[])new Object[0]));
            return;
        }
        long orgId = company == null ? 0L : Long.parseLong(company.getPkValue().toString());
        QFilter qf = TmcAccountHelper.getAccountBankFilterByOrg((Long)orgId).and("acctstatus", "=", (Object)BankAcctStatusEnum.NORMAL.getValue()).and(new QFilter("currency.fbasedataid.id", "in", currency.getPkValue()));
        ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
        sp.getCustomParams().put("isclearcorefilter", "true");
        sp.getListFilterParameter().getQFilters().add(qf);
    }

    private void payAcctF7(BeforeF7SelectEvent evt) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u6838\u5fc3\u516c\u53f8(\u5b9e\u9645\u4ed8\u6b3e\u516c\u53f8)\u3002", (String)"FinRepayBillEdit_1", (String)"tmc-scf-formplugin", (Object[])new Object[0]));
            return;
        }
        long orgId = org == null ? 0L : Long.parseLong(org.getPkValue().toString());
        QFilter qf = TmcAccountHelper.getAccountBankFilterByOrg((Long)orgId).and("acctstatus", "=", (Object)BankAcctStatusEnum.NORMAL.getValue()).and(new QFilter("currency.fbasedataid.id", "in", currency.getPkValue()));
        ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
        sp.getListFilterParameter().getQFilters().add(qf);
    }
}

