/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.scf.report.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;

public class FincreditDetailDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final String SELECT_FIELDS = "id,org.name orgtext,org.id org,scftype.name scftype,financenature,billno,funder.id as funderid,funder.name funder,currency.id currency,amount,recdate,protocol,funderbank.name funderbank,provider.name provider,startdate,enddate";
    private static final String FEEAMOUNT = "feeamount";
    private static final String SRCBILLID = "entry.srcbillid";

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        this.getQueryParam().getCustomParam().put("filter_statdim", paramMap.get("filter_statdim"));
        paramMap.putAll(queryParam.getCustomParam());
        QFilter[] qFilters = FincreditDetailDataListPlugin.buildFilter(paramMap, this.getQueryOrgIds(queryParam));
        List finDebtsbillIds = QueryServiceHelper.queryPrimaryKeys((String)"scf_fincreditbill", (QFilter[])qFilters, (String)"", (int)-1);
        if (EmptyUtil.isEmpty((Collection)finDebtsbillIds)) {
            return this.createEmptySet();
        }
        DataSet finDebtsbillResult = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"scf_fincreditbill", (String)SELECT_FIELDS, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)finDebtsbillIds)}, null);
        String customRes = ResManager.loadKDString((String)"\u5ba2\u6237\u65b9\u8ffd\u7d22\u6743", (String)"FincreditDetailDataListPlugin_0", (String)"tmc-scf-report", (Object[])new Object[0]);
        String applyRes = ResManager.loadKDString((String)"\u7533\u8bf7\u65b9\u8ffd\u7d22\u6743", (String)"FincreditDetailDataListPlugin_1", (String)"tmc-scf-report", (Object[])new Object[0]);
        String nonRes = ResManager.loadKDString((String)"\u65e0\u8ffd\u7d22\u6743", (String)"FincreditDetailDataListPlugin_2", (String)"tmc-scf-report", (Object[])new Object[0]);
        finDebtsbillResult = finDebtsbillResult.updateField("financenature", "case when financenature = 'custom-recourse' then '" + customRes + "' when financenature = 'apply-recourse' then '" + applyRes + "' else '" + nonRes + "' end");
        QFilter feeIdFilter = new QFilter(SRCBILLID, "in", (Object)finDebtsbillIds);
        feeIdFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        DataSet feeBillResult = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cfm_feebill", (String)"entry.srcbillid,entry.feedetailamt,entry.excrate", (QFilter[])new QFilter[]{feeIdFilter}, null);
        feeBillResult = feeBillResult.updateField("entry.feedetailamt", "case when entry.feedetailamt > 0.0 and entry.excrate > 0.0 then entry.feedetailamt * entry.excrate else entry.feedetailamt end");
        DataSet feeBillResultSum = feeBillResult.groupBy(new String[]{SRCBILLID}).sum("entry.feedetailamt", FEEAMOUNT).finish();
        return finDebtsbillResult.leftJoin(feeBillResultSum).on("id", SRCBILLID).select(finDebtsbillResult.getRowMeta().getFieldNames(), new String[]{FEEAMOUNT}).finish();
    }

    public static QFilter[] buildFilter(Map<String, Object> paramMap, List<Long> orgIds) {
        DynamicObjectCollection scftype;
        DynamicObjectCollection scffunder;
        Date enddate;
        ArrayList<QFilter> qfiters = new ArrayList<QFilter>(8);
        qfiters.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        qfiters.add(new QFilter("org", "in", orgIds));
        Date startdate = (Date)paramMap.get("filter_startdate");
        if (EmptyUtil.isNoEmpty((Object)startdate)) {
            qfiters.add(new QFilter("recdate", ">=", (Object)startdate));
        }
        if (EmptyUtil.isNoEmpty((Object)(enddate = (Date)paramMap.get("filter_enddate")))) {
            qfiters.add(new QFilter("recdate", "<=", (Object)DateUtils.getDataFormat((Date)enddate, (boolean)false)));
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(scffunder = (DynamicObjectCollection)paramMap.get("filter_funder")))) {
            qfiters.add(new QFilter("funder", "in", (Object)scffunder.stream().map(DataEntityBase::getPkValue).toArray()));
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(scftype = (DynamicObjectCollection)paramMap.get("filter_scftype")))) {
            qfiters.add(new QFilter("scftype", "in", (Object)scftype.stream().map(DataEntityBase::getPkValue).toArray()));
        }
        String bizstatus = (String)paramMap.get("filter_bizstatus");
        qfiters.add(new QFilter("bizstatus", "in", (Object)bizstatus.replaceAll(",", " ").trim().split(" ")));
        return qfiters.toArray(new QFilter[0]);
    }

    private DataSet createEmptySet() {
        return Algo.create((String)"EmptyDataSet").createDataSetBuilder(new RowMeta(new String[]{"empty"}, new DataType[]{DataType.StringType})).build();
    }

    private List<String> getStatDim() {
        String columnStr;
        String statdim;
        switch (statdim = (String)this.getQueryParam().getCustomParam().get("filter_statdim")) {
            case "scf_funder": {
                columnStr = "funder";
                break;
            }
            case "scf_type": {
                columnStr = "scftype";
                break;
            }
            default: {
                columnStr = "orgtext";
            }
        }
        return Arrays.stream(columnStr.split(",")).collect(Collectors.toList());
    }

    protected List<String> orinalAmountField() {
        ArrayList<String> amountFields = new ArrayList<String>(4);
        amountFields.add("amount");
        amountFields.add(FEEAMOUNT);
        return amountFields;
    }

    public List<String> sumAmountFields() {
        ArrayList<String> sumFields = new ArrayList<String>(4);
        sumFields.add("amount_statccy");
        sumFields.add("feeamount_statccy");
        return sumFields;
    }

    public List<String> groupFields() {
        return this.getStatDim();
    }

    protected String getReportField(String field) {
        return field + "_statccy";
    }
}

