/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.scf.report.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;

public class FindebtsDetailDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final String SELECT_FIELDS = "id," + "org.name orgtext," + "org.id org," + "scftype.name scftype," + "billno," + "funder.id as funderid," + "funder.name funder," + "fintype," + "currency.id currency," + "amount," + "loandate," + "recer," + "protocolno," + "startdate," + "enddate," + "funderbank.name funderbank," + "provider.name provider," + "contractnum," + "contractname," + "contractamount," + "draftno," + "draftamount," + "transfer," + "autopay," + "tradechannel";
    private static final String SRCBILLID = "entry.srcbillid";
    private static final String BILLSTATUS = "billstatus";
    private static final String REPAYAMOUNT = "yetrepayamt";
    private static final String TOTALFEEAMOUNT = "totalfeeamount";

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        this.getQueryParam().getCustomParam().put("filter_statdim", paramMap.get("filter_statdim"));
        paramMap.putAll(queryParam.getCustomParam());
        QFilter[] qFilters = FindebtsDetailDataListPlugin.buildFilter(paramMap, this.getQueryOrgIds(queryParam));
        List finDebtsbillIds = QueryServiceHelper.queryPrimaryKeys((String)"scf_findebtsbill", (QFilter[])qFilters, (String)"", (int)-1);
        if (EmptyUtil.isEmpty((Collection)finDebtsbillIds)) {
            return this.createEmptySet();
        }
        DataSet finDebtsbillResult = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"scf_findebtsbill", (String)SELECT_FIELDS, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)finDebtsbillIds)}, null);
        finDebtsbillResult = this.adjustRepayAmt(finDebtsbillResult, finDebtsbillIds, (Date)paramMap.get("filter_deadline"));
        QFilter feeIdFilter = new QFilter(SRCBILLID, "in", (Object)finDebtsbillIds);
        feeIdFilter.and(BILLSTATUS, "=", (Object)BillStatusEnum.AUDIT.getValue());
        DataSet feeBillResult = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cfm_feebill", (String)"entry.srcbillid,entry.feedetailamt,entry.excrate", (QFilter[])new QFilter[]{feeIdFilter}, null);
        feeBillResult = feeBillResult.updateField("entry.feedetailamt", "case when entry.feedetailamt > 0.0 and entry.excrate > 0.0 then entry.feedetailamt * entry.excrate else entry.feedetailamt end");
        DataSet feeBillResultSum = feeBillResult.groupBy(new String[]{SRCBILLID}).sum("entry.feedetailamt", TOTALFEEAMOUNT).finish();
        String expr = String.format("case when fintype='1' then '%s' when fintype='2' then '%s' else '%s' end", ResManager.loadKDString((String)"\u81ea\u5f00", (String)"FindebtsDetailDataListPlugin_1", (String)"tmc-scf-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4ee3\u5f00", (String)"FindebtsDetailDataListPlugin_2", (String)"tmc-scf-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u59d4\u5f00", (String)"FindebtsDetailDataListPlugin_3", (String)"tmc-scf-report", (Object[])new Object[0]));
        finDebtsbillResult = finDebtsbillResult.updateField("fintype", expr);
        return finDebtsbillResult.leftJoin(feeBillResultSum).on("id", SRCBILLID).select(finDebtsbillResult.getRowMeta().getFieldNames(), new String[]{TOTALFEEAMOUNT}).finish();
    }

    public static QFilter[] buildFilter(Map<String, Object> paramMap, List<Long> orgIds) {
        DynamicObjectCollection filterScfType;
        DynamicObjectCollection filterScfFunder;
        Date filterEndDate;
        ArrayList<QFilter> qfiters = new ArrayList<QFilter>(8);
        qfiters.add(new QFilter(BILLSTATUS, "=", (Object)BillStatusEnum.AUDIT.getValue()));
        qfiters.add(new QFilter("org", "in", orgIds));
        Date filterStartDate = (Date)paramMap.get("filter_startdate");
        if (EmptyUtil.isNoEmpty((Object)filterStartDate)) {
            qfiters.add(new QFilter("enddate", ">=", (Object)filterStartDate));
        }
        if (EmptyUtil.isNoEmpty((Object)(filterEndDate = (Date)paramMap.get("filter_enddate")))) {
            qfiters.add(new QFilter("enddate", "<=", (Object)DateUtils.getDataFormat((Date)filterEndDate, (boolean)false)));
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(filterScfFunder = (DynamicObjectCollection)paramMap.get("filter_scffunder")))) {
            qfiters.add(new QFilter("funder", "in", (Object)filterScfFunder.stream().map(DataEntityBase::getPkValue).toArray()));
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(filterScfType = (DynamicObjectCollection)paramMap.get("filter_scftype")))) {
            qfiters.add(new QFilter("scftype", "in", (Object)filterScfType.stream().map(DataEntityBase::getPkValue).toArray()));
        }
        String filterBizStatus = (String)paramMap.get("filter_bizstatus");
        String[] bizstatus = filterBizStatus.substring(1, filterBizStatus.length() - 1).split(",");
        qfiters.add(new QFilter("bizstatus", "in", (Object)bizstatus));
        return qfiters.toArray(new QFilter[0]);
    }

    private DataSet createEmptySet() {
        return Algo.create((String)"EmptyDataSet").createDataSetBuilder(new RowMeta(new String[]{"empty"}, new DataType[]{DataType.StringType})).build();
    }

    private DataSet adjustRepayAmt(DataSet dataSet, List<Object> finDebtsbillIds, Date deadline) {
        QFilter qFilter = new QFilter("findebtsbillf7", "in", finDebtsbillIds);
        if (EmptyUtil.isNoEmpty((Object)deadline)) {
            qFilter.and(new QFilter("bizdate", "<=", (Object)deadline));
        }
        qFilter.and(new QFilter(BILLSTATUS, "=", (Object)BillStatusEnum.AUDIT.getValue()));
        DataSet finRepayResult = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"scf_finrepaybill", (String)"findebtsbillf7,bizdate repaydate,amount yetrepayamt", (QFilter[])new QFilter[]{qFilter}, null);
        finRepayResult = finRepayResult.groupBy(new String[]{"findebtsbillf7"}).sum(REPAYAMOUNT).finish();
        DataSet completeJoin = dataSet.leftJoin(finRepayResult).on("id", "findebtsbillf7").select(dataSet.getRowMeta().getFieldNames(), new String[]{REPAYAMOUNT, "amount-yetrepayamt norepayamt"}).finish();
        return completeJoin.updateField(REPAYAMOUNT, "case when yetrepayamt is null then 0 else yetrepayamt end").updateField("norepayamt", "case when norepayamt is null then amount else norepayamt end");
    }

    private List<String> getStatDim() {
        String columnStr;
        String statdim;
        switch (statdim = (String)this.getQueryParam().getCustomParam().get("filter_statdim")) {
            case "scf_funder": {
                columnStr = "funder";
                break;
            }
            case "scf_type": {
                columnStr = "scftype";
                break;
            }
            default: {
                columnStr = "orgtext";
            }
        }
        return Arrays.stream(columnStr.split(",")).collect(Collectors.toList());
    }

    protected List<String> orinalAmountField() {
        ArrayList<String> amountFields = new ArrayList<String>(6);
        amountFields.add("amount");
        amountFields.add(REPAYAMOUNT);
        amountFields.add("norepayamt");
        amountFields.add("contractamount");
        amountFields.add("draftamount");
        amountFields.add(TOTALFEEAMOUNT);
        return amountFields;
    }

    public List<String> sumAmountFields() {
        ArrayList<String> sumFields = new ArrayList<String>(4);
        sumFields.add("amountconvert");
        sumFields.add("norepayamtconvert");
        sumFields.add("totalfeeamountconvert");
        return sumFields;
    }

    public List<String> groupFields() {
        return this.getStatDim();
    }

    protected String getReportField(String field) {
        return field + "convert";
    }
}

