/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.scf.report.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.ReportShowTypeEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import org.apache.commons.lang3.tuple.Pair;

public class FindebtsSumDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final String SELECT_FIELDS = "id," + "org.id as org," + "org.name as orgname," + "org.name as orgtext," + "funder.id as funderid," + "funder.name as funder," + "scftype.id as scftypeid," + "scftype.name as scftype," + "currency.id as currency," + "currency.name as currencytext," + "amount";

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        String statdim;
        Map paramMap = this.transQueryParam(queryParam);
        this.getQueryParam().getCustomParam().put("filter_statdim", paramMap.get("filter_statdim"));
        this.getQueryParam().getCustomParam().put("filter_deadline", paramMap.get("filter_deadline"));
        this.getQueryParam().getCustomParam().put("filter_showttype", paramMap.get("filter_showttype"));
        paramMap.putAll(queryParam.getCustomParam());
        QFilter[] qFilters = this.buildFilter(paramMap, this.getQueryOrgIds(queryParam));
        List finDebtsbillIds = QueryServiceHelper.queryPrimaryKeys((String)"scf_findebtsbill", (QFilter[])qFilters, (String)"", (int)-1);
        DataSet finDebtsbillResult = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"scf_findebtsbill", (String)SELECT_FIELDS, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)finDebtsbillIds)}, null);
        finDebtsbillResult = this.adjustRepayAmt(finDebtsbillResult, finDebtsbillIds);
        QFilter feeIdFilter = new QFilter("entry.srcbillid", "in", (Object)finDebtsbillIds);
        feeIdFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        DataSet feeBillResult = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cfm_feebill", (String)"entry.srcbillid,entry.feedetailamt,entry.excrate", (QFilter[])new QFilter[]{feeIdFilter}, null);
        DataSet feeBillResultSum = feeBillResult.groupBy(new String[]{"entry.srcbillid"}).sum("entry.feedetailamt", "totalfeeamount").finish();
        DataSet resultInfo = finDebtsbillResult.leftJoin(feeBillResultSum).on("id", "entry.srcbillid").select(finDebtsbillResult.getRowMeta().getFieldNames(), new String[]{"totalfeeamount"}).finish();
        switch (statdim = (String)paramMap.get("filter_statdim")) {
            case "scf_funder": {
                return this.getDataSetByFunder(resultInfo);
            }
            case "scf_type": {
                return this.getDataSetByScftype(resultInfo);
            }
        }
        return this.getDataSetByOrg(resultInfo);
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        ReportQueryParam queryParam = this.getQueryParam();
        if (ReportShowTypeEnum.STEP.getValue().equals(queryParam.getFilter().getString("filter_showttype"))) {
            for (AbstractReportColumn column : columns) {
                if (!"currency".equals(((ReportColumn)column).getFieldKey())) continue;
                ((ReportColumn)column).setHide(true);
            }
        }
        return columns;
    }

    public QFilter[] buildFilter(Map<String, Object> paramMap, List<Long> orgIds) {
        DynamicObjectCollection filterScfType;
        DynamicObjectCollection filterScfFunder;
        Date filterEndDate;
        ArrayList<QFilter> qfiters = new ArrayList<QFilter>(8);
        qfiters.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        qfiters.add(new QFilter("org", "in", orgIds));
        Date filterStartDate = (Date)paramMap.get("filter_startdate");
        if (EmptyUtil.isNoEmpty((Object)filterStartDate)) {
            qfiters.add(new QFilter("enddate", ">=", (Object)filterStartDate));
        }
        if (EmptyUtil.isNoEmpty((Object)(filterEndDate = (Date)paramMap.get("filter_enddate")))) {
            qfiters.add(new QFilter("enddate", "<=", (Object)DateUtils.getDataFormat((Date)filterEndDate, (boolean)false)));
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(filterScfFunder = (DynamicObjectCollection)paramMap.get("filter_scffunder")))) {
            qfiters.add(new QFilter("funder", "in", (Object)filterScfFunder.stream().map(DataEntityBase::getPkValue).toArray()));
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(filterScfType = (DynamicObjectCollection)paramMap.get("filter_scftype")))) {
            qfiters.add(new QFilter("scftype", "in", (Object)filterScfType.stream().map(DataEntityBase::getPkValue).toArray()));
        }
        String filterBizStatus = (String)paramMap.get("filter_bizstatus");
        String[] bizstatus = filterBizStatus.substring(1, filterBizStatus.length() - 1).split(",");
        qfiters.add(new QFilter("bizstatus", "in", (Object)bizstatus));
        return qfiters.toArray(new QFilter[0]);
    }

    private DataSet getDataSetByOrg(DataSet resultInfo) {
        return resultInfo.groupBy(new String[]{"org", "orgtext", "currency"}).sum("amount").sum("norepayamt").sum("totalfeeamount").finish();
    }

    private DataSet getDataSetByFunder(DataSet resultInfo) {
        return resultInfo.groupBy(new String[]{"funderid", "funder", "currency"}).sum("amount").sum("norepayamt").sum("totalfeeamount").finish();
    }

    private DataSet getDataSetByScftype(DataSet resultInfo) {
        return resultInfo.groupBy(new String[]{"scftypeid", "scftype", "currency"}).sum("amount").sum("norepayamt").sum("totalfeeamount").finish();
    }

    public Pair<String, String> getBizAndReportOrgProp() {
        return Pair.of((Object)"org", (Object)"orgtext");
    }

    public List<String> sumAmountFields() {
        return Arrays.asList("amount_report", "norepayamt_report", "totalfeeamount_report");
    }

    public String sumNameField() {
        String columnStr;
        String statdim;
        switch (statdim = (String)this.getQueryParam().getCustomParam().get("filter_statdim")) {
            case "scf_funder": {
                columnStr = "funder";
                break;
            }
            case "scf_type": {
                columnStr = "scftype";
                break;
            }
            default: {
                columnStr = "orgtext";
            }
        }
        return columnStr;
    }

    protected List<String> orinalAmountField() {
        return Arrays.asList("amount", "norepayamt", "totalfeeamount");
    }

    public List<String> amountFields() {
        return Arrays.asList("amount_report", "norepayamt_report", "totalfeeamount_report");
    }

    public List<String> groupFields() {
        String statdim;
        ArrayList<String> list = new ArrayList<String>(8);
        switch (statdim = (String)this.getQueryParam().getCustomParam().get("filter_statdim")) {
            case "scf_funder": {
                list.add("funder");
                break;
            }
            case "scf_type": {
                list.add("scftype");
                break;
            }
            default: {
                list.add("org");
                list.add("orgtext");
            }
        }
        String showType = (String)this.getQueryParam().getCustomParam().get("filter_showttype");
        if ("tile".equals(showType)) {
            list.add("currency");
        }
        return list;
    }

    protected boolean isNeedOrgTree() {
        return true;
    }

    protected boolean isOrgNeedAddRootNode() {
        return true;
    }

    private DataSet adjustRepayAmt(DataSet dataSet, List<Object> finDebtsbillIds) {
        QFilter qFilter = new QFilter("findebtsbillf7", "in", finDebtsbillIds);
        Date deadline = (Date)this.getQueryParam().getCustomParam().get("filter_deadline");
        if (EmptyUtil.isNoEmpty((Object)deadline)) {
            qFilter.and(new QFilter("bizdate", "<=", (Object)deadline));
        }
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        DataSet finRepayResult = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"scf_finrepaybill", (String)"findebtsbillf7,bizdate repaydate,amount yetrepayamt", (QFilter[])new QFilter[]{qFilter}, null);
        finRepayResult = finRepayResult.groupBy(new String[]{"findebtsbillf7"}).sum("yetrepayamt").finish();
        DataSet completeJoin = dataSet.leftJoin(finRepayResult).on("id", "findebtsbillf7").select(dataSet.getRowMeta().getFieldNames(), new String[]{"amount-yetrepayamt norepayamt"}).finish();
        return completeJoin.updateField("norepayamt", "case when norepayamt is null then amount else norepayamt end");
    }
}

