/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.scf.report.helper;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.exception.KDBizException;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.filter.ReportFilter;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ReportHelper {
    public static void selectDate(IDataModel dataModel, String type) {
        switch (type) {
            case "1": {
                dataModel.setValue("filter_startdate", (Object)DateUtils.getFirstDayOfMonth((Date)DateUtils.getCurrentDate()));
                dataModel.setValue("filter_enddate", (Object)DateUtils.getLastDayOfMonth((Date)DateUtils.getCurrentDate()));
                break;
            }
            case "2": {
                dataModel.setValue("filter_startdate", (Object)DateUtils.getLastMonth((Date)DateUtils.getCurrentDate(), (int)3));
                dataModel.setValue("filter_enddate", (Object)DateUtils.getLastDayOfMonth((Date)DateUtils.getCurrentDate()));
                break;
            }
            case "3": {
                dataModel.setValue("filter_startdate", (Object)DateUtils.getLastMonth((Date)DateUtils.getCurrentDate(), (int)6));
                dataModel.setValue("filter_enddate", (Object)DateUtils.getLastDayOfMonth((Date)DateUtils.getCurrentDate()));
                break;
            }
            case "4": {
                dataModel.setValue("filter_startdate", (Object)DateUtils.getLastMonth((Date)DateUtils.getCurrentDate(), (int)12));
                dataModel.setValue("filter_enddate", (Object)DateUtils.getLastDayOfMonth((Date)DateUtils.getCurrentDate()));
                break;
            }
        }
    }

    public static void addReportColumn(FilterInfo filter, ReportList listTab) {
        String columnStr;
        String statdim;
        List columns = listTab.getColumns();
        switch (statdim = filter.getString("filter_statdim")) {
            case "scf_funder": {
                columnStr = "funder,orgtext,scftype";
                break;
            }
            case "scf_type": {
                columnStr = "scftype,orgtext,funder";
                break;
            }
            default: {
                columnStr = "orgtext,scftype,funder";
            }
        }
        String[] colArr = columnStr.split(",");
        for (int i = 0; i < colArr.length; ++i) {
            ReportColumn reportColumn = new ReportColumn();
            reportColumn.setFieldType("text");
            reportColumn.setFieldKey(colArr[i]);
            reportColumn.setCaption(new LocaleString(ReportHelper.getColumnName(colArr[i])));
            columns.add(i, reportColumn);
        }
    }

    public static void addSumReportColumn(FilterInfo filter, ReportList listTab) {
        String columnStr;
        String statdim;
        List columns = listTab.getColumns();
        switch (statdim = filter.getString("filter_statdim")) {
            case "scf_funder": {
                columnStr = "funder";
                break;
            }
            case "scf_type": {
                columnStr = "scftype";
                break;
            }
            default: {
                columnStr = "orgtext";
            }
        }
        String finalColumnStr = columnStr;
        columns.removeIf(c -> ((ReportColumn)c).getFieldKey().equals(finalColumnStr));
        ReportColumn reportColumn = new ReportColumn();
        reportColumn.setFieldType("text");
        reportColumn.setFieldKey(columnStr);
        reportColumn.setCaption(new LocaleString(ReportHelper.getColumnName(columnStr)));
        columns.add(0, reportColumn);
    }

    public static String getColumnName(String field) {
        String name = "";
        switch (field) {
            case "orgtext": {
                name = ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7", (String)"FincreditDetailFormPlugin_4", (String)"tmc-scf-report", (Object[])new Object[0]);
                break;
            }
            case "funder": {
                name = ResManager.loadKDString((String)"\u8d44\u91d1\u65b9", (String)"FincreditDetailFormPlugin_5", (String)"tmc-scf-report", (Object[])new Object[0]);
                break;
            }
            case "scftype": {
                name = ResManager.loadKDString((String)"\u4f9b\u5e94\u94fe\u878d\u8d44\u7c7b\u578b", (String)"FincreditDetailFormPlugin_6", (String)"tmc-scf-report", (Object[])new Object[0]);
                break;
            }
        }
        return name;
    }

    public static void autoSearch(ReportFilter rptFilter, IReportView reportView) {
        if (!EmptyUtil.isEmpty((Object)rptFilter)) {
            try {
                rptFilter.search();
            }
            catch (KDBizException bizEx) {
                reportView.showErrorNotification(bizEx.getMessage());
            }
        }
    }

    private ReportHelper() {
    }
}

