/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.opplugin.synthsis;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.opplugin.sysimport.AbstractTmcBatchImportPlugin;

public class SynthsisBatchImportOp
extends AbstractTmcBatchImportPlugin {
    private static final String ID = "id";
    private static final String NUMBER = "number";
    private static final String YEAR_REGEX = "^(19|2[0-9])[0-9]{2}$";

    protected void beforeImportOp(Map<String, Object> rowdata, Map<String, Object> option) {
        Map<String, Object> orgMap = this.checkOrg(rowdata);
        Map<String, Object> orgViewMap = this.checkOrgView(rowdata);
        int accountYear = this.checkYear(rowdata);
        String importType = this.getCurrentImportType();
        if ("new".equals(importType)) {
            QFilter qFilter = new QFilter("orgview.id", "=", orgViewMap.get(ID));
            qFilter.and("org.id", "=", orgMap.get(ID));
            qFilter.and("budgetyear", "=", (Object)accountYear);
            boolean exists = TmcDataServiceHelper.exists((String)"tda_budgetbill", (QFilter[])new QFilter[]{qFilter});
            if (exists) {
                this.addErrMessage(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u5b58\u5728\u3002\u7ec4\u7ec7\u89c6\u56fe\u7f16\u7801\uff1a\u3010%1$s\u3011, \u7ec4\u7ec7\u7f16\u7801\uff1a\u3010%2$s\u3011, \u9884\u7b97\u5e74\u4efd\uff1a\u3010%3$s\u3011\u3002", (String)"SynthsisBatchImportOp_03", (String)"tmc-tda-opplugin", (Object[])new Object[]{orgViewMap.get(NUMBER), orgMap.get(NUMBER), accountYear}));
            }
        } else {
            String keyFields = (String)option.get("KeyFields");
            if (!(keyFields.contains("orgview") && keyFields.contains("org") && keyFields.contains("accountyear") && keyFields.contains("budgetyear"))) {
                this.addErrMessage(ResManager.loadKDString((String)"\u66f4\u65b0\u5df2\u6709\u6570\u636e\u65f6\u5fc5\u987b\u9009\u62e9\u7ec4\u7ec7\u89c6\u56fe\u3001\u7ec4\u7ec7\u3001\u9884\u7b97\u5e74\u4efd\u3002", (String)"SynthsisBatchImportOp_04", (String)"tmc-tda-opplugin", (Object[])new Object[0]));
            }
        }
    }

    protected void afterImportOp(List<Map<String, Object>> datas) {
        DynamicObject[] bills;
        if (datas == null) {
            return;
        }
        List pkIds = datas.stream().filter(elem -> (Boolean)elem.get("success")).map(elem -> (Long)elem.get(ID)).collect(Collectors.toList());
        for (DynamicObject bill : bills = TmcDataServiceHelper.load((String)"tda_budgetbill", (String)"orgview,currency", (QFilter[])new QFilter[]{new QFilter(ID, "in", pkIds)})) {
            DynamicObject orgView = bill.getDynamicObject("orgview");
            Long baseCurrencyId = AmountTransHelper.getBaseCurrency((Long)orgView.getLong(ID));
            bill.set("currency", (Object)baseCurrencyId);
        }
        SaveServiceHelper.save((DynamicObject[])bills);
    }

    private Map<String, Object> checkOrg(Map<String, Object> rowdata) {
        Long orgId;
        List permOrgList;
        JSONObject org = (JSONObject)rowdata.get("org");
        String orgNum = "";
        if (org == null) {
            this.addErrMessage(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LiquidityBatchImportOp_01", (String)"tmc-tda-opplugin", (Object[])new Object[0]));
        } else {
            orgNum = org.getString(NUMBER);
        }
        DynamicObject orgDO = TmcDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)ID, (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)orgNum)});
        if (EmptyUtil.isEmpty((DynamicObject)orgDO)) {
            this.addErrMessage(ResManager.loadKDString((String)"\u6b64\u7ec4\u7ec7\u3010%s\u3011\u4e0d\u5b58\u5728\u3002", (String)"LiquidityBatchImportOp_02", (String)"tmc-tda-opplugin", (Object[])new Object[]{orgNum}));
        }
        if (!(permOrgList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)"tda", (String)"tda_liquiditybill", (String)"4730fc9f000003ae")).contains(orgId = Long.valueOf(orgDO.getLong(ID)))) {
            this.addErrMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6b64\u7ec4\u7ec7\u3010%s\u3011\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"LiquidityBatchImportOp_03", (String)"tmc-tda-opplugin", (Object[])new Object[]{orgNum}));
        }
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        result.put(ID, orgId);
        result.put(NUMBER, orgNum);
        return result;
    }

    private Map<String, Object> checkOrgView(Map<String, Object> rowdata) {
        JSONObject orgView = (JSONObject)rowdata.get("orgview");
        String orgViewNum = "";
        if (orgView == null) {
            this.addErrMessage(ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LiquidityBatchImportOp_04", (String)"tmc-tda-opplugin", (Object[])new Object[0]));
        } else {
            orgViewNum = orgView.getString(NUMBER);
        }
        DynamicObject orgViewDO = TmcDataServiceHelper.loadSingleFromCache((String)"fbd_companysysviewsch", (String)ID, (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)orgViewNum)});
        if (EmptyUtil.isEmpty((DynamicObject)orgViewDO)) {
            this.addErrMessage(ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe\u3010%s\u3011\u4e0d\u5b58\u5728\u3002", (String)"LiquidityBatchImportOp_05", (String)"tmc-tda-opplugin", (Object[])new Object[]{orgViewNum}));
        }
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        result.put(ID, orgViewDO.getLong(ID));
        result.put(NUMBER, orgViewNum);
        return result;
    }

    private int checkYear(Map<String, Object> rowdata) {
        String accountYear = (String)rowdata.get("budgetyear");
        if (EmptyUtil.isEmpty((String)accountYear)) {
            this.addErrMessage(ResManager.loadKDString((String)"\u9884\u7b97\u5e74\u4efd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SynthsisBatchImportOp_01", (String)"tmc-tda-opplugin", (Object[])new Object[0]));
        }
        if (!accountYear.matches(YEAR_REGEX)) {
            this.addErrMessage(ResManager.loadKDString((String)"\u9884\u7b97\u5e74\u4efd\u3010%s\u3011\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"SynthsisBatchImportOp_02", (String)"tmc-tda-opplugin", (Object[])new Object[]{accountYear}));
        }
        return Integer.parseInt(accountYear);
    }
}

