/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.arap.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.report.arap.helper.ArapDataSetHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public abstract class AbstractArApAgingDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String A = "a_";
    private static final String R = "r_";
    private static final String G = "g_";
    private static final String AGING = "aging";
    private Map<String, String> columnsMap = null;

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        for (Map.Entry<String, String> entry : this.columnsMap.entrySet()) {
            String key_gourp = G + entry.getKey();
            String key_amount = A + entry.getKey();
            String key_ratio = R + entry.getKey();
            ReportColumnGroup reportColumnGroup = new ReportColumnGroup();
            reportColumnGroup.setFieldKey(key_gourp);
            reportColumnGroup.setCaption(new LocaleString(entry.getValue()));
            reportColumnGroup.getChildren().add(this.createColumn(key_amount, ResManager.loadKDString((String)"\u91d1\u989d", (String)"AbstractArApAgingDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal"));
            reportColumnGroup.getChildren().add(this.createColumn(key_ratio, ResManager.loadKDString((String)"\u6bd4\u4f8b(%)", (String)"AbstractArApAgingDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal"));
            columns.add((AbstractReportColumn)reportColumnGroup);
        }
        columns.add((AbstractReportColumn)this.createColumn("sumamount", this.getName(), "decimal"));
        return columns;
    }

    private ReportColumn createColumn(String fieldKey, String caption, String type) {
        ReportColumn reportColumn = new ReportColumn();
        reportColumn.setFieldKey(fieldKey);
        reportColumn.setFieldType(type);
        reportColumn.setZeroShow(true);
        reportColumn.setScale(2);
        reportColumn.setCaption(new LocaleString(caption));
        reportColumn.setWidth(new LocaleString("100px"));
        reportColumn.setCurrencyField("currencyfield");
        return reportColumn;
    }

    @Override
    protected DataSet queryDataSet(ReportQueryParam param) {
        Map paramMap = this.transQueryParam(param);
        DataSet allDs = ArapDataSetHelper.queryArapSummaryData(((Object)((Object)this)).getClass().getName(), paramMap, 12);
        return allDs.groupBy(new String[]{"billtype", "custsupptype", "orgid", "orgname", "agingname", "paymentday", "agingseq"}).sum("amount").finish();
    }

    private DataSet handleDataSet(DataSet allDs, Map<String, Object> paramMap) {
        String paymentDay = (String)paramMap.get("paymentDay");
        DataSet filter = allDs.filter("billtype = '" + this.getBillType() + "' and paymentday = '" + paymentDay + "' and agingname != ' '");
        String custSuppType = (String)paramMap.get("custsupptype");
        if (EmptyUtil.isNoEmpty((String)custSuppType) && !"allside".equals(custSuppType)) {
            filter = filter.filter("custsupptype = '" + custSuppType + "'");
        }
        DataSet sumResultSet = filter.groupBy(new String[]{"orgid", "orgname", "agingname", "paymentday", "agingseq"}).sum("amount", "amount").finish().orderBy(new String[]{"agingseq"});
        Long orgview = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgview);
        DataSet columnsGroup = sumResultSet.copy().groupBy(new String[]{"agingname", "agingseq"}).finish().orderBy(new String[]{"agingseq"});
        this.columnsMap = new LinkedHashMap<String, String>(6);
        while (columnsGroup.hasNext()) {
            Row row = columnsGroup.next();
            this.columnsMap.put(AGING + row.getString("agingseq"), row.getString("agingname"));
        }
        StringBuilder sumFields = new StringBuilder();
        if (!CollectionUtils.isEmpty(this.columnsMap)) {
            StringBuilder updateFileds = new StringBuilder("case");
            String when = " when agingname= '";
            String then = "' then '";
            String split = "'";
            String plus = "+";
            for (Map.Entry<String, String> entry : this.columnsMap.entrySet()) {
                updateFileds.append(when).append(entry.getValue()).append(then).append(entry.getKey()).append(split);
                sumFields.append(A).append(entry.getKey()).append(plus);
            }
            updateFileds.append(" else agingname end");
            sumResultSet = sumResultSet.updateField("agingname", updateFileds.toString()).addField("amount", "count");
        } else {
            sumResultSet = sumResultSet.updateField("agingname", "' '").addField("amount", "count");
        }
        sumResultSet = DecisionAnlsHelper.ChangeRowToColDataSet(sumResultSet, "agingname", "orgid,orgname", A);
        sumResultSet = orgDateSet.leftJoin(sumResultSet).on("rowid", "orgid").select(new String[]{"rowid", "pid", "isgroupnode", "level", "mixorgname", "sortcode"}, sumResultSet.getRowMeta().getFieldNames()).finish().addField("0", "sumlevel").updateFields(new String[]{"orgid", "orgname"}, new String[]{"rowid", "mixorgname"});
        List<String> amoutFields = this.getAFields();
        sumResultSet = DecisionAnlsHelper.getSumDataSetByLevel(sumResultSet, amoutFields, TmcBusinessBaseHelper.listToString(Arrays.asList("orgid", "orgname", "sortcode")));
        if (!CollectionUtils.isEmpty(amoutFields)) {
            sumResultSet = DecisionAnlsHelper.removeNoDataTreeDs(sumResultSet, amoutFields, false);
        }
        String sumamountStr = EmptyUtil.isEmpty((String)sumFields.toString()) ? "0" : sumFields.substring(0, sumFields.toString().length() - 1);
        sumResultSet = sumResultSet.addField(sumamountStr, "sumamount");
        String[] ratioFields = new String[amoutFields.size()];
        String[] ratioValues = new String[amoutFields.size()];
        for (int i = 0; i < amoutFields.size(); ++i) {
            ratioFields[i] = amoutFields.get(i).replace(A, R);
            ratioValues[i] = amoutFields.get(i) + "/sumamount*100";
        }
        sumResultSet = sumResultSet.addFields(ratioValues, ratioFields);
        return sumResultSet;
    }

    @Override
    protected DataSet filterResultDataSet(DataSet sumResultSet, ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        sumResultSet = this.handleDataSet(sumResultSet, paramMap);
        List subOrgIds = (List)paramMap.get("suborgids");
        if (EmptyUtil.isNoEmpty((Object)subOrgIds)) {
            sumResultSet = sumResultSet.where("orgid in (" + TmcBusinessBaseHelper.idListToString((List)subOrgIds) + ")");
        } else {
            List allOrgIds = (List)paramMap.get("allorgids");
            sumResultSet = sumResultSet.where("orgid in (" + TmcBusinessBaseHelper.idListToString((List)allOrgIds) + ")");
        }
        if (sumResultSet.getRowMeta().getFieldIndex("sortcode", false) >= 0) {
            sumResultSet = sumResultSet.orderBy(new String[]{"sortcode"});
        }
        DataSet totalDS = DecisionAnlsHelper.addAllTotalDataSet(sumResultSet, this.getSumFields(), "orgname");
        ArrayList<String> ratioList = new ArrayList<String>(16);
        ArrayList<String> totalList = new ArrayList<String>(16);
        for (Map.Entry<String, String> entry : this.columnsMap.entrySet()) {
            ratioList.add(R + entry.getKey());
            totalList.add(A + entry.getKey() + "/sumamount*100");
        }
        totalDS = totalDS.updateFields(ratioList.toArray(new String[0]), totalList.toArray(new String[0]));
        DynamicObject reportCurrency = (DynamicObject)paramMap.get("currency");
        DataSet dataSet = sumResultSet.union(totalDS).addField(String.valueOf(reportCurrency.getPkValue()), "currencyfield");
        return dataSet;
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(6);
        fields.addAll(this.getAFields());
        fields.add("sumamount");
        return fields;
    }

    private List<String> getAFields() {
        ArrayList<String> list = new ArrayList<String>(6);
        for (Map.Entry<String, String> entry : this.columnsMap.entrySet()) {
            list.add(A + entry.getKey());
        }
        return list;
    }

    private List<String> getSumFields() {
        ArrayList<String> list = new ArrayList<String>(12);
        for (Map.Entry<String, String> entry : this.columnsMap.entrySet()) {
            list.add(A + entry.getKey());
        }
        list.add("sumamount");
        return list;
    }

    protected abstract String getBillType();

    protected abstract String getName();
}

