/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.arap.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.extplugin.PluginProxy;
import kd.sdk.tmc.tda.extpoint.arap.IArApTopCustSuppInterface;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.report.arap.helper.ArapDataSetHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public abstract class AbstractExtArApTopCustSuppDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    protected static final String TOP_MAP = "topMap";
    private static final String RANK = "rank";

    @Override
    protected DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        DataSet allDataSet = ArapDataSetHelper.queryArapSummaryData(((Object)((Object)this)).getClass().getName(), paramMap, 12);
        ArrayList<String> fieldList = new ArrayList<String>(10);
        fieldList.add("billtype");
        fieldList.add("paymentday");
        fieldList.add("custsupptype");
        fieldList.add("orgid");
        fieldList.add("orgname");
        fieldList.addAll(this.getCustSuppFieldName());
        return allDataSet.groupBy(fieldList.toArray(new String[0])).sum("amount").finish();
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        ds = this.handleDataSet(ds, paramMap);
        Map<String, String> topTenCustSupp = this.getTopTenCustSupp(ds.copy());
        queryParam.getCustomParam().put(TOP_MAP, topTenCustSupp);
        ArrayList<String> topTenCustSuppNames = new ArrayList<String>(topTenCustSupp.values());
        String custSuppNameFiled = this.getCustSuppFieldName().get(1);
        DataSet otherCustSuppDs = ds.copy().filter(custSuppNameFiled + " not in nameList", Collections.singletonMap("nameList", topTenCustSuppNames));
        List<String> arApAmountFields = this.getArApAmountFields();
        String otherAmountField = arApAmountFields.get(0);
        DataSet otherAmtSumDs = otherCustSuppDs.groupBy(new String[]{"orgid", "orgname"}).sum("amount").finish().select("orgid,orgname, amount as " + otherAmountField);
        DataSet topTenCustSuppDs = this.createTopTenDs(topTenCustSupp);
        List<String> fields = Arrays.stream(ds.getRowMeta().getFieldNames()).collect(Collectors.toList());
        fields.add(RANK);
        ds = ds.leftJoin(topTenCustSuppDs).on(custSuppNameFiled, custSuppNameFiled).select(fields.toArray(new String[0])).finish();
        String prefixField = arApAmountFields.get(2);
        DataSet arapAmountDs = DecisionAnlsHelper.ChangeRowToColDataSet(ds.addField("amount", "count"), RANK, "orgid,orgname", prefixField);
        ArrayList topTenAmtFields = new ArrayList(10);
        topTenCustSupp.keySet().forEach(e -> topTenAmtFields.add(prefixField + e));
        ArrayList<String> fieldList = new ArrayList<String>(topTenAmtFields);
        fieldList.add("orgid");
        fieldList.add("orgname");
        fieldList.add(otherAmountField);
        DataSet dataSet = arapAmountDs.leftJoin(otherAmtSumDs).on("orgid", "orgid").select(fieldList.toArray(new String[0])).finish();
        ArrayList<String> amountFields = new ArrayList<String>(topTenAmtFields);
        amountFields.add(otherAmountField);
        String subTotalField = arApAmountFields.get(1);
        dataSet = dataSet.addField(String.join((CharSequence)"+", amountFields.toArray(new String[0])), subTotalField);
        fieldList.add(subTotalField);
        fieldList.remove("orgname");
        amountFields.add(subTotalField);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        fieldList.add("sortcode");
        DataSet orgJoinSet = orgDateSet.leftJoin(dataSet).on("rowid", "orgid").select(this.getSelectFields(fieldList).toArray(new String[0])).finish();
        DataSet sumDataSet = DecisionAnlsHelper.getSumDataSetByLevel(orgJoinSet, amountFields, "orgname,orgid,sortcode");
        DynamicObject reportCurrency = (DynamicObject)paramMap.get("currency");
        Long currencyId = reportCurrency != null ? Long.valueOf(reportCurrency.getLong("id")) : (Long)paramMap.get("basecurrency");
        List filterOrg = (List)paramMap.get("suborgids");
        if (EmptyUtil.isEmpty((Collection)filterOrg)) {
            filterOrg = (List)paramMap.get("allorgids");
        }
        if (EmptyUtil.isNoEmpty((Object)filterOrg)) {
            sumDataSet = sumDataSet.filter("orgid in filterorg", Collections.singletonMap("filterorg", filterOrg));
        }
        sumDataSet = sumDataSet.filter(subTotalField + " != 0 and " + subTotalField + " != null");
        if ((sumDataSet = sumDataSet.addField(String.valueOf(currencyId), "currencyfield")).getRowMeta().getFieldIndex("sortcode", false) >= 0) {
            sumDataSet = sumDataSet.orderBy(new String[]{"sortcode"});
        }
        DataSet totalDataSet = this.addAllTotalDataSet(sumDataSet, amountFields, Collections.singletonList("currencyfield"), "orgname");
        DataSet resultDs = sumDataSet.union(totalDataSet);
        return AmountTransHelper.dealRowOtherValue((DataSet)resultDs, (Map)paramMap, new HashSet<String>(amountFields));
    }

    private DataSet handleDataSet(DataSet allDataSet, Map<String, Object> paramMap) {
        String paymentDay = EmptyUtil.isNoEmpty((Object)paramMap.get("paymentDay")) ? (String)paramMap.get("paymentDay") : this.getLastTerm(new Date());
        allDataSet = allDataSet.filter("paymentday = '" + paymentDay + "'");
        String custsupptype = (String)paramMap.get("custsupptype");
        if (EmptyUtil.isNoEmpty((String)custsupptype) && !"allside".equals(custsupptype)) {
            allDataSet = allDataSet.filter("custsupptype = '" + custsupptype + "'");
        }
        List<String> fieldList = this.getCustSuppFieldName();
        String custSuppField = fieldList.get(1);
        allDataSet = allDataSet.filter("billtype = '" + this.getBillType() + "'").filter(this.buildExtendFilter(custSuppField));
        fieldList.add("orgid");
        fieldList.add("orgname");
        return allDataSet.groupBy(fieldList.toArray(new String[0])).sum("amount").finish();
    }

    protected Map<String, String> getTopTenCustSupp(DataSet allDataSet) {
        String orderStr;
        List<String> groupFields = this.getCustSuppFieldName();
        if (!groupFields.contains(orderStr = "customerid")) {
            orderStr = "supplierid";
        }
        DataSet ds = allDataSet.groupBy(groupFields.toArray(new String[0])).sum("amount").finish().orderBy(new String[]{"amount desc", orderStr}).top(10);
        LinkedHashMap<String, String> topCustSupp = new LinkedHashMap<String, String>(16);
        int i = 1;
        while (ds.hasNext()) {
            Row row = ds.next();
            topCustSupp.put("top" + i, row.getString(1));
            ++i;
        }
        return topCustSupp;
    }

    private FilterFunction buildExtendFilter(String propertyName) {
        PluginProxy pluginProxy = PluginProxy.create(IArApTopCustSuppInterface.class, (String)"kd.sdk.tmc.tda.extpoint.arap.IArApTopCustSuppInterface");
        List filterFunctions = pluginProxy.callReplace(p -> p.buildExtendFilter(propertyName));
        if (EmptyUtil.isNoEmpty((Object)filterFunctions) && EmptyUtil.isNoEmpty(filterFunctions.get(0))) {
            return (FilterFunction)filterFunctions.get(0);
        }
        return new FilterFunction(){

            public boolean test(Row row) {
                return true;
            }
        };
    }

    protected ReportColumn createColumn(String fieldKey, String caption) {
        ReportColumn reportColumn = new ReportColumn();
        reportColumn.setFieldKey(fieldKey);
        reportColumn.setScale(2);
        reportColumn.setFieldType("decimal");
        reportColumn.setHideSingleColumnRow(false);
        ColumnStyle style = new ColumnStyle();
        style.setTextAlign("center");
        reportColumn.setZeroShow(true);
        reportColumn.setCaption(new LocaleString(caption));
        reportColumn.setStyle(style);
        return reportColumn;
    }

    private List<String> getSelectFields(List<String> fieldList) {
        fieldList.add("isgroupnode");
        fieldList.add("mixorgname as orgname");
        fieldList.add("level");
        fieldList.add("pid");
        fieldList.add("rowid");
        fieldList.add("0 as sumlevel");
        return fieldList;
    }

    private String getLastTerm(Date queryDate) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(queryDate);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        if (month == 1) {
            --year;
            month = 13;
        }
        String monthStr = month - 1 < 10 ? "0" + (month - 1) : String.valueOf(month - 1);
        String paymentDay = year + "-" + monthStr;
        return paymentDay;
    }

    private DataSet createTopTenDs(Map<String, String> topTenCustSupp) {
        String custSuppNameField = this.getCustSuppFieldName().get(1);
        ArrayList<Object[]> collection = new ArrayList<Object[]>(10);
        for (Map.Entry<String, String> entry : topTenCustSupp.entrySet()) {
            collection.add(new Object[]{entry.getKey(), entry.getValue()});
        }
        return DecisionAnlsHelper.createRow(((Object)((Object)this)).getClass().getName(), new String[]{RANK, custSuppNameField}, new DataType[]{DataType.StringType, DataType.StringType}, collection);
    }

    protected abstract String getBillType();

    protected abstract List<String> getCustSuppFieldName();

    protected abstract List<String> getArApAmountFields();
}

