/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.arap.data;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.report.arap.helper.ArapDataSetHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class ArDistributionRptListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String[] EMPTY_FIELD = new String[]{"orgid", "paymentday", "custsupptype", "arapamt", "arapcount", "drdpamt", "drdpcount", "lastyeararapamt", "lastyeardrdpamt", "lastmontharapamt", "lastmonthdrdpamt"};
    private static final DataType[] EMPTY_TYPE = new DataType[]{DataType.LongType, DataType.StringType, DataType.StringType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType};
    private static final String[] FIELD = new String[]{"orgid", "paymentday", "custsupptype", "currency", "amount", "count"};
    private static final DataType[] FIELD_TYPE = new DataType[]{DataType.LongType, DataType.StringType, DataType.StringType, DataType.LongType, DataType.BigDecimalType, DataType.BigDecimalType};
    private static final int MAX_TERM_COUNT = 12;

    protected String getArApBillType() {
        return "ar_finarbill";
    }

    protected String getDrDpBillType() {
        return "cas_paybill";
    }

    @Override
    protected DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        String paymentDay = EmptyUtil.isNoEmpty(paramMap.get("paymentDay")) ? (String)paramMap.get("paymentDay") : this.getLastTerm(new Date());
        DataSet totalDataSet = ArapDataSetHelper.queryArapSummaryData(((Object)((Object)this)).getClass().getName(), paramMap, 24);
        DataSet[] dataSets = totalDataSet.splitByGroup(new String[]{"billtype", "paymentday"});
        HashMap<String, DataSet> groupedDataSetMap = new HashMap<String, DataSet>();
        for (DataSet dataSet : dataSets) {
            if (dataSet.isEmpty()) continue;
            Row firstRow = (Row)dataSet.copy().iterator().next();
            groupedDataSetMap.put(firstRow.getString("paymentday") + firstRow.getString("billtype"), dataSet);
        }
        DataSet dataSet = this.getOneTermDataSet(groupedDataSetMap, paymentDay);
        for (int i = 0; i < 11; ++i) {
            paymentDay = this.getLastMonthTerm(paymentDay);
            DataSet currentTermDataSet = this.getOneTermDataSet(groupedDataSetMap, paymentDay);
            if (dataSet != null && currentTermDataSet != null) {
                dataSet = dataSet.union(currentTermDataSet);
                continue;
            }
            if (dataSet != null || currentTermDataSet == null) continue;
            dataSet = currentTermDataSet;
        }
        return dataSet != null ? dataSet : DecisionAnlsHelper.createEmptyDataSet(EMPTY_FIELD, EMPTY_TYPE);
    }

    private DataSet getOneTermDataSet(Map<String, DataSet> groupedDataSetMap, String paymentDay) {
        DataSet arDataSet = this.get(groupedDataSetMap, paymentDay, this.getArApBillType());
        DataSet dpDataSet = this.get(groupedDataSetMap, paymentDay, this.getDrDpBillType());
        if (arDataSet.copy().isEmpty() && dpDataSet.copy().isEmpty()) {
            return null;
        }
        DataSet lastYearArDataSet = this.get(groupedDataSetMap, this.getLastYearTerm(paymentDay), this.getArApBillType());
        DataSet lastYearDpDataSet = this.get(groupedDataSetMap, this.getLastYearTerm(paymentDay), this.getDrDpBillType());
        DataSet lastMonthArDataSet = this.get(groupedDataSetMap, this.getLastMonthTerm(paymentDay), this.getArApBillType());
        DataSet lastMonthDpDataSet = this.get(groupedDataSetMap, this.getLastMonthTerm(paymentDay), this.getDrDpBillType());
        arDataSet = this.group(arDataSet);
        dpDataSet = this.group(dpDataSet);
        lastYearArDataSet = this.group(lastYearArDataSet);
        lastMonthArDataSet = this.group(lastMonthArDataSet);
        lastYearDpDataSet = this.group(lastYearDpDataSet);
        lastMonthDpDataSet = this.group(lastMonthDpDataSet);
        DataSet lastYearDataSet = this.fullJoin(lastYearArDataSet, lastYearDpDataSet, new String[]{"orgid", "custsupptype"}, new String[]{"amount as lastyeararapamt"}, new String[]{"amount as lastyeardrdpamt"});
        DataSet lastMonthDataSet = this.fullJoin(lastMonthArDataSet, lastMonthDpDataSet, new String[]{"orgid", "custsupptype"}, new String[]{"amount as lastmontharapamt"}, new String[]{"amount as lastmonthdrdpamt"});
        DataSet lastYearAndMonthDataSet = this.fullJoin(lastYearDataSet, lastMonthDataSet, new String[]{"orgid", "custsupptype"}, new String[]{"lastyeararapamt", "lastyeardrdpamt"}, new String[]{"lastmontharapamt", "lastmonthdrdpamt"});
        DataSet dataSet = this.fullJoin(arDataSet, dpDataSet, new String[]{"orgid", "custsupptype", "paymentday"}, new String[]{"amount as arapamt", "count as arapcount"}, new String[]{"amount as drdpamt", "count as drdpcount"}).join(lastYearAndMonthDataSet, JoinType.FULL).on("orgid", "orgid").on("custsupptype", "custsupptype").select(new String[]{"orgid", "paymentday", "custsupptype", "arapamt", "arapcount", "drdpamt", "drdpcount"}, new String[]{"lastyeararapamt", "lastyeardrdpamt", "lastmontharapamt", "lastmonthdrdpamt"}).finish();
        return dataSet;
    }

    private DataSet fullJoin(DataSet left, DataSet right, String[] commonColumns, String[] leftOwnColumns, String[] rightOwnColumns) {
        String[] ss;
        String[] leftCommonColumns = (String[])Arrays.stream(commonColumns).map(o -> o + " as left" + o).toArray(String[]::new);
        String[] rightCommonColumns = (String[])Arrays.stream(commonColumns).map(o -> o + " as right" + o).toArray(String[]::new);
        String[] selectedColumns = new String[commonColumns.length + leftOwnColumns.length + rightOwnColumns.length];
        String[] leftColumns = new String[leftCommonColumns.length + leftOwnColumns.length];
        String[] rightColumns = new String[rightCommonColumns.length + rightOwnColumns.length];
        int index = 0;
        int leftIndex = 0;
        int rightIndex = 0;
        for (int i = 0; i < commonColumns.length; ++i) {
            selectedColumns[index++] = "(case when " + leftCommonColumns[0].split(" ")[2] + " > 0 then " + leftCommonColumns[i].split(" ")[2] + " else " + rightCommonColumns[i].split(" ")[2] + " end) as " + commonColumns[i];
        }
        for (String leftCommonColumn : leftCommonColumns) {
            leftColumns[leftIndex++] = leftCommonColumn;
        }
        for (String leftOwnColumn : leftOwnColumns) {
            ss = leftOwnColumn.split(" ");
            selectedColumns[index++] = ss.length == 1 ? ss[0] : ss[2];
            leftColumns[leftIndex++] = leftOwnColumn;
        }
        for (String rightCommonColumn : rightCommonColumns) {
            rightColumns[rightIndex++] = rightCommonColumn;
        }
        for (String rightOwnColumn : rightOwnColumns) {
            ss = rightOwnColumn.split(" ");
            selectedColumns[index++] = ss.length == 1 ? ss[0] : ss[2];
            rightColumns[rightIndex++] = rightOwnColumn;
        }
        DataSet dataSet = left.join(right, JoinType.FULL).on(commonColumns[0], commonColumns[0]).on(commonColumns[1], commonColumns[1]).select(leftColumns, rightColumns).finish().select(selectedColumns);
        return dataSet;
    }

    private String getLastMonthTerm(String paymentDay) {
        String[] ss = paymentDay.split("-");
        int year = Integer.parseInt(ss[0]);
        int month = Integer.parseInt(ss[1]);
        if (month == 1) {
            --year;
            month = 13;
        }
        String monthStr = month - 1 < 10 ? "0" + (month - 1) : String.valueOf(month - 1);
        return year + "-" + monthStr;
    }

    private String getLastYearTerm(String paymentDay) {
        String[] ss = paymentDay.split("-");
        int year = Integer.parseInt(ss[0]);
        return year - 1 + "-" + ss[1];
    }

    private String getLastTerm(Date queryDate) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(queryDate);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        if (month == 1) {
            --year;
            month = 13;
        }
        String monthStr = month - 1 < 10 ? "0" + (month - 1) : String.valueOf(month - 1);
        String paymentDay = year + "-" + monthStr;
        return paymentDay;
    }

    private DataSet group(DataSet dataSet) {
        return dataSet.groupBy(new String[]{"orgid", "paymentday", "custsupptype"}).sum("amount").sum("count").finish();
    }

    private DataSet get(Map<String, DataSet> groupedDataSetMap, String paymentDay, String billType) {
        DataSet dataSet = groupedDataSetMap.get(paymentDay + billType);
        return dataSet != null ? dataSet.copy().select(FIELD) : DecisionAnlsHelper.createEmptyDataSet(FIELD, FIELD_TYPE);
    }

    @Override
    protected DataSet filterResultDataSet(DataSet sumDataSet, ReportQueryParam queryParam) {
        Long reportCurrency;
        Map paramMap = this.transQueryParam(queryParam);
        String paymentDay = EmptyUtil.isNoEmpty(paramMap.get("paymentDay")) ? (String)paramMap.get("paymentDay") : this.getLastTerm(new Date());
        sumDataSet = sumDataSet.filter("paymentday = '" + paymentDay + "'");
        String custsupptype = (String)paramMap.get("custsupptype");
        sumDataSet = EmptyUtil.isNoEmpty((String)custsupptype) && !"allside".equals(custsupptype) ? sumDataSet.filter("custsupptype = '" + paramMap.get("custsupptype") + "'") : sumDataSet.groupBy(new String[]{"orgid", "paymentday"}).sum("arapamt").sum("arapcount").sum("drdpamt").sum("drdpcount").sum("lastyeararapamt").sum("lastyeardrdpamt").sum("lastmontharapamt").sum("lastmonthdrdpamt").finish();
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        sumDataSet = orgDateSet.join(sumDataSet, JoinType.LEFT).on("orgid", "orgid").select(new String[]{"orgid", "rowid", "(case when Len(simplename) > 1 then simplename else orgname end) as org", "pid", "isgroupnode", "level", "0  as sumlevel", "sortcode"}, new String[]{"arapamt", "arapcount", "drdpamt", "drdpcount", "lastyeararapamt", "lastyeardrdpamt", "lastmontharapamt", "lastmonthdrdpamt"}).finish();
        sumDataSet = super.getSumDataSetByLevel(sumDataSet, Arrays.asList("arapamt", "arapcount", "drdpamt", "drdpcount", "lastyeararapamt", "lastyeardrdpamt", "lastmontharapamt", "lastmonthdrdpamt"), "orgid,org,sortcode").select(new String[]{"rowid", "pid", "isgroupnode", "level", "sumlevel", "orgid", "org", "arapamt", "arapcount", "drdpamt", "drdpcount", "lastyeararapamt", "lastyeardrdpamt", "lastmontharapamt", "lastmonthdrdpamt", "sortcode"}).filter("arapamt>0 or drdpamt>0");
        List filterOrg = EmptyUtil.isNoEmpty(paramMap.get("suborgids")) ? (List)paramMap.get("suborgids") : (List)paramMap.get("allorgids");
        if (CollectionUtils.isNotEmpty((Collection)filterOrg)) {
            sumDataSet = sumDataSet.filter("orgid in (" + TmcBusinessBaseHelper.idListToString((List)filterOrg) + ")");
        }
        if ((sumDataSet = sumDataSet.addFields(new String[]{"(case when lastyeararapamt > 0 then (arapamt-lastyeararapamt)*100/lastyeararapamt else 0 end)", "(case when lastmontharapamt > 0 then (arapamt-lastmontharapamt)*100/lastmontharapamt else 0 end)", "(case when lastyeardrdpamt > 0 then (drdpamt-lastyeardrdpamt)*100/lastyeardrdpamt else 0 end)", "(case when lastmonthdrdpamt > 0 then (drdpamt-lastmonthdrdpamt)*100/lastmonthdrdpamt else 0 end)", "arapamt/(arapamt+drdpamt)*100", "drdpamt/(arapamt+drdpamt)*100", "arapamt+drdpamt", String.valueOf(reportCurrency = Long.valueOf(((DynamicObject)paramMap.get("currency")).getLong("id")))}, new String[]{"lastyearcompare", "lastmonthcompare", "drdplastyearcompare", "drdplastmonthcompare", "arapratio", "drdpratio", "total", "entrycurrency"})).getRowMeta().getFieldIndex("sortcode", false) >= 0) {
            sumDataSet = sumDataSet.orderBy(new String[]{"sortcode"});
        }
        DataSet totalSet = this.addAllTotalDataSet(sumDataSet, Arrays.asList("arapamt", "arapcount", "drdpamt", "drdpcount", "total", "lastyeararapamt", "lastyeardrdpamt", "lastmontharapamt", "lastmonthdrdpamt"), Collections.singletonList("entrycurrency"), "org").updateFields(new String[]{"arapratio", "drdpratio", "lastyearcompare", "lastmonthcompare", "drdplastyearcompare", "drdplastmonthcompare"}, new String[]{"arapamt/(arapamt+drdpamt)*100", "drdpamt/(arapamt+drdpamt)*100", "(case when lastyeararapamt > 0 then (arapamt-lastyeararapamt)*100/lastyeararapamt else 0 end)", "(case when lastmontharapamt > 0 then (arapamt-lastmontharapamt)*100/lastmontharapamt else 0 end)", "(case when lastyeardrdpamt > 0 then (drdpamt-lastyeardrdpamt)*100/lastyeardrdpamt else 0 end)", "(case when lastmonthdrdpamt > 0 then (drdpamt-lastmonthdrdpamt)*100/lastmonthdrdpamt else 0 end)"});
        return sumDataSet.union(totalSet);
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> set = new HashSet<String>(3);
        set.add("arapamt");
        set.add("drdpamt");
        set.add("total");
        return set;
    }

    @Override
    protected String orgField() {
        return "orgid";
    }
}

