/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.arap.form;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.HomeOverviewHelper;

public class ArapDistributionRptFormPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final String[] ratioProps = new String[]{"arapratio", "drdpratio", "lastyearcompare", "lastmonthcompare", "drdplastyearcompare", "drdplastmonthcompare"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        ReportShowParameter parameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = parameter.getCustomParams();
        String paymentDay = (String)customParams.get("paymentDay");
        queryParam.getFilter().addFilterItem("paymentDay", (Object)paymentDay);
        String custsupptype = (String)customParams.get("custsupptype");
        queryParam.getFilter().addFilterItem("custsupptype", (Object)custsupptype);
        queryParam.getFilter().addFilterItem("orgViewNumber", (Object)this.getPageCache().get("orgViewNumber"));
        return super.verifyQuery(queryParam);
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)rowData)) {
            return;
        }
        Optional<BigDecimal> totalOptional = rowData.stream().filter(o -> o.getLong("sumlevel") == 0L).map(o -> o.getBigDecimal("total")).reduce(BigDecimal::add);
        BigDecimal total = totalOptional.isPresent() ? totalOptional.get() : null;
        for (DynamicObject row : rowData) {
            for (String ratioProp : ratioProps) {
                row.set(ratioProp, (Object)(new BigDecimal(EmptyUtil.isEmpty((String)row.getString(ratioProp)) ? "0" : row.getString(ratioProp)).setScale(2, RoundingMode.HALF_UP) + "%"));
                BigDecimal rowTotal = new BigDecimal(EmptyUtil.isEmpty((String)row.getString("total")) ? "0" : row.getString("total"));
                row.set("totalratio", (Object)(rowTotal.multiply(Constants.ONE_HUNDRED).divide(total, 2, RoundingMode.HALF_UP) + "%"));
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        int rowIndex = event.getRowIndex();
        ReportList rptList = (ReportList)event.getSource();
        DynamicObject row = rptList.getReportModel().getRowData(rowIndex);
        String isGroupNode = row.getString("isgroupnode");
        long orgId = row.getLong("orgid");
        if (orgId == 0L || !"groupnodevalue".equals(isGroupNode)) {
            return;
        }
        ReportQueryParam queryParam = this.getQueryParam();
        FilterInfo filter = queryParam.getFilter();
        ReportShowParameter param = new ReportShowParameter();
        param.getCustomParams().put("orgid", Long.toString(orgId));
        String formId = this.getView().getFormShowParameter().getFormId();
        param.getCustomParams().put("paymentDay", filter.getFilterItems("paymentDay") != null ? ((FilterItemInfo)filter.getFilterItems("paymentDay").get(0)).getValue() : null);
        param.getCustomParams().put("custsupptype", filter.getFilterItems("custsupptype") != null ? ((FilterItemInfo)filter.getFilterItems("custsupptype").get(0)).getValue() : null);
        param.getCustomParams().put("filter", SerializationUtils.serializeToBase64((Object)filter));
        param.getCustomParams().put("next", Boolean.TRUE);
        param.setFormId(formId);
        param.setCaption(this.getView().getFormShowParameter().getCaption());
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HomeOverviewHelper.hyperLinkClickFromHome((IReportView)this.getView(), (ReportShowParameter)param);
        this.getView().showForm((FormShowParameter)param);
    }
}

